/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.apache.nifi.web.util.WebClientUtils;
import org.glassfish.jersey.client.ClientConfig;

public class RemoteNiFiUtils {
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 10000;
    private final Client client;

    public RemoteNiFiUtils(SSLContext sslContext) {
        this.client = this.getClient(sslContext);
    }

    private Client getClient(SSLContext sslContext) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.readTimeout", (Object)10000);
        clientConfig.property("jersey.config.client.connectTimeout", (Object)10000);
        Client client = sslContext == null ? WebClientUtils.createClient((ClientConfig)clientConfig) : WebClientUtils.createClient((ClientConfig)clientConfig, (SSLContext)sslContext);
        return client;
    }

    public Response issueRegistrationRequest(String baseApiUri) {
        URI uri = URI.create(String.format("%s/controller/users", baseApiUri));
        MultivaluedHashMap entity = new MultivaluedHashMap();
        entity.add((Object)"justification", (Object)"A Remote instance of NiFi has attempted to create a reference to this NiFi. This action must be approved first.");
        return this.client.target(uri).request().post(Entity.form((MultivaluedMap)entity));
    }
}

