/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceApiLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceResolver;
import org.apache.nifi.flow.ControllerServiceAPI;
import org.apache.nifi.flow.ExternalControllerServiceReference;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedPropertyDescriptor;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.registry.flow.FlowSnapshotContainer;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;

public class StandardControllerServiceResolver
implements ControllerServiceResolver {
    private final Authorizer authorizer;
    private final FlowManager flowManager;
    private final NiFiRegistryFlowMapper flowMapper;
    private final ControllerServiceProvider controllerServiceProvider;
    private final ControllerServiceApiLookup controllerServiceApiLookup;

    public StandardControllerServiceResolver(Authorizer authorizer, FlowManager flowManager, NiFiRegistryFlowMapper flowMapper, ControllerServiceProvider controllerServiceProvider, ControllerServiceApiLookup controllerServiceApiLookup) {
        this.authorizer = authorizer;
        this.flowManager = flowManager;
        this.flowMapper = flowMapper;
        this.controllerServiceProvider = controllerServiceProvider;
        this.controllerServiceApiLookup = controllerServiceApiLookup;
    }

    public Set<String> resolveInheritedControllerServices(FlowSnapshotContainer flowSnapshotContainer, String parentGroupId, NiFiUser user) {
        RegisteredFlowSnapshot topLevelSnapshot = flowSnapshotContainer.getFlowSnapshot();
        VersionedProcessGroup versionedGroup = topLevelSnapshot.getFlowContents();
        Map externalControllerServiceReferences = topLevelSnapshot.getExternalControllerServices();
        ProcessGroup parentGroup = this.flowManager.getGroup(parentGroupId);
        Set ancestorServices = parentGroup.getControllerServices(true).stream().filter(serviceNode -> serviceNode.isAuthorized(this.authorizer, RequestAction.READ, user)).map(serviceNode -> this.flowMapper.mapControllerService((ControllerServiceNode)serviceNode, this.controllerServiceProvider, (Set<String>)new HashSet<String>(), (Map<String, ExternalControllerServiceReference>)new HashMap<String, ExternalControllerServiceReference>())).collect(Collectors.toSet());
        Stack<Set<VersionedControllerService>> serviceHierarchyStack = new Stack<Set<VersionedControllerService>>();
        serviceHierarchyStack.push(ancestorServices);
        HashSet<String> unresolvedServices = new HashSet<String>();
        this.resolveInheritedControllerServices(flowSnapshotContainer, versionedGroup, externalControllerServiceReferences, serviceHierarchyStack, unresolvedServices);
        return unresolvedServices;
    }

    private void resolveInheritedControllerServices(FlowSnapshotContainer flowSnapshotContainer, VersionedProcessGroup versionedGroup, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences, Stack<Set<VersionedControllerService>> serviceHierarchyStack, Set<String> unresolvedServices) {
        Set currentGroupServices = versionedGroup.getControllerServices() == null ? Collections.emptySet() : versionedGroup.getControllerServices();
        serviceHierarchyStack.push(currentGroupServices);
        Set<VersionedControllerService> availableControllerServices = serviceHierarchyStack.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        for (VersionedProcessor processor : versionedGroup.getProcessors()) {
            this.resolveInheritedControllerServices((VersionedConfigurableExtension)processor, availableControllerServices, externalControllerServiceReferences, unresolvedServices);
        }
        for (VersionedControllerService service : versionedGroup.getControllerServices()) {
            this.resolveInheritedControllerServices((VersionedConfigurableExtension)service, availableControllerServices, externalControllerServiceReferences, unresolvedServices);
        }
        for (VersionedProcessGroup child : versionedGroup.getProcessGroups()) {
            RegisteredFlowSnapshot childSnapshot;
            Map<Object, Object> childExternalServices = child.getVersionedFlowCoordinates() == null ? externalControllerServiceReferences : ((childSnapshot = flowSnapshotContainer.getChildSnapshot(child.getIdentifier())) == null ? Collections.emptyMap() : childSnapshot.getExternalControllerServices());
            this.resolveInheritedControllerServices(flowSnapshotContainer, child, childExternalServices, serviceHierarchyStack, unresolvedServices);
        }
        serviceHierarchyStack.pop();
    }

    private void resolveInheritedControllerServices(VersionedConfigurableExtension component, Set<VersionedControllerService> availableControllerServices, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences, Set<String> unresolvedServices) {
        Map componentRequiredApis = this.controllerServiceApiLookup.getRequiredServiceApis(component.getType(), component.getBundle());
        if (componentRequiredApis.isEmpty()) {
            return;
        }
        Map propertyDescriptors = component.getPropertyDescriptors();
        Map componentProperties = component.getProperties();
        for (Map.Entry entry : componentProperties.entrySet()) {
            ExternalControllerServiceReference externalServiceReference;
            VersionedPropertyDescriptor propertyDescriptor;
            String propertyName = (String)entry.getKey();
            String propertyValue = (String)entry.getValue();
            if (propertyValue == null || (propertyDescriptor = (VersionedPropertyDescriptor)propertyDescriptors.get(propertyName)) == null || !propertyDescriptor.getIdentifiesControllerService()) continue;
            Set availableControllerServiceIds = availableControllerServices.stream().map(VersionedComponent::getIdentifier).collect(Collectors.toSet());
            if (availableControllerServiceIds.contains(propertyValue)) {
                unresolvedServices.add(propertyValue);
                continue;
            }
            ExternalControllerServiceReference externalControllerServiceReference = externalServiceReference = externalControllerServiceReferences == null ? null : externalControllerServiceReferences.get(propertyValue);
            if (externalServiceReference == null) {
                unresolvedServices.add(propertyValue);
                continue;
            }
            ControllerServiceAPI descriptorRequiredApi = (ControllerServiceAPI)componentRequiredApis.get(propertyName);
            if (descriptorRequiredApi == null) {
                unresolvedServices.add(propertyValue);
                continue;
            }
            String externalControllerServiceName = externalServiceReference.getName();
            List matchingControllerServices = availableControllerServices.stream().filter(service -> service.getName().equals(externalControllerServiceName)).filter(service -> this.implementsApi(descriptorRequiredApi, (VersionedControllerService)service)).collect(Collectors.toList());
            if (matchingControllerServices.size() != 1) {
                unresolvedServices.add(propertyValue);
                continue;
            }
            VersionedControllerService matchingService = (VersionedControllerService)matchingControllerServices.get(0);
            String resolvedId = matchingService.getIdentifier();
            componentProperties.put(propertyName, resolvedId);
        }
    }

    private boolean implementsApi(ControllerServiceAPI requiredServiceApi, VersionedControllerService versionedControllerService) {
        if (versionedControllerService.getControllerServiceApis() == null) {
            return false;
        }
        for (ControllerServiceAPI implementedApi : versionedControllerService.getControllerServiceApis()) {
            if (!implementedApi.getType().equals(requiredServiceApi.getType()) || !implementedApi.getBundle().getGroup().equals(requiredServiceApi.getBundle().getGroup()) || !implementedApi.getBundle().getArtifact().equals(requiredServiceApi.getBundle().getArtifact())) continue;
            return true;
        }
        return false;
    }
}

