/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.RepositoryStatusReport;
import org.apache.nifi.controller.repository.metrics.EmptyFlowFileEvent;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.LoadBalanceStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessingPerformanceStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.RunStatus;
import org.apache.nifi.controller.status.TransmissionStatus;
import org.apache.nifi.controller.status.analytics.ConnectionStatusPredictions;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsEngine;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.VersionedFlowStatus;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.PerformanceMetricsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventAccess
implements EventAccess {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEventAccess.class);
    private static final Predicate<Authorizable> AUTHORIZATION_APPROVED = authorizable -> true;
    private static final Predicate<Authorizable> AUTHORIZATION_DENIED = authorizable -> false;
    private final ProcessScheduler processScheduler;
    private final StatusAnalyticsEngine statusAnalyticsEngine;
    private final FlowManager flowManager;
    private final FlowFileEventRepository flowFileEventRepository;

    public AbstractEventAccess(ProcessScheduler processScheduler, StatusAnalyticsEngine analyticsEngine, FlowManager flowManager, FlowFileEventRepository flowFileEventRepository) {
        this.processScheduler = processScheduler;
        this.statusAnalyticsEngine = analyticsEngine;
        this.flowManager = flowManager;
        this.flowFileEventRepository = flowFileEventRepository;
    }

    public ProcessGroupStatus getGroupStatus(String groupId) {
        RepositoryStatusReport statusReport = this.generateRepositoryStatusReport();
        ProcessGroup group = this.flowManager.getGroup(groupId);
        return this.getGroupStatus(group, statusReport, AUTHORIZATION_APPROVED, Integer.MAX_VALUE, 1, true);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport) {
        ProcessGroup group = this.flowManager.getGroup(groupId);
        return this.getGroupStatus(group, statusReport, AUTHORIZATION_APPROVED, Integer.MAX_VALUE, 1, false);
    }

    protected RepositoryStatusReport generateRepositoryStatusReport() {
        return this.flowFileEventRepository.reportTransferEvents(System.currentTimeMillis());
    }

    ProcessGroupStatus getGroupStatus(ProcessGroup group, RepositoryStatusReport statusReport, Predicate<Authorizable> checkAuthorization, int recursiveStatusDepth, int currentDepth, boolean includeConnectionDetails) {
        int statelessActiveThreadCount;
        if (group == null) {
            return null;
        }
        ProcessGroupStatus status = new ProcessGroupStatus();
        status.setId(group.getIdentifier());
        status.setName(checkAuthorization.test((Authorizable)group) ? group.getName() : group.getIdentifier());
        int activeGroupThreads = 0;
        int terminatedGroupThreads = 0;
        long bytesRead = 0L;
        long bytesWritten = 0L;
        int queuedCount = 0;
        long queuedContentSize = 0L;
        int flowFilesIn = 0;
        long bytesIn = 0L;
        int flowFilesOut = 0;
        long bytesOut = 0L;
        int flowFilesReceived = 0;
        long bytesReceived = 0L;
        int flowFilesSent = 0;
        long bytesSent = 0L;
        int flowFilesTransferred = 0;
        long bytesTransferred = 0L;
        long processingNanos = 0L;
        ProcessingPerformanceStatus performanceStatus = new ProcessingPerformanceStatus();
        performanceStatus.setIdentifier(group.getIdentifier());
        boolean populateChildStatuses = currentDepth <= recursiveStatusDepth;
        Predicate<Authorizable> isAuthorized = populateChildStatuses ? checkAuthorization : AUTHORIZATION_DENIED;
        ArrayList<ProcessorStatus> processorStatusCollection = new ArrayList<ProcessorStatus>();
        status.setProcessorStatus(processorStatusCollection);
        for (Object procNode : group.getProcessors()) {
            ProcessorStatus procStat = this.getProcessorStatus(statusReport, (ProcessorNode)procNode, isAuthorized);
            if (populateChildStatuses) {
                processorStatusCollection.add(procStat);
            }
            activeGroupThreads += procStat.getActiveThreadCount();
            terminatedGroupThreads += procStat.getTerminatedThreadCount();
            bytesRead += procStat.getBytesRead();
            bytesWritten += procStat.getBytesWritten();
            flowFilesReceived += procStat.getFlowFilesReceived();
            bytesReceived += procStat.getBytesReceived();
            flowFilesSent += procStat.getFlowFilesSent();
            bytesSent += procStat.getBytesSent();
            processingNanos += procStat.getProcessingNanos();
            ProcessingPerformanceStatus processorPerformanceStatus = procStat.getProcessingPerformanceStatus();
            if (processorPerformanceStatus == null) continue;
            performanceStatus.setCpuDuration(performanceStatus.getCpuDuration() + processorPerformanceStatus.getCpuDuration());
            performanceStatus.setContentReadDuration(performanceStatus.getContentReadDuration() + processorPerformanceStatus.getContentReadDuration());
            performanceStatus.setContentWriteDuration(performanceStatus.getContentWriteDuration() + processorPerformanceStatus.getContentWriteDuration());
            performanceStatus.setSessionCommitDuration(performanceStatus.getSessionCommitDuration() + processorPerformanceStatus.getSessionCommitDuration());
            performanceStatus.setGarbageCollectionDuration(performanceStatus.getGarbageCollectionDuration() + processorPerformanceStatus.getGarbageCollectionDuration());
        }
        ArrayList<ProcessGroupStatus> localChildGroupStatusCollection = new ArrayList<ProcessGroupStatus>();
        status.setProcessGroupStatus(localChildGroupStatusCollection);
        for (Object childGroup : group.getProcessGroups()) {
            ProcessGroupStatus childGroupStatus;
            if (populateChildStatuses) {
                childGroupStatus = this.getGroupStatus((ProcessGroup)childGroup, statusReport, isAuthorized, recursiveStatusDepth, currentDepth + 1, includeConnectionDetails);
                localChildGroupStatusCollection.add(childGroupStatus);
            } else {
                childGroupStatus = this.getGroupStatus((ProcessGroup)childGroup, statusReport, AUTHORIZATION_DENIED, recursiveStatusDepth, currentDepth + 1, includeConnectionDetails);
            }
            activeGroupThreads += childGroupStatus.getActiveThreadCount().intValue();
            terminatedGroupThreads += childGroupStatus.getTerminatedThreadCount().intValue();
            bytesRead += childGroupStatus.getBytesRead().longValue();
            bytesWritten += childGroupStatus.getBytesWritten().longValue();
            queuedCount += childGroupStatus.getQueuedCount().intValue();
            queuedContentSize += childGroupStatus.getQueuedContentSize().longValue();
            flowFilesReceived += childGroupStatus.getFlowFilesReceived();
            bytesReceived += childGroupStatus.getBytesReceived();
            flowFilesSent += childGroupStatus.getFlowFilesSent();
            bytesSent += childGroupStatus.getBytesSent();
            flowFilesTransferred += childGroupStatus.getFlowFilesTransferred();
            bytesTransferred += childGroupStatus.getBytesTransferred();
            processingNanos += childGroupStatus.getProcessingNanos();
            ProcessingPerformanceStatus childGroupPerformanceStatus = childGroupStatus.getProcessingPerformanceStatus();
            if (childGroupPerformanceStatus == null) continue;
            performanceStatus.setCpuDuration(performanceStatus.getCpuDuration() + childGroupPerformanceStatus.getCpuDuration());
            performanceStatus.setContentReadDuration(performanceStatus.getContentReadDuration() + childGroupPerformanceStatus.getContentReadDuration());
            performanceStatus.setContentWriteDuration(performanceStatus.getContentWriteDuration() + childGroupPerformanceStatus.getContentWriteDuration());
            performanceStatus.setSessionCommitDuration(performanceStatus.getSessionCommitDuration() + childGroupPerformanceStatus.getSessionCommitDuration());
            performanceStatus.setGarbageCollectionDuration(performanceStatus.getGarbageCollectionDuration() + childGroupPerformanceStatus.getGarbageCollectionDuration());
        }
        ArrayList<RemoteProcessGroupStatus> remoteProcessGroupStatusCollection = new ArrayList<RemoteProcessGroupStatus>();
        status.setRemoteProcessGroupStatus(remoteProcessGroupStatusCollection);
        for (RemoteProcessGroup remoteGroup : group.getRemoteProcessGroups()) {
            RemoteProcessGroupStatus remoteStatus = this.createRemoteGroupStatus(remoteGroup, statusReport, isAuthorized);
            if (remoteStatus == null) continue;
            if (populateChildStatuses) {
                remoteProcessGroupStatusCollection.add(remoteStatus);
            }
            flowFilesReceived += remoteStatus.getReceivedCount().intValue();
            bytesReceived += remoteStatus.getReceivedContentSize().longValue();
            flowFilesSent += remoteStatus.getSentCount().intValue();
            bytesSent += remoteStatus.getSentContentSize().longValue();
        }
        ArrayList<ConnectionStatus> connectionStatusCollection = new ArrayList<ConnectionStatus>();
        status.setConnectionStatus(connectionStatusCollection);
        long now = System.currentTimeMillis();
        for (Connection conn : group.getConnections()) {
            Connectable destination;
            FlowFileQueue flowFileQueue;
            LoadBalanceStrategy loadBalanceStrategy;
            boolean isConnectionAuthorized = isAuthorized.test((Authorizable)conn);
            boolean isSourceAuthorized = isAuthorized.test((Authorizable)conn.getSource());
            boolean isDestinationAuthorized = isAuthorized.test((Authorizable)conn.getDestination());
            ConnectionStatus connStatus = new ConnectionStatus();
            connStatus.setId(conn.getIdentifier());
            connStatus.setGroupId(conn.getProcessGroup().getIdentifier());
            connStatus.setSourceId(conn.getSource().getIdentifier());
            connStatus.setSourceName(isSourceAuthorized ? conn.getSource().getName() : conn.getSource().getIdentifier());
            connStatus.setDestinationId(conn.getDestination().getIdentifier());
            connStatus.setDestinationName(isDestinationAuthorized ? conn.getDestination().getName() : conn.getDestination().getIdentifier());
            connStatus.setBackPressureDataSizeThreshold(conn.getFlowFileQueue().getBackPressureDataSizeThreshold());
            connStatus.setBackPressureObjectThreshold(conn.getFlowFileQueue().getBackPressureObjectThreshold());
            if (includeConnectionDetails) {
                connStatus.setTotalQueuedDuration(conn.getFlowFileQueue().getTotalQueuedDuration(now));
                long minLastQueueDate = conn.getFlowFileQueue().getMinLastQueueDate();
                connStatus.setMaxQueuedDuration(minLastQueueDate == 0L ? 0L : now - minLastQueueDate);
            } else {
                connStatus.setTotalQueuedDuration(0L);
                connStatus.setMaxQueuedDuration(0L);
            }
            connStatus.setFlowFileAvailability(conn.getFlowFileQueue().getFlowFileAvailability());
            FlowFileEvent connectionStatusReport = statusReport.getReportEntry(conn.getIdentifier());
            if (connectionStatusReport != null) {
                connStatus.setInputBytes(connectionStatusReport.getContentSizeIn());
                connStatus.setInputCount(connectionStatusReport.getFlowFilesIn());
                connStatus.setOutputBytes(connectionStatusReport.getContentSizeOut());
                connStatus.setOutputCount(connectionStatusReport.getFlowFilesOut());
                flowFilesTransferred += connectionStatusReport.getFlowFilesIn() + connectionStatusReport.getFlowFilesOut();
                bytesTransferred += connectionStatusReport.getContentSizeIn() + connectionStatusReport.getContentSizeOut();
            }
            if (this.statusAnalyticsEngine != null) {
                StatusAnalytics statusAnalytics = this.statusAnalyticsEngine.getStatusAnalytics(conn.getIdentifier());
                if (statusAnalytics != null) {
                    Map predictionValues = statusAnalytics.getPredictions();
                    ConnectionStatusPredictions predictions = new ConnectionStatusPredictions();
                    connStatus.setPredictions(predictions);
                    predictions.setPredictedTimeToBytesBackpressureMillis(((Long)predictionValues.get("timeToBytesBackpressureMillis")).longValue());
                    predictions.setPredictedTimeToCountBackpressureMillis(((Long)predictionValues.get("timeToCountBackpressureMillis")).longValue());
                    predictions.setNextPredictedQueuedBytes(((Long)predictionValues.get("nextIntervalBytes")).longValue());
                    predictions.setNextPredictedQueuedCount(((Long)predictionValues.get("nextIntervalCount")).intValue());
                    predictions.setPredictedPercentCount(((Long)predictionValues.get("nextIntervalPercentageUseCount")).intValue());
                    predictions.setPredictedPercentBytes(((Long)predictionValues.get("nextIntervalPercentageUseBytes")).intValue());
                    predictions.setPredictionIntervalMillis(((Long)predictionValues.get("intervalTimeMillis")).longValue());
                }
            } else {
                connStatus.setPredictions(null);
            }
            if (isConnectionAuthorized) {
                if (StringUtils.isNotBlank((CharSequence)conn.getName())) {
                    connStatus.setName(conn.getName());
                } else if (conn.getRelationships() != null && !conn.getRelationships().isEmpty()) {
                    ArrayList<String> relationships = new ArrayList<String>(conn.getRelationships().size());
                    for (Relationship relationship : conn.getRelationships()) {
                        relationships.add(relationship.getName());
                    }
                    connStatus.setName(StringUtils.join(relationships, (String)", "));
                }
            } else {
                connStatus.setName(conn.getIdentifier());
            }
            QueueSize queueSize = conn.getFlowFileQueue().size();
            int connectionQueuedCount = queueSize.getObjectCount();
            long connectionQueuedBytes = queueSize.getByteCount();
            if (connectionQueuedCount > 0) {
                connStatus.setQueuedBytes(connectionQueuedBytes);
                connStatus.setQueuedCount(connectionQueuedCount);
            }
            if ((loadBalanceStrategy = (flowFileQueue = conn.getFlowFileQueue()).getLoadBalanceStrategy()) == LoadBalanceStrategy.DO_NOT_LOAD_BALANCE) {
                connStatus.setLoadBalanceStatus(LoadBalanceStatus.LOAD_BALANCE_NOT_CONFIGURED);
            } else if (flowFileQueue.isActivelyLoadBalancing()) {
                connStatus.setLoadBalanceStatus(LoadBalanceStatus.LOAD_BALANCE_ACTIVE);
            } else {
                connStatus.setLoadBalanceStatus(LoadBalanceStatus.LOAD_BALANCE_INACTIVE);
            }
            if (populateChildStatuses) {
                connectionStatusCollection.add(connStatus);
            }
            queuedCount += connectionQueuedCount;
            queuedContentSize += connectionQueuedBytes;
            Connectable source = conn.getSource();
            if (ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)source.getConnectableType())) {
                RemoteGroupPort remoteOutputPort = (RemoteGroupPort)source;
                activeGroupThreads += this.processScheduler.getActiveThreadCount((Object)remoteOutputPort);
            }
            if (!ConnectableType.REMOTE_INPUT_PORT.equals((Object)(destination = conn.getDestination()).getConnectableType())) continue;
            RemoteGroupPort remoteInputPort = (RemoteGroupPort)destination;
            activeGroupThreads += this.processScheduler.getActiveThreadCount((Object)remoteInputPort);
        }
        ArrayList<PortStatus> inputPortStatusCollection = new ArrayList<PortStatus>();
        status.setInputPortStatus(inputPortStatusCollection);
        Set inputPorts = group.getInputPorts();
        for (Port port : inputPorts) {
            FlowFileEvent entry;
            boolean isInputPortAuthorized = isAuthorized.test((Authorizable)port);
            PortStatus portStatus = new PortStatus();
            portStatus.setId(port.getIdentifier());
            portStatus.setGroupId(port.getProcessGroup().getIdentifier());
            portStatus.setName(isInputPortAuthorized ? port.getName() : port.getIdentifier());
            portStatus.setActiveThreadCount(Integer.valueOf(this.processScheduler.getActiveThreadCount((Object)port)));
            if (ScheduledState.RUNNING.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Running);
            } else if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Disabled);
            } else if (!port.isValid()) {
                portStatus.setRunStatus(RunStatus.Invalid);
            } else {
                portStatus.setRunStatus(RunStatus.Stopped);
            }
            if (port instanceof PublicPort) {
                portStatus.setTransmitting(Boolean.valueOf(((PublicPort)port).isTransmitting()));
            }
            if ((entry = (FlowFileEvent)statusReport.getReportEntries().get(port.getIdentifier())) == null) {
                portStatus.setInputBytes(0L);
                portStatus.setInputCount(0);
                portStatus.setOutputBytes(0L);
                portStatus.setOutputCount(0);
            } else {
                int processedCount = entry.getFlowFilesOut();
                long numProcessedBytes = entry.getContentSizeOut();
                portStatus.setOutputBytes(numProcessedBytes);
                portStatus.setOutputCount(processedCount);
                int inputCount = entry.getFlowFilesIn();
                long inputBytes = entry.getContentSizeIn();
                portStatus.setInputBytes(inputBytes);
                portStatus.setInputCount(inputCount);
                flowFilesIn += port instanceof PublicPort ? entry.getFlowFilesReceived() : inputCount;
                bytesIn += port instanceof PublicPort ? entry.getBytesReceived() : inputBytes;
                bytesWritten += entry.getBytesWritten();
                flowFilesReceived += entry.getFlowFilesReceived();
                bytesReceived += entry.getBytesReceived();
            }
            if (populateChildStatuses) {
                inputPortStatusCollection.add(portStatus);
            }
            activeGroupThreads += portStatus.getActiveThreadCount().intValue();
        }
        ArrayList<PortStatus> outputPortStatusCollection = new ArrayList<PortStatus>();
        status.setOutputPortStatus(outputPortStatusCollection);
        Set outputPorts = group.getOutputPorts();
        for (Port port : outputPorts) {
            FlowFileEvent entry;
            boolean isOutputPortAuthorized = isAuthorized.test((Authorizable)port);
            PortStatus portStatus = new PortStatus();
            portStatus.setId(port.getIdentifier());
            portStatus.setGroupId(port.getProcessGroup().getIdentifier());
            portStatus.setName(isOutputPortAuthorized ? port.getName() : port.getIdentifier());
            portStatus.setActiveThreadCount(Integer.valueOf(this.processScheduler.getActiveThreadCount((Object)port)));
            if (ScheduledState.RUNNING.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Running);
            } else if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Disabled);
            } else if (!port.isValid()) {
                portStatus.setRunStatus(RunStatus.Invalid);
            } else {
                portStatus.setRunStatus(RunStatus.Stopped);
            }
            if (port instanceof PublicPort) {
                portStatus.setTransmitting(Boolean.valueOf(((PublicPort)port).isTransmitting()));
            }
            if ((entry = (FlowFileEvent)statusReport.getReportEntries().get(port.getIdentifier())) == null) {
                portStatus.setInputBytes(0L);
                portStatus.setInputCount(0);
                portStatus.setOutputBytes(0L);
                portStatus.setOutputCount(0);
            } else {
                int processedCount = entry.getFlowFilesOut();
                long numProcessedBytes = entry.getContentSizeOut();
                portStatus.setOutputBytes(numProcessedBytes);
                portStatus.setOutputCount(processedCount);
                int inputCount = entry.getFlowFilesIn();
                long inputBytes = entry.getContentSizeIn();
                portStatus.setInputBytes(inputBytes);
                portStatus.setInputCount(inputCount);
                bytesRead += entry.getBytesRead();
                flowFilesOut += port instanceof PublicPort ? entry.getFlowFilesSent() : entry.getFlowFilesOut();
                bytesOut += port instanceof PublicPort ? entry.getBytesSent() : entry.getContentSizeOut();
                flowFilesSent = entry.getFlowFilesSent();
                bytesSent += entry.getBytesSent();
            }
            if (populateChildStatuses) {
                outputPortStatusCollection.add(portStatus);
            }
            activeGroupThreads += portStatus.getActiveThreadCount().intValue();
        }
        for (Funnel funnel : group.getFunnels()) {
            activeGroupThreads += this.processScheduler.getActiveThreadCount((Object)funnel);
        }
        if (group.resolveExecutionEngine() == ExecutionEngine.STATELESS) {
            activeGroupThreads = statelessActiveThreadCount = this.processScheduler.getActiveThreadCount((Object)group);
        } else {
            statelessActiveThreadCount = 0;
        }
        status.setActiveThreadCount(Integer.valueOf(activeGroupThreads));
        status.setStatelessActiveThreadCount(Integer.valueOf(statelessActiveThreadCount));
        status.setTerminatedThreadCount(Integer.valueOf(terminatedGroupThreads));
        status.setBytesRead(Long.valueOf(bytesRead));
        status.setBytesWritten(Long.valueOf(bytesWritten));
        status.setQueuedCount(Integer.valueOf(queuedCount));
        status.setQueuedContentSize(Long.valueOf(queuedContentSize));
        status.setInputContentSize(Long.valueOf(bytesIn));
        status.setInputCount(Integer.valueOf(flowFilesIn));
        status.setOutputContentSize(Long.valueOf(bytesOut));
        status.setOutputCount(Integer.valueOf(flowFilesOut));
        status.setFlowFilesReceived(flowFilesReceived);
        status.setBytesReceived(bytesReceived);
        status.setFlowFilesSent(flowFilesSent);
        status.setBytesSent(bytesSent);
        status.setFlowFilesTransferred(flowFilesTransferred);
        status.setBytesTransferred(bytesTransferred);
        status.setProcessingNanos(processingNanos);
        status.setProcessingPerformanceStatus(performanceStatus);
        VersionControlInformation vci = group.getVersionControlInformation();
        if (vci != null) {
            try {
                VersionedFlowStatus flowStatus = vci.getStatus();
                if (flowStatus != null && flowStatus.getState() != null) {
                    status.setVersionedFlowState(flowStatus.getState());
                }
            }
            catch (Exception e) {
                logger.warn("Failed to determine Version Control State for {}. Will consider state to be SYNC_FAILURE", (Object)group, (Object)e);
                status.setVersionedFlowState(VersionedFlowState.SYNC_FAILURE);
            }
        }
        return status;
    }

    private RemoteProcessGroupStatus createRemoteGroupStatus(RemoteProcessGroup remoteGroup, RepositoryStatusReport statusReport, Predicate<Authorizable> isAuthorized) {
        FlowFileEvent portEvent;
        boolean isConnected;
        boolean isRemoteProcessGroupAuthorized = isAuthorized.test((Authorizable)remoteGroup);
        int receivedCount = 0;
        long receivedContentSize = 0L;
        int sentCount = 0;
        long sentContentSize = 0L;
        int activeThreadCount = 0;
        int activePortCount = 0;
        int inactivePortCount = 0;
        RemoteProcessGroupStatus status = new RemoteProcessGroupStatus();
        status.setGroupId(remoteGroup.getProcessGroup().getIdentifier());
        status.setName(isRemoteProcessGroupAuthorized ? remoteGroup.getName() : remoteGroup.getIdentifier());
        status.setComments(isRemoteProcessGroupAuthorized ? remoteGroup.getComments() : null);
        status.setAuthorizationIssue(remoteGroup.getAuthorizationIssue());
        status.setLastRefreshTime(remoteGroup.getLastRefreshTime());
        status.setTargetUri(isRemoteProcessGroupAuthorized ? remoteGroup.getTargetUri() : null);
        long lineageMillis = 0L;
        int flowFilesRemoved = 0;
        int flowFilesTransferred = 0;
        for (Port port : remoteGroup.getInputPorts()) {
            isConnected = port.hasIncomingConnection();
            if (!isConnected) continue;
            if (port.isRunning()) {
                ++activePortCount;
            } else {
                ++inactivePortCount;
            }
            activeThreadCount += this.processScheduler.getActiveThreadCount((Object)port);
            portEvent = statusReport.getReportEntry(port.getIdentifier());
            if (portEvent == null) continue;
            lineageMillis += portEvent.getAggregateLineageMillis();
            flowFilesRemoved += portEvent.getFlowFilesRemoved();
            flowFilesTransferred += portEvent.getFlowFilesOut();
            sentCount += portEvent.getFlowFilesSent();
            sentContentSize += portEvent.getBytesSent();
        }
        for (Port port : remoteGroup.getOutputPorts()) {
            isConnected = !port.getConnections().isEmpty();
            if (!isConnected) continue;
            if (port.isRunning()) {
                ++activePortCount;
            } else {
                ++inactivePortCount;
            }
            activeThreadCount += this.processScheduler.getActiveThreadCount((Object)port);
            portEvent = statusReport.getReportEntry(port.getIdentifier());
            if (portEvent == null) continue;
            receivedCount += portEvent.getFlowFilesReceived();
            receivedContentSize += portEvent.getBytesReceived();
        }
        status.setId(remoteGroup.getIdentifier());
        status.setTransmissionStatus(remoteGroup.isConfiguredToTransmit() ? TransmissionStatus.Transmitting : TransmissionStatus.NotTransmitting);
        status.setActiveThreadCount(Integer.valueOf(activeThreadCount));
        status.setReceivedContentSize(Long.valueOf(receivedContentSize));
        status.setReceivedCount(Integer.valueOf(receivedCount));
        status.setSentContentSize(Long.valueOf(sentContentSize));
        status.setSentCount(Integer.valueOf(sentCount));
        status.setActiveRemotePortCount(Integer.valueOf(activePortCount));
        status.setInactiveRemotePortCount(Integer.valueOf(inactivePortCount));
        int flowFilesOutOrRemoved = flowFilesTransferred + flowFilesRemoved;
        status.setAverageLineageDuration(flowFilesOutOrRemoved == 0 ? 0L : lineageMillis / (long)flowFilesOutOrRemoved, TimeUnit.MILLISECONDS);
        return status;
    }

    private ProcessorStatus getProcessorStatus(RepositoryStatusReport report, ProcessorNode procNode, Predicate<Authorizable> isAuthorized) {
        FlowFileEvent entry = (FlowFileEvent)report.getReportEntries().get(procNode.getIdentifier());
        return this.getProcessorStatus(entry, procNode, isAuthorized);
    }

    protected ProcessorStatus getProcessorStatus(FlowFileEvent flowFileEvent, ProcessorNode procNode, Predicate<Authorizable> isAuthorized) {
        boolean isProcessorAuthorized = isAuthorized.test((Authorizable)procNode);
        ProcessorStatus status = new ProcessorStatus();
        status.setId(procNode.getIdentifier());
        status.setGroupId(procNode.getProcessGroup().getIdentifier());
        status.setName(isProcessorAuthorized ? procNode.getName() : procNode.getIdentifier());
        status.setType(isProcessorAuthorized ? procNode.getComponentType() : "Processor");
        if (flowFileEvent != null && flowFileEvent != EmptyFlowFileEvent.INSTANCE) {
            int processedCount = flowFileEvent.getFlowFilesOut();
            long numProcessedBytes = flowFileEvent.getContentSizeOut();
            status.setOutputBytes(numProcessedBytes);
            status.setOutputCount(processedCount);
            int inputCount = flowFileEvent.getFlowFilesIn();
            long inputBytes = flowFileEvent.getContentSizeIn();
            status.setInputBytes(inputBytes);
            status.setInputCount(inputCount);
            long readBytes = flowFileEvent.getBytesRead();
            status.setBytesRead(readBytes);
            long writtenBytes = flowFileEvent.getBytesWritten();
            status.setBytesWritten(writtenBytes);
            status.setProcessingNanos(flowFileEvent.getProcessingNanoseconds());
            status.setInvocations(flowFileEvent.getInvocations());
            status.setAverageLineageDuration(flowFileEvent.getAverageLineageMillis());
            status.setFlowFilesReceived(flowFileEvent.getFlowFilesReceived());
            status.setBytesReceived(flowFileEvent.getBytesReceived());
            status.setFlowFilesSent(flowFileEvent.getFlowFilesSent());
            status.setBytesSent(flowFileEvent.getBytesSent());
            status.setFlowFilesRemoved(flowFileEvent.getFlowFilesRemoved());
            if (isProcessorAuthorized) {
                status.setCounters(flowFileEvent.getCounters());
            }
            ProcessingPerformanceStatus performanceStatus = PerformanceMetricsUtil.getPerformanceMetrics(flowFileEvent, procNode);
            status.setProcessingPerformanceStatus(performanceStatus);
        }
        if (ScheduledState.DISABLED.equals((Object)procNode.getScheduledState())) {
            status.setRunStatus(RunStatus.Disabled);
        } else if (ScheduledState.RUNNING.equals((Object)procNode.getScheduledState())) {
            status.setRunStatus(RunStatus.Running);
        } else if (procNode.getValidationStatus() == ValidationStatus.VALIDATING) {
            status.setRunStatus(RunStatus.Validating);
        } else if (procNode.getValidationStatus() == ValidationStatus.INVALID && procNode.getActiveThreadCount() == 0) {
            status.setRunStatus(RunStatus.Invalid);
        } else {
            status.setRunStatus(RunStatus.Stopped);
        }
        status.setExecutionNode(procNode.getExecutionNode());
        status.setTerminatedThreadCount(procNode.getTerminatedThreadCount());
        status.setActiveThreadCount(procNode.getActiveThreadCount());
        return status;
    }

    public ProcessGroupStatus getControllerStatus() {
        String rootGroupId = this.flowManager.getRootGroupId();
        ProcessGroup group = this.flowManager.getGroup(rootGroupId);
        RepositoryStatusReport statusReport = this.generateRepositoryStatusReport();
        return this.getGroupStatus(group, statusReport, AUTHORIZATION_APPROVED, Integer.MAX_VALUE, 1, true);
    }

    public List<ProvenanceEventRecord> getProvenanceEvents(long firstEventId, int maxRecords) throws IOException {
        return new ArrayList<ProvenanceEventRecord>(this.getProvenanceRepository().getEvents(firstEventId, maxRecords));
    }

    public long getTotalBytesRead() {
        return this.flowFileEventRepository.reportAggregateEvent().getBytesRead();
    }

    public long getTotalBytesWritten() {
        return this.flowFileEventRepository.reportAggregateEvent().getBytesWritten();
    }

    public long getTotalBytesSent() {
        return this.flowFileEventRepository.reportAggregateEvent().getBytesSent();
    }

    public long getTotalBytesReceived() {
        return this.flowFileEventRepository.reportAggregateEvent().getBytesReceived();
    }
}

