/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.processor.ComponentSpecificControllerServiceLookup;

public class StandardValidationContext
implements ValidationContext {
    private final ControllerServiceProvider controllerServiceProvider;
    private final Map<PropertyDescriptor, PropertyConfiguration> properties;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final Map<String, Boolean> expressionLanguageSupported;
    private final String annotationData;
    private final String groupId;
    private final String componentId;
    private final ParameterContext parameterContext;
    private final AtomicReference<Map<PropertyDescriptor, String>> effectiveValuesRef = new AtomicReference();
    private final boolean validateConnections;

    public StandardValidationContext(ControllerServiceProvider controllerServiceProvider, Map<PropertyDescriptor, PropertyConfiguration> properties, String annotationData, String groupId, String componentId, ParameterContext parameterContext, boolean validateConnections) {
        this.controllerServiceProvider = controllerServiceProvider;
        this.properties = new HashMap<PropertyDescriptor, PropertyConfiguration>(properties);
        this.annotationData = annotationData;
        this.groupId = groupId;
        this.componentId = componentId;
        this.parameterContext = parameterContext;
        this.validateConnections = validateConnections;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>(properties.size());
        for (Map.Entry<PropertyDescriptor, PropertyConfiguration> entry : properties.entrySet()) {
            String value;
            PropertyDescriptor desc = entry.getKey();
            PropertyConfiguration configuration = entry.getValue();
            String string = value = configuration == null ? null : configuration.getEffectiveValue((ParameterLookup)parameterContext);
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
        this.expressionLanguageSupported = new HashMap<String, Boolean>(properties.size());
        for (PropertyDescriptor descriptor : properties.keySet()) {
            this.expressionLanguageSupported.put(descriptor.getName(), descriptor.isExpressionLanguageSupported());
        }
    }

    public PropertyValue newPropertyValue(String rawValue) {
        StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), null);
        return new StandardPropertyValue((ResourceContext)resourceContext, rawValue, (ControllerServiceLookup)this.controllerServiceProvider, (ParameterLookup)this.parameterContext, Query.prepareWithParametersPreEvaluated((String)rawValue));
    }

    public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
        return new StandardExpressionLanguageCompiler((ParameterLookup)this.parameterContext);
    }

    public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
        ControllerServiceNode serviceNode = this.controllerServiceProvider.getControllerServiceNode(controllerService.getIdentifier());
        ProcessGroup serviceGroup = serviceNode.getProcessGroup();
        String serviceGroupId = serviceGroup == null ? null : serviceGroup.getIdentifier();
        return new StandardValidationContext(this.controllerServiceProvider, serviceNode.getProperties(), serviceNode.getAnnotationData(), serviceGroupId, serviceNode.getIdentifier(), serviceNode.getProcessGroup().getParameterContext(), this.validateConnections);
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        PropertyConfiguration configuredValue = this.properties.get(property);
        String effectiveValue = configuredValue == null ? property.getDefaultValue() : configuredValue.getEffectiveValue((ParameterLookup)this.parameterContext);
        StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), property);
        return new StandardPropertyValue((ResourceContext)resourceContext, effectiveValue, (ControllerServiceLookup)this.controllerServiceProvider, (ParameterLookup)this.parameterContext, this.preparedQueries.get(property));
    }

    public Map<PropertyDescriptor, String> getProperties() {
        Map<PropertyDescriptor, String> effectiveValues = this.effectiveValuesRef.get();
        if (effectiveValues != null) {
            return effectiveValues;
        }
        LinkedHashMap<PropertyDescriptor, String> valueMap = new LinkedHashMap<PropertyDescriptor, String>();
        for (Map.Entry<PropertyDescriptor, PropertyConfiguration> entry : this.properties.entrySet()) {
            PropertyDescriptor descriptor = entry.getKey();
            PropertyConfiguration configuration = entry.getValue();
            String value = configuration == null ? descriptor.getDefaultValue() : configuration.getEffectiveValue((ParameterLookup)this.parameterContext);
            valueMap.put(entry.getKey(), value);
        }
        Map<PropertyDescriptor, String> immutableValueMap = Collections.unmodifiableMap(valueMap);
        this.effectiveValuesRef.compareAndSet(null, immutableValueMap);
        return immutableValueMap;
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return new ComponentSpecificControllerServiceLookup(this.controllerServiceProvider, this.componentId, this.groupId);
    }

    public boolean isValidationRequired(ControllerService service) {
        ControllerServiceState serviceState = this.controllerServiceProvider.getControllerServiceNode(service.getIdentifier()).getState();
        return serviceState != ControllerServiceState.ENABLED && serviceState != ControllerServiceState.ENABLING;
    }

    public boolean isExpressionLanguagePresent(String value) {
        if (value == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)value);
        return elRanges != null && !elRanges.isEmpty();
    }

    public boolean isExpressionLanguageSupported(String propertyName) {
        Boolean supported = this.expressionLanguageSupported.get(propertyName);
        return Boolean.TRUE.equals(supported);
    }

    public String getProcessGroupIdentifier() {
        return this.groupId;
    }

    public Collection<String> getReferencedParameters(String propertyName) {
        PropertyDescriptor descriptor = new PropertyDescriptor.Builder().name(propertyName).build();
        PropertyConfiguration configuration = this.properties.get(descriptor);
        if (configuration == null) {
            return Collections.emptyList();
        }
        List references = configuration.getParameterReferences();
        List<String> parameterNames = references.stream().map(ParameterReference::getParameterName).collect(Collectors.toList());
        return parameterNames;
    }

    public boolean isParameterDefined(String parameterName) {
        if (this.parameterContext == null) {
            return false;
        }
        return this.parameterContext.getParameter(parameterName).isPresent();
    }

    public boolean isParameterSet(String parameterName) {
        if (this.parameterContext == null) {
            return false;
        }
        Optional parameterOption = this.parameterContext.getParameter(parameterName);
        if (!parameterOption.isPresent()) {
            return false;
        }
        String value = ((Parameter)parameterOption.get()).getValue();
        return value != null;
    }

    public boolean isValidateConnections() {
        return this.validateConnections;
    }

    public String toString() {
        return "StandardValidationContext[componentId=" + this.componentId + ", properties=" + String.valueOf(this.properties) + "]";
    }
}

