/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.migration.RelationshipConfiguration;
import org.apache.nifi.processor.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRelationshipConfiguration
implements RelationshipConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(StandardRelationshipConfiguration.class);
    private final Set<String> relationships;
    private final ProcessorNode processor;

    public StandardRelationshipConfiguration(ProcessorNode processor) {
        this.processor = processor;
        HashSet<String> usedRelationships = new HashSet<String>();
        processor.getAutoTerminatedRelationships().stream().map(Relationship::getName).forEach(usedRelationships::add);
        usedRelationships.addAll(processor.getRetriedRelationships());
        for (Connection connection : processor.getConnections()) {
            connection.getRelationships().stream().map(Relationship::getName).forEach(usedRelationships::add);
        }
        this.relationships = usedRelationships;
    }

    public boolean renameRelationship(String relationshipName, String newName) {
        if (relationshipName.equals(newName)) {
            return false;
        }
        return this.replaceRelationship("rename", relationshipName, newName, new String[0]);
    }

    public boolean splitRelationship(String relationshipName, String firstRelationshipName, String ... additionalRelationshipNames) {
        return this.replaceRelationship("split", relationshipName, firstRelationshipName, additionalRelationshipNames);
    }

    private boolean replaceRelationship(String task, String relationshipName, String firstRelationshipName, String ... additionalRelationshipNames) {
        if (!this.relationships.contains(relationshipName)) {
            logger.debug("Will not {} Relationship [{}] for [{}] because it is not known", new Object[]{task, relationshipName, this.processor});
            return false;
        }
        ArrayList<String> newRelationshipNames = new ArrayList<String>(additionalRelationshipNames.length + 1);
        newRelationshipNames.add(firstRelationshipName);
        newRelationshipNames.addAll(Arrays.asList(additionalRelationshipNames));
        for (String newName : newRelationshipNames) {
            if (!this.relationships.contains(newName) || newName.equals(relationshipName)) continue;
            throw new IllegalStateException("Cannot %s Relationship %s to %s for %s because a Relationship already exists with the name %s".formatted(task, relationshipName, newRelationshipNames, this.processor, newName));
        }
        Relationship existingRelationship = this.processor.getRelationship(relationshipName);
        HashSet<Relationship> newRelationships = new HashSet<Relationship>();
        for (String newRelationshipName : newRelationshipNames) {
            Relationship newRelationship = new Relationship.Builder().name(newRelationshipName).autoTerminateDefault(existingRelationship.isAutoTerminated()).description(existingRelationship.getDescription()).build();
            newRelationships.add(newRelationship);
        }
        HashSet<Relationship> autoTerminated = new HashSet<Relationship>(this.processor.getAutoTerminatedRelationships());
        boolean removed = autoTerminated.remove(existingRelationship);
        if (removed) {
            autoTerminated.addAll(newRelationships);
            this.processor.setAutoTerminatedRelationships(autoTerminated);
            logger.info("Removed {} from {}'s Auto-terminated Relationships and replaced with {}", new Object[]{existingRelationship, this.processor, newRelationships});
        } else {
            logger.debug("{} is not auto-terminated for {} so will not replace its auto-terminated Relationships", (Object)existingRelationship, (Object)this.processor);
        }
        Set connections = this.processor.getConnections(existingRelationship);
        if (connections.isEmpty()) {
            logger.debug("There are no outgoing connections from {} for {} so will not update any connections", (Object)existingRelationship, (Object)this.processor);
        } else {
            for (Connection connection : connections) {
                HashSet<Relationship> connectionRelationships = new HashSet<Relationship>(connection.getRelationships());
                connectionRelationships.remove(existingRelationship);
                connectionRelationships.addAll(newRelationships);
                connection.setRelationships(connectionRelationships);
                logger.info("Removed {} from {} and replaced with {}", new Object[]{existingRelationship, connection, newRelationshipNames});
            }
        }
        HashSet<String> retriedRelationshipNames = new HashSet<String>(this.processor.getRetriedRelationships());
        if (retriedRelationshipNames.remove(relationshipName)) {
            retriedRelationshipNames.addAll(newRelationshipNames);
            this.processor.setRetriedRelationships(retriedRelationshipNames);
            logger.info("Removed {} from {}'s list of auto-retried Relationships and replaced with {}", new Object[]{existingRelationship, this.processor, newRelationships});
        } else {
            logger.debug("{} was not automatically retried for {}", (Object)existingRelationship, (Object)this.processor);
        }
        return true;
    }

    public boolean hasRelationship(String relationshipName) {
        return this.relationships.contains(relationshipName);
    }
}

