/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.asset.AssetManager;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ComponentAuthorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.VersionedComponent;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Positionable;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.DropFlowFileRequest;
import org.apache.nifi.controller.queue.DropFlowFileState;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.synchronization.StandardVersionedComponentSynchronizer;
import org.apache.nifi.flow.synchronization.VersionedFlowSynchronizationContext;
import org.apache.nifi.groups.BatchCounts;
import org.apache.nifi.groups.ComponentAdditions;
import org.apache.nifi.groups.ComponentIdGenerator;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.groups.DataValve;
import org.apache.nifi.groups.DefaultComponentScheduler;
import org.apache.nifi.groups.FlowFileConcurrency;
import org.apache.nifi.groups.FlowFileGate;
import org.apache.nifi.groups.FlowFileOutboundPolicy;
import org.apache.nifi.groups.FlowSynchronizationOptions;
import org.apache.nifi.groups.NoOpBatchCounts;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RetainExistingStateComponentScheduler;
import org.apache.nifi.groups.SingleBatchFlowFileGate;
import org.apache.nifi.groups.SingleConcurrencyFlowFileGate;
import org.apache.nifi.groups.StandardBatchCounts;
import org.apache.nifi.groups.StandardDataValve;
import org.apache.nifi.groups.StandardVersionedFlowStatus;
import org.apache.nifi.groups.StatelessGroupNode;
import org.apache.nifi.groups.StatelessGroupNodeFactory;
import org.apache.nifi.groups.StatelessGroupScheduledState;
import org.apache.nifi.groups.UnboundedFlowFileGate;
import org.apache.nifi.groups.VersionControlFields;
import org.apache.nifi.groups.VersionedComponentAdditions;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterUpdate;
import org.apache.nifi.parameter.StandardParameterUpdate;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.registry.flow.FlowLocation;
import org.apache.nifi.registry.flow.FlowRegistryClientContextFactory;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.FlowSnapshotContainer;
import org.apache.nifi.registry.flow.FlowVersionLocation;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.StandardVersionControlInformation;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.VersionedFlowStatus;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.EvolvingDifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.FlowComparatorVersionedStrategy;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.diff.StandardComparableDataFlow;
import org.apache.nifi.registry.flow.diff.StandardFlowComparator;
import org.apache.nifi.registry.flow.mapping.ComponentIdLookup;
import org.apache.nifi.registry.flow.mapping.FlowMappingOptions;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.util.FlowDifferenceFilters;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.SnippetUtils;
import org.apache.nifi.web.Revision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardProcessGroup
implements ProcessGroup {
    public static final List<DropFlowFileState> AGGREGATE_DROP_FLOW_FILE_STATE_PRECEDENCES = Arrays.asList(DropFlowFileState.FAILURE, DropFlowFileState.CANCELED, DropFlowFileState.DROPPING_FLOWFILES, DropFlowFileState.WAITING_FOR_LOCK, DropFlowFileState.COMPLETE);
    private final String id;
    private final AtomicReference<ProcessGroup> parent;
    private final AtomicReference<String> name;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> comments;
    private final AtomicReference<String> defaultFlowFileExpiration;
    private final AtomicReference<Long> defaultBackPressureObjectThreshold;
    private final AtomicReference<String> defaultBackPressureDataSizeThreshold;
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final AtomicReference<StandardVersionControlInformation> versionControlInfo = new AtomicReference();
    private static final SecureRandom randomGenerator = new SecureRandom();
    private final ProcessScheduler scheduler;
    private final ControllerServiceProvider controllerServiceProvider;
    private final FlowManager flowManager;
    private final ExtensionManager extensionManager;
    private final StateManagerProvider stateManagerProvider;
    private final ReloadComponent reloadComponent;
    private final Map<String, Port> inputPorts = new HashMap<String, Port>();
    private final Map<String, Port> outputPorts = new HashMap<String, Port>();
    private final Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private final Map<String, ProcessGroup> processGroups = new ConcurrentHashMap<String, ProcessGroup>();
    private final Map<String, Label> labels = new HashMap<String, Label>();
    private final Map<String, RemoteProcessGroup> remoteGroups = new HashMap<String, RemoteProcessGroup>();
    private final Map<String, ProcessorNode> processors = new HashMap<String, ProcessorNode>();
    private final Map<String, Funnel> funnels = new HashMap<String, Funnel>();
    private final Map<String, ControllerServiceNode> controllerServices = new ConcurrentHashMap<String, ControllerServiceNode>();
    private final PropertyEncryptor encryptor;
    private final VersionControlFields versionControlFields = new VersionControlFields();
    private volatile ParameterContext parameterContext;
    private final NodeTypeProvider nodeTypeProvider;
    private final AssetManager assetManager;
    private final StatelessGroupNode statelessGroupNode;
    private volatile ExecutionEngine executionEngine = ExecutionEngine.INHERITED;
    private volatile int maxConcurrentTasks = 1;
    private volatile String statelessFlowTimeout = "1 min";
    private FlowFileConcurrency flowFileConcurrency = FlowFileConcurrency.UNBOUNDED;
    private volatile FlowFileGate flowFileGate = new UnboundedFlowFileGate();
    private volatile FlowFileOutboundPolicy flowFileOutboundPolicy = FlowFileOutboundPolicy.STREAM_WHEN_AVAILABLE;
    private volatile BatchCounts batchCounts = new NoOpBatchCounts();
    private final DataValve dataValve;
    private final Long nifiPropertiesBackpressureCount;
    private final String nifiPropertiesBackpressureSize;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private static final Logger LOG = LoggerFactory.getLogger(StandardProcessGroup.class);
    private static final String DEFAULT_FLOWFILE_EXPIRATION = "0 sec";
    private static final long DEFAULT_BACKPRESSURE_OBJECT = 10000L;
    private static final String DEFAULT_BACKPRESSURE_DATA_SIZE = "1 GB";
    private static final Pattern INVALID_DIRECTORY_NAME_CHARACTERS = Pattern.compile("[\\s\\<\\>:\\'\\\"\\/\\\\\\|\\?\\*]");
    private volatile String logFileSuffix;

    public StandardProcessGroup(String id, ControllerServiceProvider serviceProvider, ProcessScheduler scheduler, PropertyEncryptor encryptor, ExtensionManager extensionManager, StateManagerProvider stateManagerProvider, FlowManager flowManager, ReloadComponent reloadComponent, NodeTypeProvider nodeTypeProvider, NiFiProperties nifiProperties, StatelessGroupNodeFactory statelessGroupNodeFactory, AssetManager assetManager) {
        this.id = id;
        this.controllerServiceProvider = serviceProvider;
        this.parent = new AtomicReference();
        this.scheduler = scheduler;
        this.comments = new AtomicReference<String>("");
        this.encryptor = encryptor;
        this.extensionManager = extensionManager;
        this.stateManagerProvider = stateManagerProvider;
        this.flowManager = flowManager;
        this.reloadComponent = reloadComponent;
        this.nodeTypeProvider = nodeTypeProvider;
        this.assetManager = assetManager;
        this.name = new AtomicReference();
        this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
        StateManager dataValveStateManager = stateManagerProvider.getStateManager(id + "-DataValve");
        this.dataValve = new StandardDataValve(this, dataValveStateManager);
        this.defaultFlowFileExpiration = new AtomicReference();
        this.defaultBackPressureObjectThreshold = new AtomicReference();
        this.defaultBackPressureDataSizeThreshold = new AtomicReference();
        this.logFileSuffix = null;
        if (nifiProperties == null) {
            this.nifiPropertiesBackpressureCount = 10000L;
            this.nifiPropertiesBackpressureSize = DEFAULT_BACKPRESSURE_DATA_SIZE;
        } else {
            String size;
            long count;
            try {
                String explicitValue = nifiProperties.getProperty("nifi.queue.backpressure.count", String.valueOf(10000L));
                count = Long.parseLong(explicitValue);
            }
            catch (Exception e) {
                LOG.warn("nifi.properties has an invalid value for the '{}' property. Using default value instead.", (Object)"nifi.queue.backpressure.count");
                count = 10000L;
            }
            this.nifiPropertiesBackpressureCount = count;
            try {
                size = nifiProperties.getProperty("nifi.queue.backpressure.size", DEFAULT_BACKPRESSURE_DATA_SIZE);
                DataUnit.parseDataSize((String)size, (DataUnit)DataUnit.B);
            }
            catch (Exception e) {
                LOG.warn("nifi.properties has an invalid value for the '{}' property. Using default value instead.", (Object)"nifi.queue.backpressure.size");
                size = DEFAULT_BACKPRESSURE_DATA_SIZE;
            }
            this.nifiPropertiesBackpressureSize = size;
        }
        this.statelessGroupNode = statelessGroupNodeFactory.createStatelessGroupNode(this);
    }

    public ProcessGroup getParent() {
        return this.parent.get();
    }

    public void setParent(ProcessGroup newParent) {
        this.parent.set(newParent);
    }

    public Authorizable getParentAuthorizable() {
        return this.getParent();
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ProcessGroup, (String)this.getIdentifier(), (String)this.getName());
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup parentProcessGroup = this.getParent();
        if (parentProcessGroup == null) {
            return null;
        }
        return parentProcessGroup.getIdentifier();
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The name of the process group must be specified.");
        }
        this.name.set(name);
    }

    public void setPosition(Position position) {
        this.position.set(position);
    }

    public Position getPosition() {
        return this.position.get();
    }

    public String getComments() {
        return this.comments.get();
    }

    public void setComments(String comments) {
        this.comments.set(comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessGroupCounts getCounts() {
        int localInputPortCount = 0;
        int localOutputPortCount = 0;
        int publicInputPortCount = 0;
        int publicOutputPortCount = 0;
        int running = 0;
        int stopped = 0;
        int invalid = 0;
        int disabled = 0;
        int activeRemotePorts = 0;
        int inactiveRemotePorts = 0;
        int upToDate = 0;
        int locallyModified = 0;
        int stale = 0;
        int locallyModifiedAndStale = 0;
        int syncFailure = 0;
        this.readLock.lock();
        try {
            for (ProcessorNode procNode : this.processors.values()) {
                if (ScheduledState.DISABLED.equals((Object)procNode.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (procNode.isRunning()) {
                    ++running;
                    continue;
                }
                if (procNode.getValidationStatus() == ValidationStatus.INVALID) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            for (Port port : this.inputPorts.values()) {
                if (port instanceof PublicPort) {
                    ++publicInputPortCount;
                } else {
                    ++localInputPortCount;
                }
                if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (port.isRunning()) {
                    ++running;
                    continue;
                }
                if (!port.isValid()) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            for (Port port : this.outputPorts.values()) {
                if (port instanceof PublicPort) {
                    ++publicOutputPortCount;
                } else {
                    ++localOutputPortCount;
                }
                if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (port.isRunning()) {
                    ++running;
                    continue;
                }
                if (!port.isValid()) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            for (ProcessGroup childGroup : this.processGroups.values()) {
                ProcessGroupCounts childCounts = childGroup.getCounts();
                running += childCounts.getRunningCount();
                stopped += childCounts.getStoppedCount();
                invalid += childCounts.getInvalidCount();
                disabled += childCounts.getDisabledCount();
                VersionControlInformation vci = childGroup.getVersionControlInformation();
                if (vci != null) {
                    VersionedFlowStatus flowStatus;
                    try {
                        flowStatus = vci.getStatus();
                    }
                    catch (Exception e) {
                        LOG.warn("Could not determine Version Control State for {}. Will consider state to be SYNC_FAILURE", (Object)this, (Object)e);
                        ++syncFailure;
                        continue;
                    }
                    switch (flowStatus.getState()) {
                        case LOCALLY_MODIFIED: {
                            ++locallyModified;
                            break;
                        }
                        case LOCALLY_MODIFIED_AND_STALE: {
                            ++locallyModifiedAndStale;
                            break;
                        }
                        case STALE: {
                            ++stale;
                            break;
                        }
                        case SYNC_FAILURE: {
                            ++syncFailure;
                            break;
                        }
                        case UP_TO_DATE: {
                            ++upToDate;
                        }
                    }
                }
                upToDate += childCounts.getUpToDateCount();
                locallyModified += childCounts.getLocallyModifiedCount();
                stale += childCounts.getStaleCount();
                locallyModifiedAndStale += childCounts.getLocallyModifiedAndStaleCount();
                syncFailure += childCounts.getSyncFailureCount();
            }
            for (RemoteProcessGroup remoteGroup : this.getRemoteProcessGroups()) {
                for (Port port : remoteGroup.getInputPorts()) {
                    if (!port.hasIncomingConnection()) continue;
                    if (port.isRunning()) {
                        ++activeRemotePorts;
                        continue;
                    }
                    ++inactiveRemotePorts;
                }
                for (Port port : remoteGroup.getOutputPorts()) {
                    if (port.getConnections().isEmpty()) continue;
                    if (port.isRunning()) {
                        ++activeRemotePorts;
                        continue;
                    }
                    ++inactiveRemotePorts;
                }
                String authIssue = remoteGroup.getAuthorizationIssue();
                if (authIssue == null) continue;
                ++invalid;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return new ProcessGroupCounts(localInputPortCount, localOutputPortCount, publicInputPortCount, publicOutputPortCount, running, stopped, invalid, disabled, activeRemotePorts, inactiveRemotePorts, upToDate, locallyModified, stale, locallyModifiedAndStale, syncFailure);
    }

    public boolean isRootGroup() {
        return this.parent.get() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessing() {
        ExecutionEngine resolvedExecutionEngine = this.resolveExecutionEngine();
        if (resolvedExecutionEngine == ExecutionEngine.STATELESS) {
            this.writeLock.lock();
            try {
                ExecutionEngine parentExecutionEngine;
                ProcessGroup parent = this.getParent();
                if (parent != null && (parentExecutionEngine = parent.resolveExecutionEngine()) == ExecutionEngine.STATELESS) {
                    LOG.warn("Cannot start Process Group {} because its parent is configured to run using the Stateless Engine. Only the top-most Process Group that is configured to use the Stateless Engine may be directly started", (Object)this);
                    return;
                }
                if (this.getStatelessScheduledState() == StatelessGroupScheduledState.RUNNING) {
                    LOG.info("Triggered to start {} but it is already running", (Object)this);
                    return;
                }
                this.scheduler.startStatelessGroup(this.statelessGroupNode);
                LOG.info("Started {} to run as a Stateless Process Group", (Object)this);
                return;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        this.startComponents();
        this.onComponentModified();
    }

    public void startComponents() {
        this.readLock.lock();
        try {
            this.controllerServiceProvider.enableControllerServices(this.controllerServices.values());
            this.getProcessors().stream().filter(START_PROCESSORS_FILTER).forEach(node -> {
                try {
                    node.getProcessGroup().startProcessor(node, true);
                }
                catch (Throwable t) {
                    LOG.error("Unable to start processor {}", (Object)node.getIdentifier(), (Object)t);
                }
            });
            this.getInputPorts().stream().filter(START_PORTS_FILTER).forEach(port -> port.getProcessGroup().startInputPort(port));
            this.getOutputPorts().stream().filter(START_PORTS_FILTER).forEach(port -> port.getProcessGroup().startOutputPort(port));
            this.getProcessGroups().forEach(ProcessGroup::startProcessing);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> stopProcessing() {
        if (this.resolveExecutionEngine() == ExecutionEngine.STATELESS) {
            this.writeLock.lock();
            try {
                CompletableFuture future;
                ProcessGroup parentStatelessGroup = this.getStatelessGroup(this.getParent());
                if (parentStatelessGroup != null) {
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    return completableFuture;
                }
                LOG.info("Stopping {} from running", (Object)this);
                CompletableFuture completableFuture = future = this.scheduler.stopStatelessGroup(this.statelessGroupNode);
                return completableFuture;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        CompletableFuture<Void> stopComponentsFuture = this.stopComponents();
        this.onComponentModified();
        return stopComponentsFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> stopComponents() {
        this.readLock.lock();
        try {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            this.getProcessors().stream().filter(STOP_PROCESSORS_FILTER).forEach(node -> {
                try {
                    futures.add(node.getProcessGroup().stopProcessor(node));
                }
                catch (Throwable t) {
                    LOG.error("Unable to stop processor {}", (Object)node.getIdentifier(), (Object)t);
                }
            });
            this.getInputPorts().stream().filter(STOP_PORTS_FILTER).forEach(port -> port.getProcessGroup().stopInputPort(port));
            this.getOutputPorts().stream().filter(STOP_PORTS_FILTER).forEach(port -> port.getProcessGroup().stopOutputPort(port));
            for (ProcessGroup childGroup : this.getProcessGroups()) {
                CompletableFuture future = childGroup.stopProcessing();
                futures.add(future);
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return completableFuture;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public StatelessGroupScheduledState getStatelessScheduledState() {
        if (this.statelessGroupNode == null) {
            return StatelessGroupScheduledState.STOPPED;
        }
        ScheduledState currentState = this.statelessGroupNode.getCurrentState();
        return switch (currentState) {
            case ScheduledState.RUNNING, ScheduledState.RUN_ONCE, ScheduledState.STARTING, ScheduledState.STOPPING -> StatelessGroupScheduledState.RUNNING;
            default -> StatelessGroupScheduledState.STOPPED;
        };
    }

    public StatelessGroupScheduledState getDesiredStatelessScheduledState() {
        if (this.statelessGroupNode == null) {
            return StatelessGroupScheduledState.STOPPED;
        }
        ScheduledState currentState = this.statelessGroupNode.getDesiredState();
        return switch (currentState) {
            case ScheduledState.RUNNING, ScheduledState.STARTING -> StatelessGroupScheduledState.RUNNING;
            default -> StatelessGroupScheduledState.STOPPED;
        };
    }

    public boolean isStatelessActive() {
        if (this.statelessGroupNode == null) {
            return false;
        }
        if (this.getStatelessScheduledState() == StatelessGroupScheduledState.RUNNING) {
            return true;
        }
        return this.scheduler.getActiveThreadCount((Object)this.statelessGroupNode) > 0;
    }

    private StateManager getStateManager(String componentId) {
        return this.stateManagerProvider.getStateManager(componentId);
    }

    private void shutdown(ProcessGroup procGroup) {
        for (ProcessorNode node : procGroup.getProcessors()) {
            NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)node.getProcessor().getClass(), (String)node.getIdentifier());
            try {
                StandardProcessContext processContext = new StandardProcessContext(node, this.controllerServiceProvider, this.getStateManager(node.getIdentifier()), () -> false, this.nodeTypeProvider);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)node.getProcessor(), processContext);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        for (RemoteProcessGroup rpg : procGroup.getRemoteProcessGroups()) {
            rpg.shutdown();
        }
        for (Connection connection : procGroup.getConnections()) {
            connection.getFlowFileQueue().stopLoadBalancing();
        }
        for (ProcessGroup group : procGroup.getProcessGroups()) {
            this.shutdown(group);
        }
    }

    public void shutdown() {
        this.readLock.lock();
        try {
            this.shutdown(this);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void verifyPortUniqueness(Port port, Map<String, Port> portIdMap, Function<String, Port> getPortByName) {
        if (portIdMap.containsKey(Objects.requireNonNull(port).getIdentifier())) {
            throw new IllegalStateException("A port with the same id already exists.");
        }
        if (getPortByName.apply(port.getName()) != null) {
            throw new IllegalStateException("A port with the same name already exists.");
        }
    }

    public void addInputPort(Port port) {
        if (this.isRootGroup() && !(port instanceof PublicPort)) {
            throw new IllegalArgumentException("Cannot add Input Port of type " + port.getClass().getName() + " to the Root Group");
        }
        this.writeLock.lock();
        try {
            this.verifyPortUniqueness(port, this.inputPorts, this::getInputPortByName);
            this.ensureUniqueVersionControlId((VersionedComponent)port, ProcessGroup::getInputPorts);
            port.setProcessGroup((ProcessGroup)this);
            this.inputPorts.put(Objects.requireNonNull(port).getIdentifier(), port);
            this.flowManager.onInputPortAdded(port);
            this.onComponentModified();
            LOG.info("Input Port {} added to {}", (Object)port, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInputPort(Port port) {
        this.writeLock.lock();
        try {
            Port toRemove = this.inputPorts.get(Objects.requireNonNull(port).getIdentifier());
            if (toRemove == null) {
                throw new IllegalStateException(port.getIdentifier() + " is not an Input Port of this Process Group");
            }
            port.verifyCanDelete();
            for (Object conn : port.getConnections()) {
                conn.verifyCanDelete();
            }
            if (port.isRunning()) {
                this.stopInputPort(port);
            }
            HashSet copy = new HashSet(port.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            Port removed = this.inputPorts.remove(port.getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(port.getIdentifier() + " is not an Input Port of this Process Group");
            }
            this.scheduler.onPortRemoved(port);
            this.onComponentModified();
            this.flowManager.onInputPortRemoved(port);
            LOG.info("Input Port {} removed from flow", (Object)port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Port getInputPort(String id) {
        this.readLock.lock();
        try {
            Port port = this.inputPorts.get(Objects.requireNonNull(id));
            return port;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Port> getInputPorts() {
        this.readLock.lock();
        try {
            HashSet<Port> hashSet = new HashSet<Port>(this.inputPorts.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addOutputPort(Port port) {
        if (this.isRootGroup() && !(port instanceof PublicPort)) {
            throw new IllegalArgumentException("Cannot add Output Port " + port.getClass().getName() + " to the Root Group");
        }
        this.writeLock.lock();
        try {
            this.verifyPortUniqueness(port, this.outputPorts, this::getOutputPortByName);
            this.ensureUniqueVersionControlId((VersionedComponent)port, ProcessGroup::getOutputPorts);
            port.setProcessGroup((ProcessGroup)this);
            this.outputPorts.put(port.getIdentifier(), port);
            this.flowManager.onOutputPortAdded(port);
            this.onComponentModified();
            LOG.info("Output Port {} added to {}", (Object)port, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputPort(Port port) {
        this.writeLock.lock();
        try {
            Port toRemove = this.outputPorts.get(Objects.requireNonNull(port).getIdentifier());
            toRemove.verifyCanDelete();
            if (port.isRunning()) {
                this.stopOutputPort(port);
            }
            if (!toRemove.getConnections().isEmpty()) {
                throw new IllegalStateException(port.getIdentifier() + " cannot be removed until its connections are removed");
            }
            Port removed = this.outputPorts.remove(port.getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(port.getIdentifier() + " is not an Output Port of this Process Group");
            }
            this.scheduler.onPortRemoved(port);
            this.onComponentModified();
            this.flowManager.onOutputPortRemoved(port);
            LOG.info("Output Port {} removed from flow", (Object)port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Port getOutputPort(String id) {
        this.readLock.lock();
        try {
            Port port = this.outputPorts.get(Objects.requireNonNull(id));
            return port;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Port> getOutputPorts() {
        this.readLock.lock();
        try {
            HashSet<Port> hashSet = new HashSet<Port>(this.outputPorts.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public BatchCounts getBatchCounts() {
        return this.batchCounts;
    }

    public void addProcessGroup(ProcessGroup group) {
        if (StringUtils.isEmpty((CharSequence)group.getName())) {
            throw new IllegalArgumentException("Process Group's name must be specified");
        }
        this.writeLock.lock();
        try {
            this.ensureUniqueVersionControlId((VersionedComponent)group, ProcessGroup::getProcessGroups);
            group.setParent((ProcessGroup)this);
            this.processGroups.put(Objects.requireNonNull(group).getIdentifier(), group);
            this.flowManager.onProcessGroupAdded(group);
            group.findAllControllerServices().forEach(this::updateControllerServiceReferences);
            group.findAllProcessors().forEach(this::updateControllerServiceReferences);
            this.onComponentModified();
            LOG.info("{} added to {}", (Object)group, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ProcessGroup getProcessGroup(String id) {
        this.readLock.lock();
        try {
            ProcessGroup processGroup = this.processGroups.get(id);
            return processGroup;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<ProcessGroup> getProcessGroups() {
        this.readLock.lock();
        try {
            HashSet<ProcessGroup> hashSet = new HashSet<ProcessGroup>(this.processGroups.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void removeProcessGroup(ProcessGroup group) {
        Objects.requireNonNull(group).verifyCanDelete();
        this.writeLock.lock();
        try {
            ProcessGroup toRemove = this.processGroups.get(group.getIdentifier());
            if (toRemove == null) {
                throw new IllegalStateException(group.getIdentifier() + " is not a member of this Process Group");
            }
            toRemove.verifyCanDelete();
            this.removeComponents(group);
            this.processGroups.remove(group.getIdentifier());
            this.onComponentModified();
            this.flowManager.onProcessGroupRemoved(group);
            LogRepositoryFactory.removeRepository((String)group.getIdentifier());
            LOG.info("{} removed from flow", (Object)group);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeComponents(ProcessGroup group) {
        for (Connection connection : new ArrayList(group.getConnections())) {
            group.removeConnection(connection);
        }
        for (Port port : new ArrayList(group.getInputPorts())) {
            group.removeInputPort(port);
        }
        for (Port port : new ArrayList(group.getOutputPorts())) {
            group.removeOutputPort(port);
        }
        for (Funnel funnel : new ArrayList(group.getFunnels())) {
            group.removeFunnel(funnel);
        }
        for (ProcessorNode processor : new ArrayList(group.getProcessors())) {
            group.removeProcessor(processor);
        }
        for (RemoteProcessGroup rpg : new ArrayList(group.getRemoteProcessGroups())) {
            group.removeRemoteProcessGroup(rpg);
        }
        for (Label label : new ArrayList(group.getLabels())) {
            group.removeLabel(label);
        }
        for (ControllerServiceNode cs : group.getControllerServices(false)) {
            this.controllerServiceProvider.removeControllerService(cs);
        }
        for (ProcessGroup childGroup : new ArrayList(group.getProcessGroups())) {
            group.removeProcessGroup(childGroup);
        }
    }

    public void addRemoteProcessGroup(RemoteProcessGroup remoteGroup) {
        this.writeLock.lock();
        try {
            if (this.remoteGroups.containsKey(Objects.requireNonNull(remoteGroup).getIdentifier())) {
                throw new IllegalStateException("RemoteProcessGroup already exists with ID " + remoteGroup.getIdentifier());
            }
            this.ensureUniqueVersionControlId((VersionedComponent)remoteGroup, ProcessGroup::getRemoteProcessGroups);
            remoteGroup.setProcessGroup((ProcessGroup)this);
            this.remoteGroups.put(Objects.requireNonNull(remoteGroup).getIdentifier(), remoteGroup);
            this.onComponentModified();
            LOG.info("{} added to {}", (Object)remoteGroup, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<RemoteProcessGroup> getRemoteProcessGroups() {
        this.readLock.lock();
        try {
            HashSet<RemoteProcessGroup> hashSet = new HashSet<RemoteProcessGroup>(this.remoteGroups.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteProcessGroup(RemoteProcessGroup remoteProcessGroup) {
        String remoteGroupId = Objects.requireNonNull(remoteProcessGroup).getIdentifier();
        this.writeLock.lock();
        try {
            RemoteProcessGroup remoteGroup = this.remoteGroups.get(remoteGroupId);
            if (remoteGroup == null) {
                throw new IllegalStateException(remoteProcessGroup.getIdentifier() + " is not a member of this Process Group");
            }
            remoteGroup.verifyCanDelete();
            for (RemoteGroupPort port : remoteGroup.getOutputPorts()) {
                for (Connection connection : port.getConnections()) {
                    connection.verifyCanDelete();
                }
            }
            this.onComponentModified();
            for (RemoteGroupPort port : remoteGroup.getOutputPorts()) {
                HashSet copy = new HashSet(port.getConnections());
                for (Connection connection : copy) {
                    this.removeConnection(connection);
                }
            }
            try {
                remoteGroup.onRemove();
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up resources for {} due to {}", (Object)remoteGroup, (Object)e);
            }
            remoteGroup.getInputPorts().forEach(arg_0 -> ((ProcessScheduler)this.scheduler).onPortRemoved(arg_0));
            remoteGroup.getOutputPorts().forEach(arg_0 -> ((ProcessScheduler)this.scheduler).onPortRemoved(arg_0));
            this.scheduler.submitFrameworkTask(() -> this.stateManagerProvider.onComponentRemoved(remoteGroup.getIdentifier()));
            this.remoteGroups.remove(remoteGroupId);
            LOG.info("{} removed from flow", (Object)remoteProcessGroup);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessor(ProcessorNode processor) {
        this.writeLock.lock();
        try {
            String processorId = Objects.requireNonNull(processor).getIdentifier();
            ProcessorNode existingProcessor = this.processors.get(processorId);
            if (existingProcessor != null) {
                throw new IllegalStateException("A processor is already registered to this ProcessGroup with ID " + processorId);
            }
            this.ensureUniqueVersionControlId((VersionedComponent)processor, ProcessGroup::getProcessors);
            processor.setProcessGroup((ProcessGroup)this);
            this.processors.put(processorId, processor);
            this.flowManager.onProcessorAdded(processor);
            this.updateControllerServiceReferences((ComponentNode)processor);
            this.onComponentModified();
            LOG.info("{} added to {}", (Object)processor, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private <T extends VersionedComponent> void ensureUniqueVersionControlId(VersionedComponent component, Function<ProcessGroup, Collection<T>> extractComponents) {
        Optional optionalVersionControlId = component.getVersionedComponentId();
        if (!optionalVersionControlId.isPresent()) {
            return;
        }
        String versionControlId = (String)optionalVersionControlId.get();
        ProcessGroup versionedGroup = this.getVersionedAncestorOrSelf().orElse(this);
        Set<T> componentsToCheck = this.getComponentsInVersionedFlow(versionedGroup, extractComponents);
        boolean duplicateId = this.containsVersionedComponentId(componentsToCheck, versionControlId);
        if (duplicateId) {
            LOG.debug("Adding {} to {}, found conflicting Version Component ID {} so marking Version Component ID of {} as null", new Object[]{component, this, versionControlId, component});
            component.setVersionedComponentId(null);
        } else {
            LOG.debug("Adding {} to {}, found no conflicting Version Component ID for ID {}", new Object[]{component, this, versionControlId});
        }
    }

    private Optional<ProcessGroup> getVersionedAncestorOrSelf() {
        return this.getVersionedAncestorOrSelf(this);
    }

    private Optional<ProcessGroup> getVersionedAncestorOrSelf(ProcessGroup start) {
        if (start == null) {
            return Optional.empty();
        }
        if (start.getVersionControlInformation() != null) {
            return Optional.of(start);
        }
        return this.getVersionedAncestorOrSelf(start.getParent());
    }

    private <T extends VersionedComponent> Set<T> getComponentsInVersionedFlow(ProcessGroup group, Function<ProcessGroup, Collection<T>> extractComponents) {
        HashSet accumulated = new HashSet();
        this.getComponentsInVersionedFlow(group, extractComponents, accumulated);
        return accumulated;
    }

    private <T> void getComponentsInVersionedFlow(ProcessGroup group, Function<ProcessGroup, Collection<T>> extractComponents, Set<T> accumulated) {
        Collection<T> components = extractComponents.apply(group);
        accumulated.addAll(components);
        for (ProcessGroup child : group.getProcessGroups()) {
            if (child.getVersionControlInformation() != null) continue;
            this.getComponentsInVersionedFlow(child, extractComponents, accumulated);
        }
    }

    private boolean containsVersionedComponentId(Collection<? extends VersionedComponent> components, String id) {
        for (VersionedComponent versionedComponent : components) {
            Optional optionalConnectableId = versionedComponent.getVersionedComponentId();
            if (!optionalConnectableId.isPresent() || !Objects.equals(optionalConnectableId.get(), id)) continue;
            return true;
        }
        return false;
    }

    private void updateControllerServiceReferences(ComponentNode component) {
        for (Map.Entry entry : component.getEffectivePropertyValues().entrySet()) {
            PropertyDescriptor propertyDescriptor;
            Class serviceClass;
            String serviceId = (String)entry.getValue();
            if (serviceId == null || (serviceClass = (propertyDescriptor = (PropertyDescriptor)entry.getKey()).getControllerServiceDefinition()) == null) continue;
            boolean validReference = this.isValidServiceReference(serviceId, serviceClass, component);
            ControllerServiceNode serviceNode = this.controllerServiceProvider.getControllerServiceNode(serviceId);
            if (serviceNode == null) continue;
            if (validReference) {
                serviceNode.addReference(component, propertyDescriptor);
                continue;
            }
            serviceNode.removeReference(component, propertyDescriptor);
        }
    }

    private boolean isValidServiceReference(String serviceId, Class<? extends ControllerService> serviceClass, ComponentNode component) {
        Set validServiceIds = this.controllerServiceProvider.getControllerServiceIdentifiers(serviceClass, component.getProcessGroupIdentifier());
        return validServiceIds.contains(serviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessor(ProcessorNode processor) {
        boolean removed = false;
        String id = Objects.requireNonNull(processor).getIdentifier();
        this.writeLock.lock();
        try {
            if (!this.processors.containsKey(id)) {
                throw new IllegalStateException(processor.getIdentifier() + " is not a member of this Process Group");
            }
            processor.verifyCanDelete();
            for (Connection conn : processor.getConnections()) {
                conn.verifyCanDelete();
            }
            processor.pauseValidationTrigger();
            try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)processor.getProcessor().getClass(), (String)processor.getIdentifier());){
                StandardProcessContext processContext = new StandardProcessContext(processor, this.controllerServiceProvider, this.getStateManager(processor.getIdentifier()), () -> false, this.nodeTypeProvider);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)processor.getProcessor(), processContext);
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke 'OnRemoved' methods of processor with id " + processor.getIdentifier(), (Throwable)e);
            }
            for (Map.Entry entry : processor.getEffectivePropertyValues().entrySet()) {
                ControllerServiceNode serviceNode;
                String value;
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
                serviceNode.removeReference((ComponentNode)processor, descriptor);
            }
            ArrayList copy = new ArrayList(processor.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            this.processors.remove(id);
            this.onComponentModified();
            this.scheduler.onProcessorRemoved(processor);
            this.flowManager.onProcessorRemoved(processor);
            LogRepository logRepository = LogRepositoryFactory.getRepository((String)processor.getIdentifier());
            if (logRepository != null) {
                logRepository.removeAllObservers();
            }
            this.scheduler.submitFrameworkTask(() -> this.stateManagerProvider.onComponentRemoved(processor.getIdentifier()));
            removed = true;
            LOG.info("{} removed from flow", (Object)processor);
        }
        finally {
            if (removed) {
                try {
                    LogRepositoryFactory.removeRepository((String)processor.getIdentifier());
                    this.extensionManager.removeInstanceClassLoader(id);
                }
                catch (Throwable throwable) {}
            }
            this.writeLock.unlock();
        }
    }

    public Collection<ProcessorNode> getProcessors() {
        this.readLock.lock();
        try {
            ArrayList<ProcessorNode> arrayList = new ArrayList<ProcessorNode>(this.processors.values());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ProcessorNode getProcessor(String id) {
        this.readLock.lock();
        try {
            ProcessorNode processorNode = this.processors.get(Objects.requireNonNull(id));
            return processorNode;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isInputPort(Connectable connectable) {
        if (connectable.getConnectableType() != ConnectableType.INPUT_PORT) {
            return false;
        }
        return this.findInputPort(connectable.getIdentifier()) != null;
    }

    private boolean isOutputPort(Connectable connectable) {
        if (connectable.getConnectableType() != ConnectableType.OUTPUT_PORT) {
            return false;
        }
        return this.findOutputPort(connectable.getIdentifier()) != null;
    }

    public void inheritConnection(Connection connection) {
        this.writeLock.lock();
        try {
            this.connections.put(connection.getIdentifier(), connection);
            this.onComponentModified();
            connection.setProcessGroup((ProcessGroup)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        this.writeLock.lock();
        try {
            String id = Objects.requireNonNull(connection).getIdentifier();
            Connection existingConnection = this.connections.get(id);
            if (existingConnection != null) {
                throw new IllegalStateException("Connection already exists with ID " + id);
            }
            Connectable source = connection.getSource();
            Connectable destination = connection.getDestination();
            ProcessGroup sourceGroup = source.getProcessGroup();
            ProcessGroup destinationGroup = destination.getProcessGroup();
            if (this.isInputPort(source)) {
                if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection for Input Port[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] because destination [" + destination.getIdentifier() + "] is an Input Port that does not belong to a child Process Group");
                    }
                } else if (sourceGroup != this || destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection for Input Port[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] destination [" + destination.getIdentifier() + "] because source and destination are not both in this Process Group");
                }
            } else if (this.isOutputPort(source)) {
                if (!this.processGroups.containsKey(sourceGroup.getIdentifier())) {
                    throw new IllegalStateException("Cannot add Connection for Output Port[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] destination [" + destination.getIdentifier() + "] because source is an Output Port that does not belong to a child Process Group");
                }
                if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection for Output Port[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] because destination [" + destination.getIdentifier() + "] is an Input Port that does not belong to a child Process Group");
                    }
                } else if (destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection for Output Port[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] because its destination [" + destination.getIdentifier() + "] does not belong to this Process Group");
                }
            } else {
                if (sourceGroup != this) {
                    throw new IllegalStateException("Cannot add Connection from " + source.getConnectableType().name() + "[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] because the source does not belong to this Process Group");
                }
                if (this.isOutputPort(destination)) {
                    if (destinationGroup != this) {
                        throw new IllegalStateException("Cannot add Connection from " + source.getConnectableType().name() + "[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] because its destination [" + destination.getIdentifier() + "] is an Output Port that does not belong to this Process Group");
                    }
                } else if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection from " + source.getConnectableType().name() + "[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] because its destination [" + destination.getIdentifier() + "] is an Input Port but the Input Port does not belong to a child Process Group");
                    }
                } else if (destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection from " + source.getConnectableType().name() + "[" + source.getIdentifier() + "] from Process Group [" + sourceGroup.getIdentifier() + "] to Process Group [" + destinationGroup.getIdentifier() + "] destination " + destination.getConnectableType().name() + "[" + destination.getIdentifier() + "] because they are in different Process Groups and neither is an Input Port or Output Port");
                }
            }
            this.ensureUniqueVersionControlId((VersionedComponent)connection, ProcessGroup::getConnections);
            connection.setProcessGroup((ProcessGroup)this);
            source.addConnection(connection);
            if (source != destination) {
                destination.addConnection(connection);
            }
            this.connections.put(connection.getIdentifier(), connection);
            this.flowManager.onConnectionAdded(connection);
            this.onComponentModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connectable getConnectable(String id) {
        this.readLock.lock();
        try {
            ProcessorNode node = this.processors.get(id);
            if (node != null) {
                ProcessorNode processorNode = node;
                return processorNode;
            }
            Port inputPort = this.inputPorts.get(id);
            if (inputPort != null) {
                Port port = inputPort;
                return port;
            }
            Port outputPort = this.outputPorts.get(id);
            if (outputPort != null) {
                Port port = outputPort;
                return port;
            }
            Funnel funnel = this.funnels.get(id);
            if (funnel != null) {
                Funnel funnel2 = funnel;
                return funnel2;
            }
            Connectable connectable = null;
            return connectable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connectionToRemove) {
        this.writeLock.lock();
        try {
            Connection connection = this.connections.get(Objects.requireNonNull(connectionToRemove).getIdentifier());
            if (connection == null) {
                throw new IllegalStateException("Connection " + connectionToRemove.getIdentifier() + " is not a member of this Process Group");
            }
            connectionToRemove.verifyCanDelete();
            connectionToRemove.getFlowFileQueue().stopLoadBalancing();
            Connectable source = connectionToRemove.getSource();
            Connectable dest = connectionToRemove.getDestination();
            source.removeConnection(connection);
            if (source != dest) {
                dest.removeConnection(connection);
            }
            this.connections.remove(connection.getIdentifier());
            LOG.info("{} removed from flow", (Object)connection);
            this.onComponentModified();
            this.flowManager.onConnectionRemoved(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Connection> getConnections() {
        this.readLock.lock();
        try {
            HashSet<Connection> hashSet = new HashSet<Connection>(this.connections.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Connection getConnection(String id) {
        this.readLock.lock();
        try {
            Connection connection = this.connections.get(Objects.requireNonNull(id));
            return connection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Connection findConnection(String id) {
        Connection connection = this.flowManager.getConnection(id);
        if (connection == null) {
            return null;
        }
        if (this.isOwner(connection.getProcessGroup())) {
            return connection;
        }
        return null;
    }

    public List<Connection> findAllConnections() {
        return this.findAllConnections(this);
    }

    public DropFlowFileStatus dropAllFlowFiles(String requestIdentifier, String requestor) {
        return this.handleDropAllFlowFiles(requestIdentifier, queue -> queue.dropFlowFiles(requestIdentifier, requestor));
    }

    public DropFlowFileStatus getDropAllFlowFilesStatus(String requestIdentifier) {
        return this.handleDropAllFlowFiles(requestIdentifier, queue -> queue.getDropFlowFileStatus(requestIdentifier));
    }

    public DropFlowFileStatus cancelDropAllFlowFiles(String requestIdentifier) {
        return this.handleDropAllFlowFiles(requestIdentifier, queue -> queue.cancelDropFlowFileRequest(requestIdentifier));
    }

    private DropFlowFileStatus handleDropAllFlowFiles(String dropRequestId, Function<FlowFileQueue, DropFlowFileStatus> function) {
        List<Connection> connections = this.findAllConnections(this);
        DropFlowFileRequest aggregateDropFlowFileStatus = new DropFlowFileRequest(dropRequestId);
        if (connections.isEmpty()) {
            aggregateDropFlowFileStatus.setState(DropFlowFileState.COMPLETE);
            aggregateDropFlowFileStatus.setCurrentSize(new QueueSize(0, 0L));
            aggregateDropFlowFileStatus.setOriginalSize(new QueueSize(0, 0L));
            return aggregateDropFlowFileStatus;
        }
        aggregateDropFlowFileStatus.setState(null);
        AtomicBoolean processedAtLeastOne = new AtomicBoolean(false);
        connections.stream().map(Connection::getFlowFileQueue).map(function::apply).forEach(additionalDropFlowFileStatus -> {
            this.aggregate(aggregateDropFlowFileStatus, (DropFlowFileStatus)additionalDropFlowFileStatus);
            processedAtLeastOne.set(true);
        });
        Object resultDropFlowFileStatus = processedAtLeastOne.get() ? aggregateDropFlowFileStatus : null;
        return resultDropFlowFileStatus;
    }

    private void aggregate(DropFlowFileRequest aggregateDropFlowFileStatus, DropFlowFileStatus additionalDropFlowFileStatus) {
        QueueSize aggregateOriginalSize = this.aggregate(aggregateDropFlowFileStatus.getOriginalSize(), additionalDropFlowFileStatus.getOriginalSize());
        QueueSize aggregateDroppedSize = this.aggregate(aggregateDropFlowFileStatus.getDroppedSize(), additionalDropFlowFileStatus.getDroppedSize());
        QueueSize aggregateCurrentSize = this.aggregate(aggregateDropFlowFileStatus.getCurrentSize(), additionalDropFlowFileStatus.getCurrentSize());
        DropFlowFileState aggregateState = this.aggregate(aggregateDropFlowFileStatus.getState(), additionalDropFlowFileStatus.getState());
        aggregateDropFlowFileStatus.setOriginalSize(aggregateOriginalSize);
        aggregateDropFlowFileStatus.setDroppedSize(aggregateDroppedSize);
        aggregateDropFlowFileStatus.setCurrentSize(aggregateCurrentSize);
        aggregateDropFlowFileStatus.setState(aggregateState);
    }

    private QueueSize aggregate(QueueSize size1, QueueSize size2) {
        int objectsNr = Optional.ofNullable(size1).map(size -> size.getObjectCount() + size2.getObjectCount()).orElse(size2.getObjectCount());
        long sizeByte = Optional.ofNullable(size1).map(size -> size.getByteCount() + size2.getByteCount()).orElse(size2.getByteCount());
        QueueSize aggregateSize = new QueueSize(objectsNr, sizeByte);
        return aggregateSize;
    }

    private DropFlowFileState aggregate(DropFlowFileState state1, DropFlowFileState state2) {
        DropFlowFileState aggregateState = DropFlowFileState.DROPPING_FLOWFILES;
        for (DropFlowFileState aggregateDropFlowFileStatePrecedence : AGGREGATE_DROP_FLOW_FILE_STATE_PRECEDENCES) {
            if (state1 != aggregateDropFlowFileStatePrecedence && state2 != aggregateDropFlowFileStatePrecedence) continue;
            aggregateState = aggregateDropFlowFileStatePrecedence;
            break;
        }
        return aggregateState;
    }

    private List<Connection> findAllConnections(ProcessGroup group) {
        ArrayList<Connection> connections = new ArrayList<Connection>(group.getConnections());
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            connections.addAll(this.findAllConnections(childGroup));
        }
        return connections;
    }

    public void addLabel(Label label) {
        this.writeLock.lock();
        try {
            Label existing = this.labels.get(Objects.requireNonNull(label).getIdentifier());
            if (existing != null) {
                throw new IllegalStateException("A label already exists in this ProcessGroup with ID " + label.getIdentifier());
            }
            this.ensureUniqueVersionControlId((VersionedComponent)label, ProcessGroup::getLabels);
            label.setProcessGroup((ProcessGroup)this);
            this.labels.put(label.getIdentifier(), label);
            this.onComponentModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeLabel(Label label) {
        this.writeLock.lock();
        try {
            Label removed = this.labels.remove(Objects.requireNonNull(label).getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(String.valueOf(label) + " is not a member of this Process Group.");
            }
            this.onComponentModified();
            LOG.info("Label with ID {} removed from flow", (Object)label.getIdentifier());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Label> getLabels() {
        this.readLock.lock();
        try {
            HashSet<Label> hashSet = new HashSet<Label>(this.labels.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Label getLabel(String id) {
        this.readLock.lock();
        try {
            Label label = this.labels.get(id);
            return label;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.inputPorts.isEmpty() && this.outputPorts.isEmpty() && this.connections.isEmpty() && this.processGroups.isEmpty() && this.labels.isEmpty() && this.processors.isEmpty() && this.remoteGroups.isEmpty() && this.controllerServices.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public RemoteProcessGroup getRemoteProcessGroup(String id) {
        this.readLock.lock();
        try {
            RemoteProcessGroup remoteProcessGroup = this.remoteGroups.get(Objects.requireNonNull(id));
            return remoteProcessGroup;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> startProcessor(ProcessorNode processor, boolean failIfStopping) {
        this.readLock.lock();
        try {
            if (this.getProcessor(processor.getIdentifier()) == null) {
                throw new IllegalStateException("Processor is not a member of this Process Group");
            }
            this.verifyCanStart((Connectable)processor);
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("Processor is disabled");
            }
            if (state == ScheduledState.RUNNING) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            processor.reloadAdditionalResourcesIfNecessary();
            Future future = this.scheduler.startProcessor(processor, failIfStopping);
            return future;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> runProcessorOnce(ProcessorNode processor, Callable<Future<Void>> stopCallback) {
        this.readLock.lock();
        try {
            if (this.getProcessor(processor.getIdentifier()) == null) {
                throw new IllegalStateException("Processor is not a member of this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("Processor is disabled");
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("Processor is already running");
            }
            processor.reloadAdditionalResourcesIfNecessary();
            Future future = this.scheduler.runProcessorOnce(processor, stopCallback);
            return future;
        }
        catch (Exception e) {
            processor.getLogger().error("Error while running processor {} once.", new Object[]{processor, e});
            CompletableFuture<Void> completableFuture = this.stopProcessor(processor);
            return completableFuture;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startInputPort(Port port) {
        this.readLock.lock();
        try {
            if (this.getInputPort(port.getIdentifier()) == null) {
                throw new IllegalStateException("Port " + port.getIdentifier() + " is not a member of this Process Group");
            }
            this.verifyCanStart((Connectable)port);
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("InputPort " + port.getIdentifier() + " is disabled");
            }
            if (state == ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (this.getOutputPort(port.getIdentifier()) == null) {
                throw new IllegalStateException("Port is not a member of this Process Group");
            }
            this.verifyCanStart((Connectable)port);
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("OutputPort is disabled");
            }
            if (state == ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startFunnel(Funnel funnel) {
        this.readLock.lock();
        try {
            if (this.getFunnel(funnel.getIdentifier()) == null) {
                throw new IllegalStateException("Funnel is not a member of this Process Group");
            }
            ScheduledState state = funnel.getScheduledState();
            if (state == ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startFunnel(funnel);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> stopProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("Processor is disabled");
            }
            CompletableFuture completableFuture = this.scheduler.stopProcessor(processor);
            return completableFuture;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void terminateProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state != ScheduledState.STOPPED && state != ScheduledState.RUN_ONCE) {
                throw new IllegalStateException("Cannot terminate processor with ID " + processor.getIdentifier() + " because it is not stopped");
            }
            this.scheduler.terminateProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void stopInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Input Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("InputPort is disabled");
            }
            if (state == ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void stopOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Output Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("OutputPort is disabled");
            }
            if (state == ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void stopFunnel(Funnel funnel) {
        this.readLock.lock();
        try {
            if (!this.funnels.containsKey(funnel.getIdentifier())) {
                throw new IllegalStateException("No Funnel with ID " + funnel.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = funnel.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("Funnel is disabled");
            }
            if (state == ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopFunnel(funnel);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Input Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.STOPPED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("InputPort is currently running");
            }
            this.scheduler.enablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Output Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.STOPPED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("OutputPort is currently running");
            }
            this.scheduler.enablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No Processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.STOPPED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("Processor is currently running");
            }
            this.scheduler.enableProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No InputPort with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("InputPort is currently running");
            }
            this.scheduler.disablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No OutputPort with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("OutputPort is currently running");
            }
            this.scheduler.disablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No Processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("Processor is currently running");
            }
            this.scheduler.disableProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StandardProcessGroup) {
            StandardProcessGroup other = (StandardProcessGroup)obj;
            return this.getIdentifier().equals(other.getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getIdentifier()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("identifier", (Object)this.getIdentifier()).append("name", (Object)this.getName()).toString();
    }

    public ProcessGroup findProcessGroup(String id) {
        if (Objects.requireNonNull(id).equals(this.getIdentifier())) {
            return this;
        }
        ProcessGroup group = this.flowManager.getGroup(id);
        if (group == null) {
            return null;
        }
        if (this.isOwner(group.getParent())) {
            return group;
        }
        return null;
    }

    public List<ProcessGroup> findAllProcessGroups() {
        return this.findAllProcessGroups(this);
    }

    public List<ProcessGroup> findAllProcessGroups(Predicate<ProcessGroup> filter) {
        ArrayList<ProcessGroup> matching = new ArrayList<ProcessGroup>();
        if (filter.test(this)) {
            matching.add(this);
        }
        for (ProcessGroup group : this.getProcessGroups()) {
            matching.addAll(group.findAllProcessGroups(filter));
        }
        return matching;
    }

    private List<ProcessGroup> findAllProcessGroups(ProcessGroup start) {
        ArrayList<ProcessGroup> allProcessGroups = new ArrayList<ProcessGroup>(start.getProcessGroups());
        for (ProcessGroup childGroup : start.getProcessGroups()) {
            allProcessGroups.addAll(this.findAllProcessGroups(childGroup));
        }
        return allProcessGroups;
    }

    public List<RemoteProcessGroup> findAllRemoteProcessGroups() {
        return this.findAllRemoteProcessGroups(this);
    }

    private List<RemoteProcessGroup> findAllRemoteProcessGroups(ProcessGroup start) {
        ArrayList<RemoteProcessGroup> remoteGroups = new ArrayList<RemoteProcessGroup>(start.getRemoteProcessGroups());
        for (ProcessGroup childGroup : start.getProcessGroups()) {
            remoteGroups.addAll(this.findAllRemoteProcessGroups(childGroup));
        }
        return remoteGroups;
    }

    public RemoteProcessGroup findRemoteProcessGroup(String id) {
        return this.findRemoteProcessGroup(Objects.requireNonNull(id), this);
    }

    private RemoteProcessGroup findRemoteProcessGroup(String id, ProcessGroup start) {
        RemoteProcessGroup remoteGroup = start.getRemoteProcessGroup(id);
        if (remoteGroup != null) {
            return remoteGroup;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            remoteGroup = this.findRemoteProcessGroup(id, group);
            if (remoteGroup == null) continue;
            return remoteGroup;
        }
        return null;
    }

    public ProcessorNode findProcessor(String id) {
        ProcessorNode node = this.flowManager.getProcessorNode(id);
        if (node == null) {
            return null;
        }
        if (this.isOwner(node.getProcessGroup())) {
            return node;
        }
        return null;
    }

    private boolean isOwner(ProcessGroup owner) {
        while (owner != this && owner != null) {
            owner = owner.getParent();
        }
        return owner == this;
    }

    public List<ProcessorNode> findAllProcessors() {
        return this.findAllProcessors(this);
    }

    private List<ProcessorNode> findAllProcessors(ProcessGroup start) {
        ArrayList<ProcessorNode> allNodes = new ArrayList<ProcessorNode>(start.getProcessors());
        for (ProcessGroup group : start.getProcessGroups()) {
            allNodes.addAll(this.findAllProcessors(group));
        }
        return allNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteGroupPort findRemoteGroupPort(String identifier) {
        this.readLock.lock();
        try {
            RemoteGroupPort remoteGroupPort;
            for (RemoteProcessGroup remoteGroup : this.remoteGroups.values()) {
                RemoteGroupPort remoteInPort = remoteGroup.getInputPort(identifier);
                if (remoteInPort != null) {
                    remoteGroupPort = remoteInPort;
                    return remoteGroupPort;
                }
                RemoteGroupPort remoteOutPort = remoteGroup.getOutputPort(identifier);
                if (remoteOutPort == null) continue;
                RemoteGroupPort remoteGroupPort2 = remoteOutPort;
                return remoteGroupPort2;
            }
            for (ProcessGroup childGroup : this.processGroups.values()) {
                RemoteGroupPort childGroupRemoteGroupPort = childGroup.findRemoteGroupPort(identifier);
                if (childGroupRemoteGroupPort == null) continue;
                remoteGroupPort = childGroupRemoteGroupPort;
                return remoteGroupPort;
            }
            Iterator<RemoteProcessGroup> iterator = null;
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Label findLabel(String id) {
        return this.findLabel(id, this);
    }

    private Label findLabel(String id, ProcessGroup start) {
        Label label = start.getLabel(id);
        if (label != null) {
            return label;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            label = this.findLabel(id, group);
            if (label == null) continue;
            return label;
        }
        return null;
    }

    public List<Label> findAllLabels() {
        return this.findAllLabels(this);
    }

    private List<Label> findAllLabels(ProcessGroup start) {
        ArrayList<Label> allLabels = new ArrayList<Label>(start.getLabels());
        for (ProcessGroup group : start.getProcessGroups()) {
            allLabels.addAll(this.findAllLabels(group));
        }
        return allLabels;
    }

    public Port findInputPort(String id) {
        Port port = this.flowManager.getInputPort(id);
        if (port == null) {
            return null;
        }
        if (this.isOwner(port.getProcessGroup())) {
            return port;
        }
        return null;
    }

    public List<Port> findAllInputPorts() {
        return this.findAllInputPorts(this);
    }

    private List<Port> findAllInputPorts(ProcessGroup start) {
        ArrayList<Port> allOutputPorts = new ArrayList<Port>(start.getInputPorts());
        for (ProcessGroup group : start.getProcessGroups()) {
            allOutputPorts.addAll(this.findAllInputPorts(group));
        }
        return allOutputPorts;
    }

    public Port findOutputPort(String id) {
        Port port = this.flowManager.getOutputPort(id);
        if (port == null) {
            return null;
        }
        if (this.isOwner(port.getProcessGroup())) {
            return port;
        }
        return null;
    }

    public List<Port> findAllOutputPorts() {
        return this.findAllOutputPorts(this);
    }

    private List<Port> findAllOutputPorts(ProcessGroup start) {
        ArrayList<Port> allOutputPorts = new ArrayList<Port>(start.getOutputPorts());
        for (ProcessGroup group : start.getProcessGroups()) {
            allOutputPorts.addAll(this.findAllOutputPorts(group));
        }
        return allOutputPorts;
    }

    public List<Funnel> findAllFunnels() {
        return this.findAllFunnels(this);
    }

    private List<Funnel> findAllFunnels(ProcessGroup start) {
        ArrayList<Funnel> allFunnels = new ArrayList<Funnel>(start.getFunnels());
        for (ProcessGroup group : start.getProcessGroups()) {
            allFunnels.addAll(this.findAllFunnels(group));
        }
        return allFunnels;
    }

    public Port getInputPortByName(String name) {
        return this.getPortByName(name, this, new InputPortRetriever());
    }

    public Port getOutputPortByName(String name) {
        return this.getPortByName(name, this, new OutputPortRetriever());
    }

    private Port getPortByName(String name, ProcessGroup group, PortRetriever retriever) {
        for (Port port : retriever.getPorts(group)) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    public void addFunnel(Funnel funnel) {
        this.addFunnel(funnel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunnel(Funnel funnel, boolean autoStart) {
        this.writeLock.lock();
        try {
            Funnel existing = this.funnels.get(Objects.requireNonNull(funnel).getIdentifier());
            if (existing != null) {
                throw new IllegalStateException("A funnel already exists in this ProcessGroup with ID " + funnel.getIdentifier());
            }
            this.ensureUniqueVersionControlId((VersionedComponent)funnel, ProcessGroup::getFunnels);
            funnel.setProcessGroup((ProcessGroup)this);
            this.funnels.put(funnel.getIdentifier(), funnel);
            this.flowManager.onFunnelAdded(funnel);
            if (autoStart) {
                this.startFunnel(funnel);
            }
            this.onComponentModified();
            LOG.info("{} added to {}", (Object)funnel, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Funnel getFunnel(String id) {
        this.readLock.lock();
        try {
            Funnel funnel = this.funnels.get(id);
            return funnel;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Funnel findFunnel(String id) {
        Funnel funnel = this.flowManager.getFunnel(id);
        if (funnel == null) {
            return funnel;
        }
        if (this.isOwner(funnel.getProcessGroup())) {
            return funnel;
        }
        return null;
    }

    public ControllerServiceNode findControllerService(String id, boolean includeDescendants, boolean includeAncestors) {
        ControllerServiceNode serviceNode = includeDescendants ? this.findDescendantControllerService(id, this) : this.getControllerService(id);
        if (serviceNode == null && includeAncestors) {
            serviceNode = this.findAncestorControllerService(id, this.getParent());
        }
        return serviceNode;
    }

    private ControllerServiceNode findAncestorControllerService(String id, ProcessGroup start) {
        if (start == null) {
            return null;
        }
        ControllerServiceNode serviceNode = start.getControllerService(id);
        if (serviceNode != null) {
            return serviceNode;
        }
        ProcessGroup parent = start.getParent();
        return this.findAncestorControllerService(id, parent);
    }

    private ControllerServiceNode findDescendantControllerService(String id, ProcessGroup start) {
        ControllerServiceNode service = start.getControllerService(id);
        if (service != null) {
            return service;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            service = this.findDescendantControllerService(id, group);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Set<ControllerServiceNode> findAllControllerServices() {
        return this.findAllControllerServices(this);
    }

    private Set<ControllerServiceNode> findAllControllerServices(ProcessGroup start) {
        Set services = start.getControllerServices(false);
        for (ProcessGroup group : start.getProcessGroups()) {
            services.addAll(this.findAllControllerServices(group));
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunnel(Funnel funnel) {
        this.writeLock.lock();
        try {
            Funnel existing = this.funnels.get(Objects.requireNonNull(funnel).getIdentifier());
            if (existing == null) {
                throw new IllegalStateException("Funnel " + funnel.getIdentifier() + " is not a member of this ProcessGroup");
            }
            funnel.verifyCanDelete();
            for (Connection conn : funnel.getConnections()) {
                conn.verifyCanDelete();
            }
            this.stopFunnel(funnel);
            HashSet copy = new HashSet(funnel.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            this.funnels.remove(funnel.getIdentifier());
            this.onComponentModified();
            this.flowManager.onFunnelRemoved(funnel);
            LOG.info("{} removed from flow", (Object)funnel);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Funnel> getFunnels() {
        this.readLock.lock();
        try {
            HashSet<Funnel> hashSet = new HashSet<Funnel>(this.funnels.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControllerService(ControllerServiceNode service) {
        this.writeLock.lock();
        try {
            String id = Objects.requireNonNull(service).getIdentifier();
            ControllerServiceNode existingService = this.controllerServices.get(id);
            if (existingService != null) {
                throw new IllegalStateException("A Controller Service is already registered to this ProcessGroup with ID " + id);
            }
            service.setProcessGroup((ProcessGroup)this);
            this.controllerServices.put(service.getIdentifier(), service);
            LOG.info("{} added to {}", (Object)service, (Object)this);
            this.updateControllerServiceReferences((ComponentNode)service);
            this.onComponentModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ControllerServiceNode getControllerService(String id) {
        return this.controllerServices.get(Objects.requireNonNull(id));
    }

    public Set<ControllerServiceNode> getControllerServices(boolean recursive) {
        ProcessGroup parentGroup;
        HashSet<ControllerServiceNode> services = new HashSet<ControllerServiceNode>(this.controllerServices.values());
        if (recursive && (parentGroup = this.parent.get()) != null) {
            services.addAll(parentGroup.getControllerServices(true));
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControllerService(ControllerServiceNode service) {
        boolean removed = false;
        this.writeLock.lock();
        try {
            ControllerServiceNode existing = this.controllerServices.get(Objects.requireNonNull(service).getIdentifier());
            if (existing == null) {
                throw new IllegalStateException("ControllerService " + service.getIdentifier() + " is not a member of this Process Group");
            }
            service.verifyCanDelete();
            try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)service.getControllerServiceImplementation().getClass(), (String)service.getIdentifier());){
                StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)service, (ControllerServiceLookup)this.controllerServiceProvider, null);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)service.getControllerServiceImplementation(), configurationContext);
            }
            for (Map.Entry entry : service.getEffectivePropertyValues().entrySet()) {
                ControllerServiceNode referencedNode;
                String value;
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (referencedNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
                referencedNode.removeReference((ComponentNode)service, descriptor);
            }
            this.controllerServices.remove(service.getIdentifier());
            this.onComponentModified();
            service.getReferences().getReferencingComponents().stream().map(ComponentAuthorizable::getProcessGroupIdentifier).filter(id -> !id.equals(this.getIdentifier())).forEach(groupId -> {
                ProcessGroup descendant = this.findProcessGroup((String)groupId);
                if (descendant != null) {
                    descendant.onComponentModified();
                }
            });
            this.scheduler.submitFrameworkTask(() -> this.stateManagerProvider.onComponentRemoved(service.getIdentifier()));
            removed = true;
            LOG.info("{} removed from {}", (Object)service, (Object)this);
        }
        finally {
            if (removed) {
                try {
                    this.extensionManager.removeInstanceClassLoader(service.getIdentifier());
                }
                catch (Throwable throwable) {}
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Snippet snippet) {
        this.writeLock.lock();
        try {
            this.verifyContents(snippet);
            Set<Connectable> connectables = this.getAllConnectables(snippet);
            HashSet<String> connectionIdsToRemove = new HashSet<String>(this.getKeys(snippet.getConnections()));
            for (Connectable connectable : connectables) {
                for (Connection conn : connectable.getConnections()) {
                    if (!this.connections.containsKey(conn.getIdentifier())) {
                        throw new IllegalStateException("Connectable component " + connectable.getIdentifier() + " cannot be removed because it has incoming connections from the parent Process Group");
                    }
                    connectionIdsToRemove.add(conn.getIdentifier());
                }
            }
            for (String id : connectionIdsToRemove) {
                this.connections.get(id).verifyCanDelete();
            }
            for (String procId : snippet.getProcessors().keySet()) {
                ProcessorNode procNode = this.getProcessor(procId);
                if (procNode.isRunning()) {
                    throw new IllegalStateException("Processor " + procNode.getIdentifier() + " cannot be removed because it is running");
                }
                int activeThreadCount = procNode.getActiveThreadCount();
                if (activeThreadCount == 0) continue;
                throw new IllegalStateException("Processor " + procNode.getIdentifier() + " cannot be removed because it still has " + activeThreadCount + " active threads");
            }
            Set connectionIds = snippet.getConnections().keySet();
            for (Connectable connectable : connectables) {
                for (Connection conn : connectable.getIncomingConnections()) {
                    if (connectionIds.contains(conn.getIdentifier()) || connectables.contains(conn.getSource())) continue;
                    throw new IllegalStateException("Connectable component " + connectable.getIdentifier() + " cannot be removed because it has incoming connections that are not selected to be deleted");
                }
            }
            for (String groupId : snippet.getProcessGroups().keySet()) {
                ProcessGroup toRemove = this.getProcessGroup(groupId);
                toRemove.verifyCanDelete(true);
            }
            this.onComponentModified();
            for (String id : connectionIdsToRemove) {
                this.removeConnection(this.connections.get(id));
            }
            for (String id : this.getKeys(snippet.getInputPorts())) {
                this.removeInputPort(this.inputPorts.get(id));
            }
            for (String id : this.getKeys(snippet.getOutputPorts())) {
                this.removeOutputPort(this.outputPorts.get(id));
            }
            for (String id : this.getKeys(snippet.getFunnels())) {
                this.removeFunnel(this.funnels.get(id));
            }
            for (String id : this.getKeys(snippet.getLabels())) {
                this.removeLabel(this.labels.get(id));
            }
            for (String id : this.getKeys(snippet.getProcessors())) {
                this.removeProcessor(this.processors.get(id));
            }
            for (String id : this.getKeys(snippet.getRemoteProcessGroups())) {
                this.removeRemoteProcessGroup(this.remoteGroups.get(id));
            }
            for (String id : this.getKeys(snippet.getProcessGroups())) {
                this.removeProcessGroup(this.processGroups.get(id));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<String> getKeys(Map<String, Revision> map) {
        return map == null ? Collections.emptySet() : map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Snippet snippet, ProcessGroup destination) {
        this.writeLock.lock();
        try {
            this.verifyContents(snippet);
            this.verifyDestinationNotInSnippet(snippet, destination);
            SnippetUtils.verifyNoVersionControlConflicts(snippet, this, destination);
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            if (destination.isRootGroup() && (snippet.getInputPorts().keySet().stream().map(this::getInputPort).anyMatch(port -> port instanceof LocalPort) || snippet.getOutputPorts().keySet().stream().map(this::getOutputPort).anyMatch(port -> port instanceof LocalPort))) {
                throw new IllegalStateException("Cannot move local Ports into the root group");
            }
            this.onComponentModified();
            for (String id : this.getKeys(snippet.getInputPorts())) {
                destination.addInputPort(this.inputPorts.remove(id));
            }
            for (String id : this.getKeys(snippet.getOutputPorts())) {
                destination.addOutputPort(this.outputPorts.remove(id));
            }
            for (String id : this.getKeys(snippet.getFunnels())) {
                destination.addFunnel(this.funnels.remove(id));
            }
            for (String id : this.getKeys(snippet.getLabels())) {
                destination.addLabel(this.labels.remove(id));
            }
            for (String id : this.getKeys(snippet.getProcessGroups())) {
                destination.addProcessGroup(this.processGroups.remove(id));
            }
            for (String id : this.getKeys(snippet.getProcessors())) {
                destination.addProcessor(this.processors.remove(id));
            }
            for (String id : this.getKeys(snippet.getRemoteProcessGroups())) {
                destination.addRemoteProcessGroup(this.remoteGroups.remove(id));
            }
            for (String id : this.getKeys(snippet.getConnections())) {
                destination.inheritConnection(this.connections.remove(id));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<Connectable> getAllConnectables(Snippet snippet) {
        HashSet<Connectable> connectables = new HashSet<Connectable>();
        for (String id : this.getKeys(snippet.getInputPorts())) {
            connectables.add((Connectable)this.getInputPort(id));
        }
        for (String id : this.getKeys(snippet.getOutputPorts())) {
            connectables.add((Connectable)this.getOutputPort(id));
        }
        for (String id : this.getKeys(snippet.getFunnels())) {
            connectables.add((Connectable)this.getFunnel(id));
        }
        for (String id : this.getKeys(snippet.getProcessors())) {
            connectables.add((Connectable)this.getProcessor(id));
        }
        return connectables;
    }

    private boolean isDisconnected(Snippet snippet) {
        Set<Connectable> connectables = this.getAllConnectables(snippet);
        for (String string : this.getKeys(snippet.getRemoteProcessGroups())) {
            RemoteProcessGroup remoteGroup = this.getRemoteProcessGroup(string);
            connectables.addAll(remoteGroup.getInputPorts());
            connectables.addAll(remoteGroup.getOutputPorts());
        }
        Set connectionIds = snippet.getConnections().keySet();
        for (Connectable connectable : connectables) {
            for (Connection conn : connectable.getIncomingConnections()) {
                if (connectionIds.contains(conn.getIdentifier())) continue;
                return false;
            }
            for (Connection conn : connectable.getConnections()) {
                if (connectionIds.contains(conn.getIdentifier())) continue;
                return false;
            }
        }
        HashSet<Connectable> hashSet = new HashSet<Connectable>(connectables);
        for (String id : snippet.getProcessGroups().keySet()) {
            ProcessGroup childGroup = this.getProcessGroup(id);
            hashSet.addAll(this.findAllConnectables(childGroup, true));
        }
        for (String id : connectionIds) {
            Connection connection = this.getConnection(id);
            if (hashSet.contains(connection.getSource()) && hashSet.contains(connection.getDestination())) continue;
            return false;
        }
        return true;
    }

    public Set<Positionable> findAllPositionables() {
        HashSet<Positionable> positionables = new HashSet<Positionable>();
        positionables.addAll(this.findAllConnectables(this, true));
        List<ProcessGroup> allProcessGroups = this.findAllProcessGroups();
        positionables.addAll(allProcessGroups);
        positionables.addAll(this.findAllRemoteProcessGroups());
        positionables.addAll(this.findAllLabels());
        return positionables;
    }

    private Set<Connectable> findAllConnectables(ProcessGroup group, boolean includeRemotePorts) {
        HashSet<Connectable> set = new HashSet<Connectable>();
        set.addAll(group.getInputPorts());
        set.addAll(group.getOutputPorts());
        set.addAll(group.getFunnels());
        set.addAll(group.getProcessors());
        if (includeRemotePorts) {
            for (RemoteProcessGroup remoteGroup : group.getRemoteProcessGroups()) {
                set.addAll(remoteGroup.getInputPorts());
                set.addAll(remoteGroup.getOutputPorts());
            }
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            set.addAll(this.findAllConnectables(childGroup, includeRemotePorts));
        }
        return set;
    }

    private void verifyContents(Snippet snippet) throws NullPointerException, IllegalStateException {
        Objects.requireNonNull(snippet);
        this.verifyAllKeysExist(snippet.getInputPorts().keySet(), this.inputPorts, "Input Port");
        this.verifyAllKeysExist(snippet.getOutputPorts().keySet(), this.outputPorts, "Output Port");
        this.verifyAllKeysExist(snippet.getFunnels().keySet(), this.funnels, "Funnel");
        this.verifyAllKeysExist(snippet.getLabels().keySet(), this.labels, "Label");
        this.verifyAllKeysExist(snippet.getProcessGroups().keySet(), this.processGroups, "Process Group");
        this.verifyAllKeysExist(snippet.getProcessors().keySet(), this.processors, "Processor");
        this.verifyAllKeysExist(snippet.getRemoteProcessGroups().keySet(), this.remoteGroups, "Remote Process Group");
        this.verifyAllKeysExist(snippet.getConnections().keySet(), this.connections, "Connection");
    }

    private void verifyDestinationNotInSnippet(Snippet snippet, ProcessGroup destination) throws IllegalStateException {
        if (snippet.getProcessGroups() != null && destination != null) {
            snippet.getProcessGroups().forEach((processGroupId, revision) -> {
                if (processGroupId.equals(destination.getIdentifier())) {
                    throw new IllegalStateException("Unable to move Process Group into itself.");
                }
            });
        }
    }

    private void verifyAllKeysExist(Set<String> ids, Map<String, ?> map, String componentType) {
        if (ids != null) {
            for (String id : ids) {
                if (map.containsKey(id)) continue;
                throw new IllegalStateException("ID " + id + " does not refer to a(n) " + componentType + " in this ProcessGroup");
            }
        }
    }

    public void verifyCanDelete() {
        this.verifyCanDelete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(boolean ignoreConnections) {
        this.readLock.lock();
        try {
            for (Port port : this.inputPorts.values()) {
                port.verifyCanDelete(true);
            }
            for (Port port : this.outputPorts.values()) {
                port.verifyCanDelete(true);
            }
            for (ProcessorNode procNode : this.processors.values()) {
                procNode.verifyCanDelete(true);
            }
            for (Connection connection : this.connections.values()) {
                connection.verifyCanDelete();
            }
            for (ControllerServiceNode cs : this.controllerServices.values()) {
                cs.verifyCanDelete();
            }
            for (ProcessGroup childGroup : this.processGroups.values()) {
                childGroup.verifyCanDelete(true);
            }
            if (!ignoreConnections) {
                for (Port port : this.inputPorts.values()) {
                    for (Connection connection : port.getIncomingConnections()) {
                        if (connection.getSource().equals((Object)port)) {
                            connection.verifyCanDelete();
                            continue;
                        }
                        throw new IllegalStateException("Cannot delete Process Group because Input Port " + port.getIdentifier() + " has at least one incoming connection from a component outside of the Process Group. Delete this connection first.");
                    }
                }
                for (Port port : this.outputPorts.values()) {
                    for (Connection connection : port.getConnections()) {
                        if (connection.getDestination().equals((Object)port)) {
                            connection.verifyCanDelete();
                            continue;
                        }
                        throw new IllegalStateException("Cannot delete Process Group because Output Port " + port.getIdentifier() + " has at least one outgoing connection to a component outside of the Process Group. Delete this connection first.");
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStop(Connectable connectable) {
        ScheduledState state = connectable.getScheduledState();
        if (state == ScheduledState.DISABLED) {
            throw new IllegalStateException("Cannot stop component with id " + String.valueOf(connectable) + " because it is currently disabled.");
        }
    }

    public void verifyCanStop() {
    }

    public void verifyCanStart(Connectable connectable) {
        if (connectable.getScheduledState() == ScheduledState.STOPPED) {
            connectable.verifyCanStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanStart() {
        this.readLock.lock();
        try {
            for (Connectable connectable : this.findAllConnectables(this, false)) {
                this.verifyCanStart(connectable);
            }
            Set<ControllerServiceNode> services = this.findAllControllerServices();
            for (ControllerServiceNode serviceNode : services) {
                serviceNode.verifyCanEnable(services);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanScheduleComponentsIndividually() {
        if (this.resolveExecutionEngine() == ExecutionEngine.STATELESS) {
            throw new IllegalStateException("Cannot schedule components individually because the Process Group is configured to run in Stateless mode.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(Snippet snippet) throws IllegalStateException {
        this.readLock.lock();
        try {
            ProcessGroup group;
            Port port;
            if (!this.id.equals(snippet.getParentGroupId())) {
                throw new IllegalStateException("Snippet belongs to ProcessGroup with ID " + snippet.getParentGroupId() + " but this ProcessGroup has id " + this.id);
            }
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            for (String id : snippet.getConnections().keySet()) {
                Connection connection = this.getConnection(id);
                if (connection == null) {
                    throw new IllegalStateException("Snippet references Connection with ID " + id + ", which does not exist in this ProcessGroup");
                }
                connection.verifyCanDelete();
            }
            for (String id : snippet.getFunnels().keySet()) {
                Funnel funnel = this.getFunnel(id);
                if (funnel == null) {
                    throw new IllegalStateException("Snippet references Funnel with ID " + id + ", which does not exist in this ProcessGroup");
                }
                funnel.verifyCanDelete(true);
            }
            for (String id : snippet.getInputPorts().keySet()) {
                port = this.getInputPort(id);
                if (port == null) {
                    throw new IllegalStateException("Snippet references Input Port with ID " + id + ", which does not exist in this ProcessGroup");
                }
                port.verifyCanDelete(true);
            }
            for (String id : snippet.getLabels().keySet()) {
                Label label = this.getLabel(id);
                if (label != null) continue;
                throw new IllegalStateException("Snippet references Label with ID " + id + ", which does not exist in this ProcessGroup");
            }
            for (String id : snippet.getOutputPorts().keySet()) {
                port = this.getOutputPort(id);
                if (port == null) {
                    throw new IllegalStateException("Snippet references Output Port with ID " + id + ", which does not exist in this ProcessGroup");
                }
                port.verifyCanDelete(true);
            }
            for (String id : snippet.getProcessGroups().keySet()) {
                group = this.getProcessGroup(id);
                if (group == null) {
                    throw new IllegalStateException("Snippet references Process Group with ID " + id + ", which does not exist in this ProcessGroup");
                }
                group.verifyCanDelete(true);
            }
            for (String id : snippet.getProcessors().keySet()) {
                ProcessorNode processor = this.getProcessor(id);
                if (processor == null) {
                    throw new IllegalStateException("Snippet references Processor with ID " + id + ", which does not exist in this ProcessGroup");
                }
                processor.verifyCanDelete(true);
            }
            for (String id : snippet.getRemoteProcessGroups().keySet()) {
                group = this.getRemoteProcessGroup(id);
                if (group == null) {
                    throw new IllegalStateException("Snippet references Remote Process Group with ID " + id + ", which does not exist in this ProcessGroup");
                }
                group.verifyCanDelete(true);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanMove(Snippet snippet, ProcessGroup newProcessGroup) throws IllegalStateException {
        this.readLock.lock();
        try {
            ParameterContext currentParameterContext;
            String portName;
            Port port;
            if (!this.id.equals(snippet.getParentGroupId())) {
                throw new IllegalStateException("Snippet belongs to ProcessGroup with ID " + snippet.getParentGroupId() + " but this ProcessGroup has id " + this.id);
            }
            this.verifyContents(snippet);
            this.verifyDestinationNotInSnippet(snippet, newProcessGroup);
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            ExecutionEngine newGroupExecutionEngine = newProcessGroup.resolveExecutionEngine();
            ExecutionEngine executionEngine = this.resolveExecutionEngine();
            for (String id : snippet.getInputPorts().keySet()) {
                port = this.getInputPort(id);
                portName = port.getName();
                if (newProcessGroup.getInputPortByName(portName) != null) {
                    throw new IllegalStateException("Cannot perform Move Operation because of a naming conflict with another port in the destination Process Group");
                }
                if (newGroupExecutionEngine == executionEngine || !port.isRunning()) continue;
                throw new IllegalStateException("Cannot perform Move Operation because Input Port with ID " + port.getIdentifier() + " is running, and the destination Process Group has a different Execution Engine than the current Process Group. The Port must be stopped before it can be moved to a Process Group with a different Execution Engine.");
            }
            for (String id : snippet.getOutputPorts().keySet()) {
                port = this.getOutputPort(id);
                portName = port.getName();
                if (newProcessGroup.getOutputPortByName(portName) != null) {
                    throw new IllegalStateException("Cannot perform Move Operation because of a naming conflict with another port in the destination Process Group");
                }
                if (newGroupExecutionEngine == executionEngine || !port.isRunning()) continue;
                throw new IllegalStateException("Cannot perform Move Operation because Output Port with ID " + port.getIdentifier() + " is running, and the destination Process Group has a different Execution Engine than the current Process Group. The Port must be stopped before it can be moved to a Process Group with a different Execution Engine.");
            }
            for (String id : snippet.getProcessGroups().keySet()) {
                ProcessGroup childGroup = this.getProcessGroup(id);
                ExecutionEngine childEngine = childGroup.resolveExecutionEngine();
                if (childEngine == ExecutionEngine.STANDARD && newGroupExecutionEngine != ExecutionEngine.STANDARD) {
                    throw new IllegalStateException("Cannot move a Process Group that is configured to run with the Traditional Execution Engine  to a Process Group that is configured to run with the Stateless Execution Engine.");
                }
                if (childEngine != ExecutionEngine.STATELESS || newGroupExecutionEngine != ExecutionEngine.STANDARD || childGroup.getStatelessScheduledState() == StatelessGroupScheduledState.STOPPED) continue;
                throw new IllegalStateException("Cannot move a Process Group that is configured to run with the " + String.valueOf(childEngine) + " Execution Engine to a Process Group that is configured to run with the " + String.valueOf(newGroupExecutionEngine) + " unless all components are stopped");
            }
            if (newGroupExecutionEngine != executionEngine) {
                for (String id : snippet.getProcessors().keySet()) {
                    ProcessorNode procNode = this.getProcessor(id);
                    if (!procNode.isRunning()) continue;
                    throw new IllegalStateException("Cannot perform Move Operation because Processor with ID " + procNode.getIdentifier() + " is running, and the destination Process Group has a different Execution Engine than the current Process Group. The Processor must be stopped before it can be moved to a Process Group with a different Execution Engine.");
                }
                for (String id : snippet.getRemoteProcessGroups().keySet()) {
                    RemoteProcessGroup rpg = this.getRemoteProcessGroup(id);
                    if (!rpg.isTransmitting()) continue;
                    throw new IllegalStateException("Cannot perform Move Operation because Remote Process Group with ID " + rpg.getIdentifier() + " is running, and the destination Process Group has a different Execution Engine than the current Process Group. The Remote Process Group must be stopped before it can be moved to a Process Group with a different Execution Engine.");
                }
            }
            String currentParameterContextId = (currentParameterContext = this.getParameterContext()) == null ? null : currentParameterContext.getIdentifier();
            ParameterContext destinationParameterContext = newProcessGroup.getParameterContext();
            String destinationParameterContextId = destinationParameterContext == null ? null : destinationParameterContext.getIdentifier();
            boolean parameterContextsDiffer = !Objects.equals(currentParameterContextId, destinationParameterContextId);
            Set<ProcessorNode> processors = this.findAllProcessors(snippet);
            for (ProcessorNode processorNode : processors) {
                for (PropertyDescriptor descriptor : processorNode.getProperties().keySet()) {
                    String serviceId;
                    Class serviceDefinition = descriptor.getControllerServiceDefinition();
                    if (serviceDefinition != null && (serviceId = processorNode.getEffectivePropertyValue(descriptor)) != null) {
                        Set currentControllerServiceIds = this.controllerServiceProvider.getControllerServiceIdentifiers(serviceDefinition, this.getIdentifier());
                        Set proposedControllerServiceIds = this.controllerServiceProvider.getControllerServiceIdentifiers(serviceDefinition, newProcessGroup.getIdentifier());
                        if (currentControllerServiceIds.contains(serviceId) && !proposedControllerServiceIds.contains(serviceId)) {
                            throw new IllegalStateException("Cannot perform Move Operation because Processor with ID " + processorNode.getIdentifier() + " references a service that is not available in the destination Process Group");
                        }
                    }
                    if (!parameterContextsDiffer || !processorNode.isRunning() || !processorNode.isReferencingParameter()) continue;
                    throw new IllegalStateException("Cannot perform Move Operation because Processor with ID " + processorNode.getIdentifier() + " references one or more Parameters, and the Processor is running, and the destination Process Group is bound to a different Parameter Context that the current Process Group. This would result in changing the configuration of the Processor while it is running, which is not allowed. You must first stop the Processor before moving it to another Process Group if the destination's Parameter Context is not the same.");
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Set<ProcessorNode> findAllProcessors(Snippet snippet) {
        HashSet<ProcessorNode> processors = new HashSet<ProcessorNode>();
        snippet.getProcessors().keySet().stream().map(this::getProcessor).forEach(processors::add);
        for (String groupId : snippet.getProcessGroups().keySet()) {
            processors.addAll(this.getProcessGroup(groupId).findAllProcessors());
        }
        return processors;
    }

    public ParameterContext getParameterContext() {
        return this.parameterContext;
    }

    public void setParameterContext(ParameterContext parameterContext) {
        this.verifyCanSetParameterContext(parameterContext);
        Map<String, ParameterUpdate> updatedParameters = this.mapParameterUpdates(this.parameterContext, parameterContext);
        LOG.debug("Parameter Context for {} changed from {} to {}. This resulted in {} Parameter Updates ({}). Notifying Processors/Controller Services of the updates.", new Object[]{this, this.parameterContext, parameterContext, updatedParameters.size(), updatedParameters});
        this.parameterContext = parameterContext;
        if (!updatedParameters.isEmpty()) {
            this.onParameterContextUpdated(updatedParameters);
        }
    }

    public void onParameterContextUpdated(Map<String, ParameterUpdate> updatedParameters) {
        this.readLock.lock();
        try {
            this.getProcessors().forEach(proc -> proc.onParametersModified(updatedParameters));
            this.getControllerServices(false).forEach(cs -> cs.onParametersModified(updatedParameters));
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Map<String, ParameterUpdate> mapParameterUpdates(ParameterContext previousParameterContext, ParameterContext updatedParameterContext) {
        if (previousParameterContext == null && updatedParameterContext == null) {
            return Collections.emptyMap();
        }
        if (updatedParameterContext == null) {
            return this.createParameterUpdates(previousParameterContext, (descriptor, value) -> new StandardParameterUpdate(descriptor.getName(), (String)value, null, descriptor.isSensitive()));
        }
        if (previousParameterContext == null) {
            return this.createParameterUpdates(updatedParameterContext, (descriptor, value) -> new StandardParameterUpdate(descriptor.getName(), null, (String)value, descriptor.isSensitive()));
        }
        HashMap<String, ParameterUpdate> updatedParameters = new HashMap<String, ParameterUpdate>();
        for (Map.Entry entry : updatedParameterContext.getEffectiveParameters().entrySet()) {
            String updatedValue;
            ParameterDescriptor updatedDescriptor = (ParameterDescriptor)entry.getKey();
            Parameter updatedParameter = (Parameter)entry.getValue();
            Optional previousParameterOption = previousParameterContext.getParameter(updatedDescriptor);
            String previousValue = previousParameterOption.map(Parameter::getValue).orElse(null);
            if (Objects.equals(previousValue, updatedValue = updatedParameter.getValue())) continue;
            StandardParameterUpdate parameterUpdate = new StandardParameterUpdate(updatedDescriptor.getName(), previousValue, updatedValue, updatedDescriptor.isSensitive());
            updatedParameters.put(updatedDescriptor.getName(), parameterUpdate);
        }
        for (Map.Entry entry : previousParameterContext.getEffectiveParameters().entrySet()) {
            ParameterDescriptor previousDescriptor = (ParameterDescriptor)entry.getKey();
            Parameter previousParameter = (Parameter)entry.getValue();
            Optional updatedParameterOption = updatedParameterContext.getParameter(previousDescriptor);
            if (updatedParameterOption.isPresent()) continue;
            StandardParameterUpdate parameterUpdate = new StandardParameterUpdate(previousDescriptor.getName(), previousParameter.getValue(), null, previousDescriptor.isSensitive());
            updatedParameters.put(previousDescriptor.getName(), parameterUpdate);
        }
        return updatedParameters;
    }

    private Map<String, ParameterUpdate> createParameterUpdates(ParameterContext parameterContext, BiFunction<ParameterDescriptor, String, ParameterUpdate> parameterUpdateMapper) {
        HashMap<String, ParameterUpdate> updatedParameters = new HashMap<String, ParameterUpdate>();
        for (Map.Entry entry : parameterContext.getEffectiveParameters().entrySet()) {
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)entry.getKey();
            Parameter parameter = (Parameter)entry.getValue();
            ParameterUpdate parameterUpdate = parameterUpdateMapper.apply(parameterDescriptor, parameter.getValue());
            updatedParameters.put(parameterDescriptor.getName(), parameterUpdate);
        }
        return updatedParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanSetParameterContext(ParameterContext parameterContext) {
        this.readLock.lock();
        try {
            boolean referencingParam;
            if (Objects.equals(parameterContext, this.getParameterContext())) {
                return;
            }
            for (ProcessorNode processor : this.processors.values()) {
                referencingParam = processor.isReferencingParameter();
                if (!referencingParam) continue;
                if (processor.isRunning()) {
                    throw new IllegalStateException("Cannot change Parameter Context for " + String.valueOf(this) + " because " + String.valueOf(processor) + " is referencing at least one Parameter and is running");
                }
                this.verifyParameterSensitivityIsValid((ComponentNode)processor, parameterContext);
            }
            for (ControllerServiceNode service : this.controllerServices.values()) {
                referencingParam = service.isReferencingParameter();
                if (!referencingParam) continue;
                if (service.getState() != ControllerServiceState.DISABLED) {
                    throw new IllegalStateException("Cannot change Parameter Context for " + String.valueOf(this) + " because " + String.valueOf(service) + " is referencing at least one Parameter and is not disabled");
                }
                this.verifyParameterSensitivityIsValid((ComponentNode)service, parameterContext);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void verifyParameterSensitivityIsValid(ComponentNode component, ParameterContext parameterContext) {
        if (parameterContext == null) {
            return;
        }
        Map properties = component.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            if (configuration == null) continue;
            for (ParameterReference reference : configuration.getParameterReferences()) {
                String paramName = reference.getParameterName();
                Optional parameter = parameterContext.getParameter(paramName);
                if (!parameter.isPresent()) continue;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getKey();
                if (((Parameter)parameter.get()).getDescriptor().isSensitive() && !propertyDescriptor.isSensitive()) {
                    throw new IllegalStateException("Cannot change Parameter Context for " + String.valueOf(this) + " because " + String.valueOf(component) + " is referencing Parameter '" + paramName + "' from the '" + propertyDescriptor.getDisplayName() + "' property and the Parameter is sensitive. Sensitive Parameters may only be referenced by sensitive properties.");
                }
                if (((Parameter)parameter.get()).getDescriptor().isSensitive() || !propertyDescriptor.isSensitive()) continue;
                throw new IllegalStateException("Cannot change Parameter Context for " + String.valueOf(this) + " because " + String.valueOf(component) + " is referencing Parameter '" + paramName + "' from a sensitive property and the Parameter is not sensitive. Sensitive properties may only reference by Sensitive Parameters.");
            }
        }
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String componentId) {
        block7: {
            this.writeLock.lock();
            try {
                String currentId = this.versionedComponentId.get();
                if (currentId == null) {
                    this.versionedComponentId.set(componentId);
                    LOG.info("Set Versioned Component ID of {} to {}", (Object)this, (Object)componentId);
                    break block7;
                }
                if (currentId.equals(componentId)) {
                    return;
                }
                if (componentId == null) {
                    this.versionedComponentId.set(null);
                    LOG.info("Cleared Versioned Component ID for {}", (Object)this);
                    break block7;
                }
                throw new IllegalStateException(String.valueOf(this) + " is already under version control with a different Versioned Component ID");
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public VersionControlInformation getVersionControlInformation() {
        return this.versionControlInfo.get();
    }

    public void onComponentModified() {
        ProcessGroup parentGroup;
        StandardVersionControlInformation svci = this.versionControlInfo.get();
        if (svci == null && (parentGroup = this.parent.get()) != null) {
            parentGroup.onComponentModified();
        }
        this.versionControlFields.setFlowDifferences(null);
        this.flowManager.getFlowAnalyzer().ifPresent(flowManager -> flowManager.setFlowAnalysisRequired(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersionControlInformation(final VersionControlInformation versionControlInformation, Map<String, String> versionedComponentIds) {
        StandardVersionControlInformation svci = new StandardVersionControlInformation(versionControlInformation.getRegistryIdentifier(), versionControlInformation.getRegistryName(), versionControlInformation.getBranch(), versionControlInformation.getBucketIdentifier(), versionControlInformation.getFlowIdentifier(), versionControlInformation.getVersion(), versionControlInformation.getStorageLocation(), this.stripContentsFromRemoteDescendantGroups(versionControlInformation.getFlowSnapshot(), true), versionControlInformation.getStatus()){

            @Override
            public String getRegistryName() {
                String registryId = versionControlInformation.getRegistryIdentifier();
                FlowRegistryClientNode registry = StandardProcessGroup.this.flowManager.getFlowRegistryClient(registryId);
                return registry == null ? registryId : registry.getName();
            }

            private boolean isModified() {
                if (versionControlInformation.getVersion() == null) {
                    return true;
                }
                Set<FlowDifference> differences = StandardProcessGroup.this.versionControlFields.getFlowDifferences();
                if (differences == null) {
                    differences = StandardProcessGroup.this.getModifications();
                    if (differences == null) {
                        return false;
                    }
                    StandardProcessGroup.this.versionControlFields.setFlowDifferences(differences);
                }
                return !differences.isEmpty();
            }

            @Override
            public VersionedFlowStatus getStatus() {
                String syncFailureExplanation = StandardProcessGroup.this.versionControlFields.getSyncFailureExplanation();
                if (syncFailureExplanation != null) {
                    return new StandardVersionedFlowStatus(VersionedFlowState.SYNC_FAILURE, syncFailureExplanation);
                }
                try {
                    VersionControlInformation vci;
                    boolean modified = this.isModified();
                    if (!modified && (vci = (VersionControlInformation)StandardProcessGroup.this.versionControlInfo.get()).getFlowSnapshot() == null) {
                        return new StandardVersionedFlowStatus(VersionedFlowState.SYNC_FAILURE, "Process Group has not yet been synchronized with Flow Registry");
                    }
                    boolean stale = StandardProcessGroup.this.versionControlFields.isStale();
                    VersionedFlowState flowState = modified && stale ? VersionedFlowState.LOCALLY_MODIFIED_AND_STALE : (modified ? VersionedFlowState.LOCALLY_MODIFIED : (stale ? VersionedFlowState.STALE : VersionedFlowState.UP_TO_DATE));
                    return new StandardVersionedFlowStatus(flowState, flowState.getDescription());
                }
                catch (Exception e) {
                    LOG.warn("Could not correctly determine Versioned Flow Status for {}. Will consider state to be SYNC_FAILURE", (Object)this, (Object)e);
                    return new StandardVersionedFlowStatus(VersionedFlowState.SYNC_FAILURE, "Could not properly determine flow status due to: " + String.valueOf(e));
                }
            }
        };
        svci.setBucketName(versionControlInformation.getBucketName());
        svci.setFlowName(versionControlInformation.getFlowName());
        svci.setFlowDescription(versionControlInformation.getFlowDescription());
        svci.setStorageLocation(versionControlInformation.getStorageLocation());
        VersionedFlowState flowState = versionControlInformation.getStatus().getState();
        this.versionControlFields.setStale(flowState == VersionedFlowState.STALE || flowState == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE);
        this.versionControlFields.setLocallyModified(flowState == VersionedFlowState.LOCALLY_MODIFIED || flowState == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE);
        this.versionControlFields.setSyncFailureExplanation(flowState == VersionedFlowState.SYNC_FAILURE ? versionControlInformation.getStatus().getStateExplanation() : null);
        this.writeLock.lock();
        try {
            this.updateVersionedComponentIds(this, versionedComponentIds);
            this.versionControlInfo.set(svci);
            this.versionControlFields.setFlowDifferences(null);
            ProcessGroup parent = this.getParent();
            if (parent != null) {
                parent.onComponentModified();
            }
            this.scheduler.submitFrameworkTask(() -> this.synchronizeWithFlowRegistry(this.flowManager));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private VersionedProcessGroup stripContentsFromRemoteDescendantGroups(VersionedProcessGroup processGroup, boolean topLevel) {
        if (processGroup == null) {
            return null;
        }
        VersionedProcessGroup copy = new VersionedProcessGroup();
        copy.setComments(processGroup.getComments());
        copy.setComponentType(processGroup.getComponentType());
        copy.setGroupIdentifier(processGroup.getGroupIdentifier());
        copy.setIdentifier(processGroup.getIdentifier());
        copy.setName(processGroup.getName());
        copy.setFlowFileConcurrency(processGroup.getFlowFileConcurrency());
        copy.setFlowFileOutboundPolicy(processGroup.getFlowFileOutboundPolicy());
        copy.setDefaultFlowFileExpiration(processGroup.getDefaultFlowFileExpiration());
        copy.setDefaultBackPressureObjectThreshold(processGroup.getDefaultBackPressureObjectThreshold());
        copy.setDefaultBackPressureDataSizeThreshold(processGroup.getDefaultBackPressureDataSizeThreshold());
        copy.setPosition(processGroup.getPosition());
        copy.setVersionedFlowCoordinates(topLevel ? null : processGroup.getVersionedFlowCoordinates());
        copy.setConnections(processGroup.getConnections());
        copy.setControllerServices(processGroup.getControllerServices());
        copy.setFunnels(processGroup.getFunnels());
        copy.setInputPorts(processGroup.getInputPorts());
        copy.setOutputPorts(processGroup.getOutputPorts());
        copy.setProcessors(processGroup.getProcessors());
        copy.setRemoteProcessGroups(processGroup.getRemoteProcessGroups());
        copy.setLabels(processGroup.getLabels());
        copy.setParameterContextName(processGroup.getParameterContextName());
        copy.setExecutionEngine(processGroup.getExecutionEngine());
        copy.setMaxConcurrentTasks(processGroup.getMaxConcurrentTasks());
        copy.setStatelessFlowTimeout(processGroup.getStatelessFlowTimeout());
        HashSet<VersionedProcessGroup> copyChildren = new HashSet<VersionedProcessGroup>();
        for (VersionedProcessGroup childGroup : processGroup.getProcessGroups()) {
            if (childGroup.getVersionedFlowCoordinates() == null) {
                copyChildren.add(this.stripContentsFromRemoteDescendantGroups(childGroup, false));
                continue;
            }
            VersionedProcessGroup childCopy = new VersionedProcessGroup();
            childCopy.setComments(childGroup.getComments());
            childCopy.setComponentType(childGroup.getComponentType());
            childCopy.setGroupIdentifier(childGroup.getGroupIdentifier());
            childCopy.setIdentifier(childGroup.getIdentifier());
            childCopy.setName(childGroup.getName());
            childCopy.setPosition(childGroup.getPosition());
            childCopy.setVersionedFlowCoordinates(childGroup.getVersionedFlowCoordinates());
            childCopy.setFlowFileConcurrency(childGroup.getFlowFileConcurrency());
            childCopy.setFlowFileOutboundPolicy(childGroup.getFlowFileOutboundPolicy());
            childCopy.setDefaultFlowFileExpiration(childGroup.getDefaultFlowFileExpiration());
            childCopy.setDefaultBackPressureObjectThreshold(childGroup.getDefaultBackPressureObjectThreshold());
            childCopy.setDefaultBackPressureDataSizeThreshold(childGroup.getDefaultBackPressureDataSizeThreshold());
            childCopy.setParameterContextName(childGroup.getParameterContextName());
            childCopy.setExecutionEngine(childGroup.getExecutionEngine());
            childCopy.setMaxConcurrentTasks(childGroup.getMaxConcurrentTasks());
            childCopy.setStatelessFlowTimeout(childGroup.getStatelessFlowTimeout());
            copyChildren.add(childCopy);
        }
        copy.setProcessGroups(copyChildren);
        return copy;
    }

    public void disconnectVersionControl(boolean removeVersionedComponentIds) {
        this.writeLock.lock();
        try {
            this.versionControlInfo.set(null);
            if (removeVersionedComponentIds) {
                this.applyVersionedComponentIds(this, id -> null);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateVersionedComponentIds(ProcessGroup processGroup, Map<String, String> versionedComponentIds) {
        if (versionedComponentIds == null || versionedComponentIds.isEmpty()) {
            return;
        }
        this.applyVersionedComponentIds(processGroup, versionedComponentIds::get);
        ProcessGroup parent = processGroup.getParent();
        if (parent != null) {
            for (ControllerServiceNode service : parent.getControllerServices(true)) {
                String versionedId;
                if (service.getVersionedComponentId().isPresent() || (versionedId = versionedComponentIds.get(service.getIdentifier())) == null) continue;
                service.setVersionedComponentId(versionedId);
            }
        }
    }

    private void applyVersionedComponentIds(ProcessGroup processGroup, Function<String, String> lookup) {
        processGroup.setVersionedComponentId(lookup.apply(processGroup.getIdentifier()));
        processGroup.getConnections().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getProcessors().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getInputPorts().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getOutputPorts().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getLabels().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getFunnels().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getControllerServices(false).forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getRemoteProcessGroups().forEach(rpg -> {
            rpg.setVersionedComponentId((String)lookup.apply(rpg.getIdentifier()));
            rpg.getInputPorts().forEach(port -> port.setVersionedComponentId((String)lookup.apply(port.getIdentifier())));
            rpg.getOutputPorts().forEach(port -> port.setVersionedComponentId((String)lookup.apply(port.getIdentifier())));
        });
        for (ProcessGroup childGroup : processGroup.getProcessGroups()) {
            if (childGroup.getVersionControlInformation() == null) {
                this.applyVersionedComponentIds(childGroup, lookup);
                continue;
            }
            if (childGroup.getVersionedComponentId().isPresent()) continue;
            childGroup.setVersionedComponentId(lookup.apply(childGroup.getIdentifier()));
        }
    }

    public void synchronizeWithFlowRegistry(FlowManager flowManager) {
        StandardVersionControlInformation vci = this.versionControlInfo.get();
        if (vci == null) {
            return;
        }
        String registryId = vci.getRegistryIdentifier();
        FlowRegistryClientNode flowRegistry = flowManager.getFlowRegistryClient(registryId);
        if (flowRegistry == null) {
            String message = String.format("Unable to synchronize Process Group with Flow Registry because Process Group was placed under Version Control using Flow Registry with identifier %s but cannot find any Flow Registry with this identifier", registryId);
            this.versionControlFields.setSyncFailureExplanation(message);
            LOG.error("Unable to synchronize {} with Flow Registry because Process Group was placed under Version Control using Flow Registry with identifier {} but cannot find any Flow Registry with this identifier", (Object)this, (Object)registryId);
            return;
        }
        VersionedProcessGroup snapshot = vci.getFlowSnapshot();
        if (snapshot == null && vci.getVersion() != null) {
            try {
                ValidationStatus validationStatus = flowRegistry.getValidationStatus(10L, TimeUnit.SECONDS);
                if (validationStatus == ValidationStatus.VALIDATING) {
                    throw new FlowRegistryException(String.valueOf(flowRegistry) + " cannot currently be used to synchronize with Flow Registry because it is currently validating");
                }
                FlowVersionLocation flowVersionLocation = new FlowVersionLocation(vci.getBranch(), vci.getBucketIdentifier(), vci.getFlowIdentifier(), vci.getVersion());
                FlowSnapshotContainer registrySnapshotContainer = flowRegistry.getFlowContents(FlowRegistryClientContextFactory.getAnonymousContext(), flowVersionLocation, false);
                RegisteredFlowSnapshot registrySnapshot = registrySnapshotContainer.getFlowSnapshot();
                VersionedProcessGroup registryFlow = registrySnapshot.getFlowContents();
                vci.setFlowSnapshot(registryFlow);
            }
            catch (IOException | FlowRegistryException e) {
                String message = String.format("Failed to synchronize Process Group with Flow Registry because could not retrieve version %s of flow with identifier %s in bucket %s", vci.getVersion(), vci.getFlowIdentifier(), vci.getBucketIdentifier());
                this.versionControlFields.setSyncFailureExplanation(message);
                String logErrorMessage = "Failed to synchronize {} with Flow Registry because could not retrieve version {} of flow with identifier {} in bucket {}";
                if (e instanceof ConnectException) {
                    LOG.error("Failed to synchronize {} with Flow Registry because could not retrieve version {} of flow with identifier {} in bucket {} due to: {}", new Object[]{this, vci.getVersion(), vci.getFlowIdentifier(), vci.getBucketIdentifier(), e.getLocalizedMessage()});
                } else {
                    LOG.error("Failed to synchronize {} with Flow Registry because could not retrieve version {} of flow with identifier {} in bucket {}", new Object[]{this, vci.getVersion(), vci.getFlowIdentifier(), vci.getBucketIdentifier(), e});
                }
                return;
            }
        }
        try {
            FlowLocation flowLocation = new FlowLocation(vci.getBranch(), vci.getBucketIdentifier(), vci.getFlowIdentifier());
            RegisteredFlow versionedFlow = flowRegistry.getFlow(FlowRegistryClientContextFactory.getAnonymousContext(), flowLocation);
            String latestVersion = flowRegistry.getLatestVersion(FlowRegistryClientContextFactory.getAnonymousContext(), flowLocation).orElse(null);
            vci.setBucketName(versionedFlow.getBucketName());
            vci.setFlowName(versionedFlow.getName());
            vci.setFlowDescription(versionedFlow.getDescription());
            vci.setRegistryName(flowRegistry.getName());
            if (Objects.equals(latestVersion, vci.getVersion())) {
                this.versionControlFields.setStale(false);
                if (latestVersion == null) {
                    LOG.debug("{} does not have any version in the Registry", (Object)this);
                    this.versionControlFields.setLocallyModified(true);
                } else {
                    LOG.debug("{} is currently at the most recent version ({}) of the flow that is under Version Control", (Object)this, (Object)latestVersion);
                }
            } else {
                LOG.info("{} is not the most recent version of the flow that is under Version Control; current version is {}; most recent version is {}", new Object[]{this, vci.getVersion(), latestVersion});
                this.versionControlFields.setStale(true);
            }
            this.versionControlFields.setSyncFailureExplanation(null);
        }
        catch (IOException | FlowRegistryException e) {
            String message = "Failed to synchronize Process Group with Flow Registry : " + e.getMessage();
            this.versionControlFields.setSyncFailureExplanation(message);
            LOG.error("Failed to synchronize {} with Flow Registry because could not determine the most recent version of the Flow in the Flow Registry", (Object)this, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentAdditions addVersionedComponents(VersionedComponentAdditions additions, String componentIdSeed) {
        ComponentIdGenerator idGenerator = (proposedId, instanceId, destinationGroupId) -> this.generateUuid(proposedId, destinationGroupId, componentIdSeed);
        FlowSynchronizationOptions synchronizationOptions = new FlowSynchronizationOptions.Builder().componentIdGenerator(idGenerator).componentComparisonIdLookup(org.apache.nifi.flow.VersionedComponent::getIdentifier).componentScheduler(ComponentScheduler.NOP_SCHEDULER).propertyDecryptor(value -> null).build();
        this.writeLock.lock();
        try {
            VersionedFlowSynchronizationContext groupSynchronizationContext = this.createGroupSynchronizationContext(synchronizationOptions.getComponentIdGenerator(), synchronizationOptions.getComponentScheduler(), FlowMappingOptions.DEFAULT_OPTIONS);
            StandardVersionedComponentSynchronizer synchronizer = new StandardVersionedComponentSynchronizer(groupSynchronizationContext);
            synchronizer.verifyCanAddVersionedComponents(this, additions);
            ComponentAdditions componentAdditions = synchronizer.addVersionedComponentsToProcessGroup(this, additions, synchronizationOptions);
            return componentAdditions;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void updateFlow(VersionedExternalFlow proposedSnapshot, String componentIdSeed, boolean verifyNotDirty, boolean updateSettings, boolean updateDescendantVersionedFlows) {
        ComponentIdGenerator idGenerator = (proposedId, instanceId, destinationGroupId) -> this.generateUuid(proposedId, destinationGroupId, componentIdSeed);
        VersionedComponentStateLookup stateLookup = VersionedComponentStateLookup.ENABLED_OR_DISABLED;
        DefaultComponentScheduler defaultComponentScheduler = new DefaultComponentScheduler(this.controllerServiceProvider, stateLookup);
        RetainExistingStateComponentScheduler retainExistingStateScheduler = new RetainExistingStateComponentScheduler(this, (ComponentScheduler)defaultComponentScheduler);
        FlowSynchronizationOptions synchronizationOptions = new FlowSynchronizationOptions.Builder().componentIdGenerator(idGenerator).componentComparisonIdLookup(org.apache.nifi.flow.VersionedComponent::getIdentifier).componentScheduler((ComponentScheduler)retainExistingStateScheduler).ignoreLocalModifications(!verifyNotDirty).updateDescendantVersionedFlows(updateDescendantVersionedFlows).updateGroupSettings(updateSettings).updateGroupVersionControlSnapshot(true).updateRpgUrls(false).propertyDecryptor(value -> null).build();
        FlowMappingOptions flowMappingOptions = new FlowMappingOptions.Builder().mapSensitiveConfiguration(false).mapPropertyDescriptors(true).stateLookup(stateLookup).sensitiveValueEncryptor(null).componentIdLookup(ComponentIdLookup.VERSIONED_OR_GENERATE).mapInstanceIdentifiers(false).mapControllerServiceReferencesToVersionedId(true).mapFlowRegistryClientId(false).mapAssetReferences(false).build();
        this.synchronizeFlow(proposedSnapshot, synchronizationOptions, flowMappingOptions);
    }

    private ProcessContext createProcessContext(ProcessorNode processorNode) {
        return new StandardProcessContext(processorNode, this.controllerServiceProvider, this.stateManagerProvider.getStateManager(processorNode.getIdentifier()), () -> false, this.nodeTypeProvider);
    }

    private ConfigurationContext createConfigurationContext(ComponentNode component) {
        String schedulingPeriod = component instanceof ReportingTaskNode ? ((ReportingTaskNode)component).getSchedulingPeriod() : null;
        return new StandardConfigurationContext(component, (ControllerServiceLookup)this.controllerServiceProvider, schedulingPeriod, component.getEffectivePropertyValues(), component.getAnnotationData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeFlow(VersionedExternalFlow proposedSnapshot, FlowSynchronizationOptions synchronizationOptions, FlowMappingOptions flowMappingOptions) {
        this.writeLock.lock();
        try {
            this.verifyCanUpdate(proposedSnapshot, true, !synchronizationOptions.isIgnoreLocalModifications());
            VersionedFlowSynchronizationContext groupSynchronizationContext = this.createGroupSynchronizationContext(synchronizationOptions.getComponentIdGenerator(), synchronizationOptions.getComponentScheduler(), flowMappingOptions);
            StandardVersionedComponentSynchronizer synchronizer = new StandardVersionedComponentSynchronizer(groupSynchronizationContext);
            StandardVersionControlInformation originalVci = this.versionControlInfo.get();
            try {
                synchronizer.synchronize(this, proposedSnapshot, synchronizationOptions);
            }
            catch (Throwable t) {
                if (this.versionControlInfo.get() == null) {
                    this.versionControlInfo.set(originalVci);
                }
                throw t;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getAncestorServiceIds() {
        ProcessGroup parentGroup = this.getParent();
        Set<String> ancestorServiceIds = parentGroup == null ? Collections.emptySet() : parentGroup.getControllerServices(true).stream().map(cs -> cs.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(cs.getIdentifier()))).collect(Collectors.toSet());
        return ancestorServiceIds;
    }

    private String generateUuid(String propposedId, String destinationGroupId, String seed) {
        UUID uuid;
        long msb = UUID.nameUUIDFromBytes((propposedId + destinationGroupId).getBytes(StandardCharsets.UTF_8)).getMostSignificantBits();
        if (StringUtils.isBlank((CharSequence)seed)) {
            long lsb = randomGenerator.nextLong();
            uuid = new UUID(msb, lsb);
        } else {
            UUID seedId = UUID.nameUUIDFromBytes((propposedId + destinationGroupId + seed).getBytes(StandardCharsets.UTF_8));
            uuid = new UUID(msb, seedId.getLeastSignificantBits());
        }
        LOG.debug("Generating UUID {} from currentId={}, seed={}", new Object[]{uuid, propposedId, seed});
        return uuid.toString();
    }

    private Set<FlowDifference> getModifications() {
        StandardVersionControlInformation vci = this.versionControlInfo.get();
        if (vci == null) {
            return null;
        }
        if (vci.getFlowSnapshot() == null) {
            return null;
        }
        try {
            NiFiRegistryFlowMapper mapper = new NiFiRegistryFlowMapper(this.extensionManager);
            InstantiatedVersionedProcessGroup versionedGroup = mapper.mapProcessGroup(this, this.controllerServiceProvider, this.flowManager, false);
            StandardComparableDataFlow currentFlow = new StandardComparableDataFlow("Local Flow", (VersionedProcessGroup)versionedGroup);
            StandardComparableDataFlow snapshotFlow = new StandardComparableDataFlow("Versioned Flow", vci.getFlowSnapshot());
            StandardFlowComparator flowComparator = new StandardFlowComparator((ComparableDataFlow)snapshotFlow, (ComparableDataFlow)currentFlow, this.getAncestorServiceIds(), (DifferenceDescriptor)new EvolvingDifferenceDescriptor(), arg_0 -> ((PropertyEncryptor)this.encryptor).decrypt(arg_0), org.apache.nifi.flow.VersionedComponent::getIdentifier, FlowComparatorVersionedStrategy.SHALLOW);
            FlowComparison comparison = flowComparator.compare();
            Set differences = comparison.getDifferences().stream().filter(difference -> !FlowDifferenceFilters.isEnvironmentalChange(difference, versionedGroup, this.flowManager)).collect(Collectors.toCollection(HashSet::new));
            LOG.debug("There are {} differences between this Local Flow and the Versioned Flow: {}", (Object)differences.size(), (Object)differences);
            return differences;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Could not compute differences between local flow and Versioned Flow in NiFi Registry for " + String.valueOf(this), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanUpdate(VersionedExternalFlow updatedFlow, boolean verifyConnectionRemoval, boolean verifyNotDirty) {
        this.readLock.lock();
        try {
            VersionControlInformation versionControlInfo = this.getVersionControlInformation();
            if (versionControlInfo != null) {
                if (!versionControlInfo.getFlowIdentifier().equals(updatedFlow.getMetadata().getFlowIdentifier())) {
                    throw new IllegalStateException(String.valueOf(this) + " is under version control but the given flow does not match the flow that this Process Group is synchronized with. Currently synced to flow with ID " + versionControlInfo.getFlowIdentifier() + " but proposed flow's metadata shows flow identifier as " + updatedFlow.getMetadata().getFlowIdentifier());
                }
                if (verifyNotDirty) {
                    VersionedFlowState flowState = versionControlInfo.getStatus().getState();
                    boolean modified = flowState == VersionedFlowState.LOCALLY_MODIFIED || flowState == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE;
                    Set<FlowDifference> modifications = this.getModifications();
                    if (modified) {
                        String changes = modifications.stream().map(FlowDifference::toString).collect(Collectors.joining("\n"));
                        LOG.error("Cannot change the Version of the flow for {} because the Process Group has been modified ({} modifications) since it was last synchronized with the Flow Registry. The following differences were found:\n{}", new Object[]{this, modifications.size(), changes});
                        throw new IllegalStateException("Cannot change the Version of the flow for " + String.valueOf(this) + " because the Process Group has been modified (" + modifications.size() + " modifications) since it was last synchronized with the Flow Registry. The Process Group must be reverted to its original form before changing the version.");
                    }
                }
                this.verifyNoDescendantsWithLocalModifications("be updated");
            }
            ComponentIdGenerator componentIdGenerator = (proposedId, instanceId, destinationGroupId) -> proposedId;
            VersionedFlowSynchronizationContext groupSynchronizationContext = this.createGroupSynchronizationContext(componentIdGenerator, ComponentScheduler.NOP_SCHEDULER, FlowMappingOptions.DEFAULT_OPTIONS);
            StandardVersionedComponentSynchronizer synchronizer = new StandardVersionedComponentSynchronizer(groupSynchronizationContext);
            synchronizer.verifyCanSynchronize(this, updatedFlow.getFlowContents(), verifyConnectionRemoval);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private VersionedFlowSynchronizationContext createGroupSynchronizationContext(ComponentIdGenerator componentIdGenerator, ComponentScheduler componentScheduler, FlowMappingOptions flowMappingOptions) {
        return new VersionedFlowSynchronizationContext.Builder().componentIdGenerator(componentIdGenerator).flowManager(this.flowManager).reloadComponent(this.reloadComponent).controllerServiceProvider(this.controllerServiceProvider).extensionManager(this.extensionManager).componentScheduler(componentScheduler).flowMappingOptions(flowMappingOptions).processContextFactory(this::createProcessContext).configurationContextFactory(this::createConfigurationContext).assetManager(this.assetManager).build();
    }

    public void verifyCanSaveToFlowRegistry(String registryId, FlowLocation flowLocation, String saveAction) {
        this.verifyNoDescendantsWithLocalModifications("be saved to a Flow Registry");
        StandardVersionControlInformation vci = this.versionControlInfo.get();
        if (vci != null) {
            String flowId = flowLocation.getFlowId();
            if (flowId != null && flowId.equals(vci.getFlowIdentifier())) {
                VersionedFlowState state = vci.getStatus().getState();
                if (state == VersionedFlowState.STALE || state == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE && "COMMIT".equals(saveAction)) {
                    throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group in the flow is not synchronized with the most recent version of the Flow in the Flow Registry. In order to publish a new version of the Flow, the Process Group must first be in synch with the latest version in the Flow Registry.");
                }
                String branch = flowLocation.getBranch();
                if (branch != null && !Objects.equals(branch, vci.getBranch())) {
                    throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group is currently synchronized with a different Versioned Flow than the one specified in the request.");
                }
                String bucketId = flowLocation.getBucketId();
                if (!bucketId.equals(vci.getBucketIdentifier())) {
                    throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group is currently synchronized with a different Versioned Flow than the one specified in the request.");
                }
                if (!registryId.equals(vci.getRegistryIdentifier())) {
                    throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group is currently synchronized with a different Versioned Flow than the one specified in the request.");
                }
            } else if (flowId != null) {
                throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group is currently synchronized with a different Versioned Flow than the one specified in the request.");
            }
        }
    }

    public void verifyCanRevertLocalModifications() {
        StandardVersionControlInformation svci = this.versionControlInfo.get();
        if (svci == null) {
            throw new IllegalStateException("Cannot revert local modifications to Process Group because the Process Group is not under Version Control.");
        }
        this.verifyNoDescendantsWithLocalModifications("have its local modifications reverted");
    }

    public void verifyCanShowLocalModifications() {
    }

    private void verifyNoDescendantsWithLocalModifications(String action) {
        for (ProcessGroup descendant : this.findAllProcessGroups()) {
            boolean modified;
            VersionControlInformation descendantVci = descendant.getVersionControlInformation();
            if (descendantVci == null) continue;
            VersionedFlowState flowState = descendantVci.getStatus().getState();
            boolean bl = modified = flowState == VersionedFlowState.LOCALLY_MODIFIED || flowState == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE;
            if (modified) {
                throw new IllegalStateException("Process Group cannot " + action + " because it contains a child or descendant Process Group that is under Version Control and has local modifications. Each descendant Process Group that is under Version Control must first be reverted or have its changes pushed to the Flow Registry before this action can be performed on the parent Process Group.");
            }
            if (flowState != VersionedFlowState.SYNC_FAILURE) continue;
            throw new IllegalStateException("Process Group cannot " + action + " because it contains a child or descendant Process Group that is under Version Control and is not synchronized with the Flow Registry. Each descendant Process Group must first be synchronized with the Flow Registry before this action can be performed on the parent Process Group. NiFi will continue to attempt to communicate with the Flow Registry periodically in the background.");
        }
    }

    public FlowFileGate getFlowFileGate() {
        return this.flowFileGate;
    }

    public FlowFileConcurrency getFlowFileConcurrency() {
        this.readLock.lock();
        try {
            FlowFileConcurrency flowFileConcurrency = this.flowFileConcurrency;
            return flowFileConcurrency;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setFlowFileConcurrency(FlowFileConcurrency flowFileConcurrency) {
        this.writeLock.lock();
        try {
            if (this.flowFileConcurrency == flowFileConcurrency) {
                return;
            }
            this.flowFileConcurrency = flowFileConcurrency;
            switch (flowFileConcurrency) {
                case UNBOUNDED: {
                    this.flowFileGate = new UnboundedFlowFileGate();
                    break;
                }
                case SINGLE_FLOWFILE_PER_NODE: {
                    this.flowFileGate = new SingleConcurrencyFlowFileGate();
                    break;
                }
                case SINGLE_BATCH_PER_NODE: {
                    this.flowFileGate = new SingleBatchFlowFileGate();
                }
            }
            this.setBatchCounts(this.getFlowFileOutboundPolicy(), flowFileConcurrency);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isDataQueued() {
        return this.isDataQueued(connection -> true);
    }

    public boolean isDataQueuedForProcessing() {
        return this.isDataQueued(connection -> connection.getDestination().getConnectableType() != ConnectableType.OUTPUT_PORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDataQueued(Predicate<Connection> connectionFilter) {
        this.readLock.lock();
        try {
            for (Connection connection : this.connections.values()) {
                if (!connectionFilter.test(connection)) continue;
                boolean queueEmpty = connection.getFlowFileQueue().isEmpty();
                if (queueEmpty) continue;
                boolean bl = true;
                return bl;
            }
            for (ProcessGroup child : this.processGroups.values()) {
                if (!child.isDataQueued()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public FlowFileOutboundPolicy getFlowFileOutboundPolicy() {
        return this.flowFileOutboundPolicy;
    }

    public void setFlowFileOutboundPolicy(FlowFileOutboundPolicy flowFileOutboundPolicy) {
        this.flowFileOutboundPolicy = flowFileOutboundPolicy;
        this.setBatchCounts(flowFileOutboundPolicy, this.getFlowFileConcurrency());
    }

    private synchronized void setBatchCounts(FlowFileOutboundPolicy outboundPolicy, FlowFileConcurrency flowFileConcurrency) {
        if (outboundPolicy == FlowFileOutboundPolicy.BATCH_OUTPUT && flowFileConcurrency == FlowFileConcurrency.SINGLE_FLOWFILE_PER_NODE) {
            if (this.batchCounts instanceof NoOpBatchCounts) {
                StateManager stateManager = this.stateManagerProvider.getStateManager(this.getIdentifier());
                this.batchCounts = new StandardBatchCounts(this, stateManager);
            }
        } else {
            if (this.batchCounts != null) {
                this.batchCounts.reset();
            }
            this.batchCounts = new NoOpBatchCounts();
        }
    }

    public DataValve getDataValve(Port port) {
        ProcessGroup portGroupsParent = port.getProcessGroup().getParent();
        return portGroupsParent == null ? this.getDataValve() : portGroupsParent.getDataValve();
    }

    public DataValve getDataValve() {
        return this.dataValve;
    }

    public boolean referencesParameterContext(ParameterContext parameterContext) {
        ParameterContext ownParameterContext = this.getParameterContext();
        if (ownParameterContext == null || parameterContext == null) {
            return false;
        }
        return ownParameterContext.getIdentifier().equals(parameterContext.getIdentifier()) || ownParameterContext.inheritsFrom(parameterContext.getIdentifier());
    }

    public void setDefaultFlowFileExpiration(String defaultFlowFileExpiration) {
        if (StringUtils.isBlank((CharSequence)defaultFlowFileExpiration)) {
            this.defaultFlowFileExpiration.set(DEFAULT_FLOWFILE_EXPIRATION);
        } else {
            String caseAdjustedExpiration;
            Pattern pattern = Pattern.compile(FormatUtils.TIME_DURATION_REGEX);
            if (pattern.matcher(caseAdjustedExpiration = defaultFlowFileExpiration.toLowerCase()).matches()) {
                this.defaultFlowFileExpiration.set(caseAdjustedExpiration);
            } else {
                throw new IllegalArgumentException("The Default FlowFile Expiration of the process group must contain a valid time unit.");
            }
        }
    }

    public String getDefaultFlowFileExpiration() {
        if (this.defaultFlowFileExpiration.get() == null) {
            if (this.isRootGroup()) {
                return DEFAULT_FLOWFILE_EXPIRATION;
            }
            return this.parent.get().getDefaultFlowFileExpiration();
        }
        return this.defaultFlowFileExpiration.get();
    }

    public void setDefaultBackPressureObjectThreshold(Long defaultBackPressureObjectThreshold) {
        if (defaultBackPressureObjectThreshold == null) {
            this.defaultBackPressureObjectThreshold.set(this.nifiPropertiesBackpressureCount);
        } else {
            this.defaultBackPressureObjectThreshold.set(defaultBackPressureObjectThreshold);
        }
    }

    public Long getDefaultBackPressureObjectThreshold() {
        if (this.defaultBackPressureObjectThreshold.get() == null) {
            if (this.isRootGroup()) {
                return this.nifiPropertiesBackpressureCount;
            }
            return this.getParent().getDefaultBackPressureObjectThreshold();
        }
        return this.defaultBackPressureObjectThreshold.get();
    }

    public void setDefaultBackPressureDataSizeThreshold(String defaultBackPressureDataSizeThreshold) {
        if (StringUtils.isBlank((CharSequence)defaultBackPressureDataSizeThreshold)) {
            this.defaultBackPressureDataSizeThreshold.set(this.nifiPropertiesBackpressureSize);
        } else {
            DataUnit.parseDataSize((String)defaultBackPressureDataSizeThreshold, (DataUnit)DataUnit.B);
            this.defaultBackPressureDataSizeThreshold.set(defaultBackPressureDataSizeThreshold.toUpperCase());
        }
    }

    public QueueSize getQueueSize() {
        QueueSize queueSize;
        int count = 0;
        long contentSize = 0L;
        for (ProcessGroup childGroup : this.processGroups.values()) {
            queueSize = childGroup.getQueueSize();
            count += queueSize.getObjectCount();
            contentSize += queueSize.getByteCount();
        }
        for (Connection connection : this.connections.values()) {
            queueSize = connection.getFlowFileQueue().size();
            count += queueSize.getObjectCount();
            contentSize += queueSize.getByteCount();
        }
        return new QueueSize(count, contentSize);
    }

    public String getLogFileSuffix() {
        return this.logFileSuffix;
    }

    public void setLogFileSuffix(String logFileSuffix) {
        if (logFileSuffix != null && INVALID_DIRECTORY_NAME_CHARACTERS.matcher(logFileSuffix).find()) {
            throw new IllegalArgumentException("Log file suffix can not contain the following characters: space, <, >, :, ', \", /, \\, |, ?, *");
        }
        this.logFileSuffix = logFileSuffix;
    }

    public ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public void setExecutionEngine(ExecutionEngine executionEngine) {
        this.writeLock.lock();
        try {
            this.verifyCanSetExecutionEngine(executionEngine);
            this.executionEngine = executionEngine;
            this.findAllProcessors().forEach(AbstractComponentNode::resetValidationState);
            this.findAllControllerServices().forEach(ComponentNode::resetValidationState);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Optional<StatelessGroupNode> getStatelessGroupNode() {
        return Optional.ofNullable(this.statelessGroupNode);
    }

    public ExecutionEngine resolveExecutionEngine() {
        ExecutionEngine engine = this.getExecutionEngine();
        if (engine == ExecutionEngine.INHERITED) {
            ProcessGroup parent = this.getParent();
            return parent == null ? ExecutionEngine.STANDARD : parent.resolveExecutionEngine();
        }
        return engine;
    }

    private ProcessGroup getStatelessGroup(ProcessGroup start) {
        if (start == null) {
            return null;
        }
        ExecutionEngine engine = start.getExecutionEngine();
        if (engine == ExecutionEngine.STATELESS) {
            return start;
        }
        return this.getStatelessGroup(start.getParent());
    }

    public void verifyCanSetExecutionEngine(ExecutionEngine executionEngine) {
        ProcessGroup statelessGroup;
        ProcessGroup parent;
        ExecutionEngine resolvedProposedEngine = Objects.requireNonNull(executionEngine) == ExecutionEngine.INHERITED ? ((parent = this.getParent()) == null ? ExecutionEngine.STANDARD : parent.resolveExecutionEngine()) : executionEngine;
        if (resolvedProposedEngine == this.resolveExecutionEngine()) {
            LOG.debug("Allowing the setting of Execution Engine to {} because it resolves to the same engine that is currently selected for {}", (Object)executionEngine, (Object)this);
            return;
        }
        if (executionEngine == ExecutionEngine.STANDARD && (statelessGroup = this.getStatelessGroup(this.getParent())) != null) {
            throw new IllegalStateException("A Process Group using the Standard Engine may not be the child of a Process Group using the Stateless Engine. Cannot set Execution Engine of " + String.valueOf(this) + " to Standard because it is a child of " + String.valueOf(statelessGroup));
        }
        if (resolvedProposedEngine == ExecutionEngine.STATELESS) {
            for (ProcessGroup descendant : this.findAllProcessGroups()) {
                ExecutionEngine descendantEngine = descendant.getExecutionEngine();
                if (descendantEngine != ExecutionEngine.STANDARD) continue;
                throw new IllegalStateException("A Process Group using the Stateless Engine may not have a child Process Group using the Standard Engine. Cannot set Execution Engine of " + String.valueOf(this) + " to Stateless because it has a child Process Group " + String.valueOf(descendant) + " using the Standard Engine");
            }
        }
        this.verifyCanUpdateExecutionEngine();
    }

    public void verifyCanUpdateExecutionEngine() {
        for (ProcessorNode processor : this.getProcessors()) {
            if (!processor.isRunning()) continue;
            throw new IllegalStateException("Cannot change Execution Engine for " + String.valueOf(this) + " while components are running. " + String.valueOf(processor) + " is currently running.");
        }
        for (Port port : this.getInputPorts()) {
            if (!port.isRunning()) continue;
            throw new IllegalStateException("Cannot change Execution Engine for " + String.valueOf(this) + " while components are running. Input Port " + String.valueOf(port) + " is currently running.");
        }
        for (Port port : this.getOutputPorts()) {
            if (!port.isRunning()) continue;
            throw new IllegalStateException("Cannot change Execution Engine for " + String.valueOf(this) + " while components are running. Output Port " + String.valueOf(port) + " is currently running.");
        }
        for (RemoteProcessGroup rpg : this.getRemoteProcessGroups()) {
            if (!rpg.isTransmitting()) continue;
            throw new IllegalStateException("Cannot change Execution Engine for " + String.valueOf(this) + " while components are running. " + String.valueOf(rpg) + " is currently running.");
        }
        for (ControllerServiceNode service : this.getControllerServices(false)) {
            if (!service.isActive()) continue;
            throw new IllegalStateException("Cannot change Execution Engine for " + String.valueOf(this) + " while Controller Services are active. " + String.valueOf(service) + " is currently active.");
        }
        for (Connection connection : this.getConnections()) {
            boolean queueEmpty = connection.getFlowFileQueue().isEmpty();
            if (queueEmpty) continue;
            throw new IllegalStateException("Cannot change Execution Engine for " + String.valueOf(this) + " while data is queued. " + String.valueOf(connection) + " has data queued.");
        }
        for (ProcessGroup child : this.getProcessGroups()) {
            if (child.getExecutionEngine() != ExecutionEngine.INHERITED) continue;
            child.verifyCanUpdateExecutionEngine();
        }
    }

    public void setMaxConcurrentTasks(int maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
        if (this.statelessGroupNode != null) {
            this.statelessGroupNode.setMaxConcurrentTasks(maxConcurrentTasks);
        }
    }

    public int getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public String getDefaultBackPressureDataSizeThreshold() {
        if (StringUtils.isEmpty((CharSequence)this.defaultBackPressureDataSizeThreshold.get())) {
            if (this.isRootGroup()) {
                return this.nifiPropertiesBackpressureSize;
            }
            return this.parent.get().getDefaultBackPressureDataSizeThreshold();
        }
        return this.defaultBackPressureDataSizeThreshold.get();
    }

    public String getStatelessFlowTimeout() {
        return this.statelessFlowTimeout;
    }

    public void setStatelessFlowTimeout(String statelessFlowTimeout) {
        if (statelessFlowTimeout == null) {
            return;
        }
        try {
            FormatUtils.getPreciseTimeDuration((String)Objects.requireNonNull(statelessFlowTimeout), (TimeUnit)TimeUnit.MILLISECONDS);
            this.statelessFlowTimeout = statelessFlowTimeout;
        }
        catch (Exception e) {
            LOG.warn("Attempted to set Stateless Flow Timeout for {} to invalid value: {}; ignoring this value", (Object)this, (Object)statelessFlowTimeout);
        }
    }

    private static class InputPortRetriever
    implements PortRetriever {
        private InputPortRetriever() {
        }

        @Override
        public Set<Port> getPorts(ProcessGroup group) {
            return group.getInputPorts();
        }

        @Override
        public Port getPort(ProcessGroup group, String id) {
            return group.getInputPort(id);
        }
    }

    private static interface PortRetriever {
        public Port getPort(ProcessGroup var1, String var2);

        public Set<Port> getPorts(ProcessGroup var1);
    }

    private static class OutputPortRetriever
    implements PortRetriever {
        private OutputPortRetriever() {
        }

        @Override
        public Set<Port> getPorts(ProcessGroup group) {
            return group.getOutputPorts();
        }

        @Override
        public Port getPort(ProcessGroup group, String id) {
            return group.getOutputPort(id);
        }
    }
}

