/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.controller.state.ConfigParseException;
import org.apache.nifi.controller.state.config.StateProviderConfiguration;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StateManagerConfiguration {
    private final Map<String, StateProviderConfiguration> providers;

    private StateManagerConfiguration(Map<String, StateProviderConfiguration> providerConfigs) {
        this.providers = providerConfigs;
    }

    public Map<String, StateProviderConfiguration> getStateProviderConfigurations() {
        return Collections.unmodifiableMap(this.providers);
    }

    public StateProviderConfiguration getStateProviderConfiguration(String providerId) {
        return this.providers.get(providerId);
    }

    public List<StateProviderConfiguration> getStateProviderConfigurations(Scope scope) {
        ArrayList<StateProviderConfiguration> configs = new ArrayList<StateProviderConfiguration>();
        for (StateProviderConfiguration config : this.providers.values()) {
            if (config.getScope() != scope) continue;
            configs.add(config);
        }
        return configs;
    }

    public static StateManagerConfiguration parse(File configFile) throws IOException, ConfigParseException {
        Document document;
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            document = documentProvider.parse((InputStream)inputStream);
        }
        catch (ProcessingException e) {
            throw new ConfigParseException("Unable to parse file " + String.valueOf(configFile) + ", as it does not appear to be a valid XML File", e);
        }
        Element rootElement = document.getDocumentElement();
        List localProviderElements = DomUtils.getChildElementsByTagName((Element)rootElement, (String)"local-provider");
        if (localProviderElements.isEmpty()) {
            throw new ConfigParseException("State Management config file " + String.valueOf(configFile) + " is not a valid configuration file, as it does not contain a 'local-provider' element, or the local-provider element is not the child of the root element");
        }
        HashMap<String, StateProviderConfiguration> configs = new HashMap<String, StateProviderConfiguration>();
        for (Element localProviderElement : localProviderElements) {
            StateProviderConfiguration providerConfig = StateManagerConfiguration.parseProviderConfiguration(localProviderElement, Scope.LOCAL, configFile);
            if (configs.containsKey(providerConfig.getId())) {
                throw new ConfigParseException("State Management config file " + String.valueOf(configFile) + " is not a valid configuration file, as it contains multiple providers with the \"id\" of \"" + providerConfig.getId() + "\"");
            }
            configs.put(providerConfig.getId(), providerConfig);
        }
        List clusterProviderElements = DomUtils.getChildElementsByTagName((Element)rootElement, (String)"cluster-provider");
        for (Element clusterProviderElement : clusterProviderElements) {
            StateProviderConfiguration providerConfig = StateManagerConfiguration.parseProviderConfiguration(clusterProviderElement, Scope.CLUSTER, configFile);
            if (configs.containsKey(providerConfig.getId())) {
                throw new ConfigParseException("State Management config file " + String.valueOf(configFile) + " is not a valid configuration file, as it contains multiple providers with the \"id\" of \"" + providerConfig.getId() + "\"");
            }
            configs.put(providerConfig.getId(), providerConfig);
        }
        return new StateManagerConfiguration(configs);
    }

    private static StateProviderConfiguration parseProviderConfiguration(Element providerElement, Scope scope, File configFile) throws ConfigParseException {
        String elementName = providerElement.getNodeName();
        String id = DomUtils.getChildText((Element)providerElement, (String)"id");
        if (id == null) {
            throw new ConfigParseException("State Management config file " + String.valueOf(configFile) + " is not a valid configuration file, as a " + elementName + " element does not contain an \"id\" element");
        }
        if (id.trim().isEmpty()) {
            throw new ConfigParseException("State Management config file " + String.valueOf(configFile) + " is not a valid configuration file, as a " + elementName + "'s \"id\" element is empty");
        }
        String className = DomUtils.getChildText((Element)providerElement, (String)"class");
        if (className == null) {
            throw new ConfigParseException("State Management config file " + String.valueOf(configFile) + " is not a valid configuration file, as a " + elementName + " element does not contain an \"class\" element");
        }
        if (className.trim().isEmpty()) {
            throw new ConfigParseException("State Management config file " + String.valueOf(configFile) + " is not a valid configuration file, as a " + elementName + "'s \"class\" element is empty");
        }
        List propertyElements = DomUtils.getChildElementsByTagName((Element)providerElement, (String)"property");
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Element propertyElement : propertyElements) {
            String propertyName = propertyElement.getAttribute("name");
            String propertyValue = propertyElement.getTextContent();
            propertyMap.put(propertyName, propertyValue);
        }
        return new StateProviderConfiguration(id, className, scope, propertyMap);
    }
}

