/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.configuration;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.cluster.ClusterDetailsFactory;
import org.apache.nifi.cluster.StandardClusterDetailsFactory;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestCompletionCallback;
import org.apache.nifi.cluster.coordination.http.replication.StandardUploadRequestReplicator;
import org.apache.nifi.cluster.coordination.http.replication.ThreadPoolRequestReplicator;
import org.apache.nifi.cluster.coordination.http.replication.UploadRequestReplicator;
import org.apache.nifi.cluster.coordination.http.replication.client.StandardHttpReplicationClient;
import org.apache.nifi.cluster.lifecycle.ClusterDecommissionTask;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.client.StandardHttpUriBuilder;
import org.apache.nifi.web.client.api.WebClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FrameworkClusterConfiguration {
    private NiFiProperties properties;
    private EventReporter eventReporter;
    private FlowController flowController;
    private ClusterCoordinator clusterCoordinator;
    private WebClientService webClientService;

    @Autowired
    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    @Autowired
    public void setEventReporter(EventReporter eventReporter) {
        this.eventReporter = eventReporter;
    }

    @Autowired(required=false)
    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    @Autowired
    public void setWebClientService(WebClientService webClientService) {
        this.webClientService = webClientService;
    }

    @Bean
    public ThreadPoolRequestReplicator requestReplicator(@Autowired(required=false) SSLContext sslContext, @Autowired(required=false) X509TrustManager trustManager) {
        ThreadPoolRequestReplicator replicator;
        if (this.clusterCoordinator == null) {
            replicator = null;
        } else {
            StandardHttpReplicationClient replicationClient = new StandardHttpReplicationClient(this.webClientService, StandardHttpUriBuilder::new);
            replicator = new ThreadPoolRequestReplicator(this.properties.getClusterNodeProtocolMaxPoolSize(), this.properties.getClusterNodeMaxConcurrentRequests(), replicationClient, this.clusterCoordinator, (RequestCompletionCallback)this.clusterCoordinator, this.eventReporter, this.properties);
        }
        return replicator;
    }

    @Bean
    public ClusterDecommissionTask decommissionTask() {
        return new ClusterDecommissionTask(this.clusterCoordinator, this.flowController);
    }

    @Bean
    public ClusterDetailsFactory clusterDetailsFactory() {
        return new StandardClusterDetailsFactory(this.clusterCoordinator);
    }

    @Bean
    public UploadRequestReplicator uploadRequestReplicator() throws IOException {
        if (this.clusterCoordinator == null) {
            return null;
        }
        return new StandardUploadRequestReplicator(this.clusterCoordinator, this.webClientService, this.properties);
    }
}

