/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.parameter.ParameterSensitivity;
import org.apache.nifi.web.api.entity.ParameterGroupConfigurationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;

public class ParameterProviderMerger {
    public static void merge(ParameterProviderEntity target, ParameterProviderEntity otherEntity) {
        if (target == null || otherEntity == null) {
            return;
        }
        if (target.getPermissions() != null && otherEntity.getPermissions() != null) {
            PermissionsDtoMerger.mergePermissions(target.getPermissions(), otherEntity.getPermissions());
        }
        if (!Boolean.TRUE.equals(target.getPermissions() != null ? target.getPermissions().getCanRead() : Boolean.TRUE) || target.getComponent() == null || otherEntity.getComponent() == null) {
            target.setComponent(null);
            return;
        }
        Collection targetParameterGroupConfigurations = target.getComponent().getParameterGroupConfigurations();
        Collection otherParameterGroupConfigurations = otherEntity.getComponent().getParameterGroupConfigurations();
        if (targetParameterGroupConfigurations == null || otherParameterGroupConfigurations == null) {
            return;
        }
        Iterator otherGroupIterator = otherParameterGroupConfigurations.iterator();
        for (ParameterGroupConfigurationEntity parameterGroupConfiguration : targetParameterGroupConfigurations) {
            if (!otherGroupIterator.hasNext()) continue;
            ParameterGroupConfigurationEntity otherConfiguration = (ParameterGroupConfigurationEntity)otherGroupIterator.next();
            if (!Strings.CS.equals(parameterGroupConfiguration.getGroupName(), otherConfiguration.getGroupName())) continue;
            Map targetParameterSensitivities = parameterGroupConfiguration.getParameterSensitivities();
            Map otherParameterSensitivities = otherConfiguration.getParameterSensitivities();
            if (targetParameterSensitivities == null || otherParameterSensitivities == null) continue;
            targetParameterSensitivities.keySet().retainAll(otherParameterSensitivities.keySet());
            parameterGroupConfiguration.setParameterSensitivities(new LinkedHashMap());
            targetParameterSensitivities.keySet().stream().sorted().forEach(paramName -> parameterGroupConfiguration.getParameterSensitivities().put(paramName, (ParameterSensitivity)targetParameterSensitivities.get(paramName)));
        }
    }
}

