/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.AnalyzeFlowRequestDTO;
import org.apache.nifi.web.api.entity.AnalyzeFlowRequestEntity;

public class AnalyzeFlowRequestEndpointMerger
extends AbstractSingleDTOEndpoint<AnalyzeFlowRequestEntity, AnalyzeFlowRequestDTO> {
    public static final Pattern ANALYZE_FLOW_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/flow-analysis/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        return ("POST".equalsIgnoreCase(method) || "GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) && ANALYZE_FLOW_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<AnalyzeFlowRequestEntity> getEntityClass() {
        return AnalyzeFlowRequestEntity.class;
    }

    @Override
    protected AnalyzeFlowRequestDTO getDto(AnalyzeFlowRequestEntity entity) {
        AnalyzeFlowRequestDTO dto = entity.getAnalyzeFlowRequest();
        return dto;
    }

    @Override
    protected void mergeResponses(AnalyzeFlowRequestDTO clientDto, Map<NodeIdentifier, AnalyzeFlowRequestDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        HashSet<String> failureReasons = new HashSet<String>();
        if (clientDto.getFailureReason() != null) {
            failureReasons.add(clientDto.getFailureReason());
        }
        for (AnalyzeFlowRequestDTO requestDto : dtoMap.values()) {
            if (!requestDto.isComplete()) {
                clientDto.setComplete(false);
            }
            if (requestDto.getFailureReason() != null) {
                failureReasons.add(requestDto.getFailureReason());
            }
            if (requestDto.getLastUpdated() != null && (clientDto.getLastUpdated() == null || requestDto.getLastUpdated().after(clientDto.getLastUpdated()))) {
                clientDto.setLastUpdated(requestDto.getLastUpdated());
            }
            if (requestDto.getPercentCompleted() >= clientDto.getPercentCompleted()) continue;
            clientDto.setPercentCompleted(requestDto.getPercentCompleted());
            clientDto.setState(requestDto.getState());
        }
        String failureReason = failureReasons.stream().filter(Objects::nonNull).collect(Collectors.joining("\n"));
        if (!failureReason.isEmpty()) {
            clientDto.setFailureReason(failureReason);
        }
    }
}

