/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.ProcessorsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;

public class ProcessorsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern PROCESSORS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/processors");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PROCESSORS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        ProcessorsEntity responseEntity = (ProcessorsEntity)clientResponse.getClientResponse().readEntity(ProcessorsEntity.class);
        Set processorEntities = responseEntity.getProcessors();
        HashMap<String, Map<NodeIdentifier, ProcessorEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, ProcessorEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            ProcessorsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ProcessorsEntity)nodeResponse.getClientResponse().readEntity(ProcessorsEntity.class);
            Set nodeProcessorEntities = nodeResponseEntity.getProcessors();
            for (ProcessorEntity nodeProcessorEntity : nodeProcessorEntities) {
                Map innerMap = entityMap.computeIfAbsent(nodeProcessorEntity.getId(), k -> new HashMap());
                innerMap.put(nodeResponse.getNodeId(), nodeProcessorEntity);
            }
        }
        ProcessorsEntityMerger.mergeProcessors(processorEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

