/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.ConnectionsEntityMerger;
import org.apache.nifi.cluster.manager.FunnelsEntityMerger;
import org.apache.nifi.cluster.manager.LabelsEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PortsEntityMerger;
import org.apache.nifi.cluster.manager.ProcessGroupsEntityMerger;
import org.apache.nifi.cluster.manager.ProcessorsEntityMerger;
import org.apache.nifi.cluster.manager.RemoteProcessGroupsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.PasteResponseEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;

public class PasteEndpointMerger
extends AbstractSingleDTOEndpoint<PasteResponseEntity, FlowDTO> {
    public static final Pattern PASTE_INSTANCE_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/paste");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "PUT".equalsIgnoreCase(method) && PASTE_INSTANCE_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<PasteResponseEntity> getEntityClass() {
        return PasteResponseEntity.class;
    }

    @Override
    protected FlowDTO getDto(PasteResponseEntity entity) {
        return entity.getFlow();
    }

    @Override
    protected void mergeResponses(FlowDTO clientDto, Map<NodeIdentifier, FlowDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        Set clientConnections = clientDto.getConnections();
        Set clientProcessors = clientDto.getProcessors();
        Set clientInputPorts = clientDto.getInputPorts();
        Set clientOutputPorts = clientDto.getOutputPorts();
        Set clientRemoteProcessGroups = clientDto.getRemoteProcessGroups();
        Set clientProcessGroups = clientDto.getProcessGroups();
        Set clientLabels = clientDto.getLabels();
        Set clientFunnels = clientDto.getFunnels();
        HashMap<String, Map<NodeIdentifier, ConnectionEntity>> connections = new HashMap<String, Map<NodeIdentifier, ConnectionEntity>>();
        HashMap<String, Map<NodeIdentifier, FunnelEntity>> funnels = new HashMap<String, Map<NodeIdentifier, FunnelEntity>>();
        HashMap<String, Map<NodeIdentifier, PortEntity>> inputPorts = new HashMap<String, Map<NodeIdentifier, PortEntity>>();
        HashMap<String, Map<NodeIdentifier, LabelEntity>> labels = new HashMap<String, Map<NodeIdentifier, LabelEntity>>();
        HashMap<String, Map<NodeIdentifier, PortEntity>> outputPorts = new HashMap<String, Map<NodeIdentifier, PortEntity>>();
        HashMap<String, Map<NodeIdentifier, ProcessorEntity>> processors = new HashMap<String, Map<NodeIdentifier, ProcessorEntity>>();
        HashMap<String, Map<NodeIdentifier, RemoteProcessGroupEntity>> rpgs = new HashMap<String, Map<NodeIdentifier, RemoteProcessGroupEntity>>();
        HashMap<String, Map<NodeIdentifier, ProcessGroupEntity>> processGroups = new HashMap<String, Map<NodeIdentifier, ProcessGroupEntity>>();
        for (Map.Entry<NodeIdentifier, FlowDTO> nodeFlowEntry : dtoMap.entrySet()) {
            NodeIdentifier nodeIdentifier = nodeFlowEntry.getKey();
            FlowDTO nodeFlowDto = nodeFlowEntry.getValue();
            for (ConnectionEntity entity : nodeFlowDto.getConnections()) {
                connections.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, nodeId -> entity);
            }
            for (ConnectionEntity entity : nodeFlowDto.getFunnels()) {
                funnels.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> PasteEndpointMerger.lambda$mergeResponses$3((FunnelEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getInputPorts()) {
                inputPorts.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> PasteEndpointMerger.lambda$mergeResponses$5((PortEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getOutputPorts()) {
                outputPorts.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> PasteEndpointMerger.lambda$mergeResponses$7((PortEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getLabels()) {
                labels.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> PasteEndpointMerger.lambda$mergeResponses$9((LabelEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getProcessors()) {
                processors.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> PasteEndpointMerger.lambda$mergeResponses$11((ProcessorEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getRemoteProcessGroups()) {
                rpgs.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> PasteEndpointMerger.lambda$mergeResponses$13((RemoteProcessGroupEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getProcessGroups()) {
                processGroups.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> PasteEndpointMerger.lambda$mergeResponses$15((ProcessGroupEntity)entity, arg_0));
            }
        }
        ConnectionsEntityMerger.mergeConnections(clientConnections, connections);
        FunnelsEntityMerger.mergeFunnels(clientFunnels, funnels);
        PortsEntityMerger.mergePorts(clientInputPorts, inputPorts);
        PortsEntityMerger.mergePorts(clientOutputPorts, outputPorts);
        LabelsEntityMerger.mergeLabels(clientLabels, labels);
        ProcessorsEntityMerger.mergeProcessors(clientProcessors, processors);
        RemoteProcessGroupsEntityMerger.mergeRemoteProcessGroups(clientRemoteProcessGroups, rpgs);
        ProcessGroupsEntityMerger.mergeProcessGroups(clientProcessGroups, processGroups);
    }

    private static /* synthetic */ ProcessGroupEntity lambda$mergeResponses$15(ProcessGroupEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ RemoteProcessGroupEntity lambda$mergeResponses$13(RemoteProcessGroupEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ ProcessorEntity lambda$mergeResponses$11(ProcessorEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ LabelEntity lambda$mergeResponses$9(LabelEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ PortEntity lambda$mergeResponses$7(PortEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ PortEntity lambda$mergeResponses$5(PortEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ FunnelEntity lambda$mergeResponses$3(FunnelEntity entity, NodeIdentifier nodeId) {
        return entity;
    }
}

