/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;

public class AccessPolicyEntityMerger
implements ComponentEntityMerger<AccessPolicyEntity> {
    @Override
    public void merge(AccessPolicyEntity clientEntity, Map<NodeIdentifier, AccessPolicyEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
    }

    @Override
    public void mergeComponents(AccessPolicyEntity clientEntity, Map<NodeIdentifier, AccessPolicyEntity> entityMap) {
        AccessPolicyDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, AccessPolicyDTO> dtoMap = new HashMap<NodeIdentifier, AccessPolicyDTO>();
        for (Map.Entry<NodeIdentifier, AccessPolicyEntity> entry : entityMap.entrySet()) {
            AccessPolicyEntity nodeAccessPolicyEntity = entry.getValue();
            AccessPolicyDTO nodeAccessPolicyDto = nodeAccessPolicyEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeAccessPolicyDto);
        }
        AccessPolicyEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    private static void mergeDtos(AccessPolicyDTO clientDto, Map<NodeIdentifier, AccessPolicyDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashSet users = new HashSet(clientDto.getUsers());
        HashSet userGroups = new HashSet(clientDto.getUserGroups());
        for (Map.Entry<NodeIdentifier, AccessPolicyDTO> nodeEntry : dtoMap.entrySet()) {
            AccessPolicyDTO nodeAccessPolicy = nodeEntry.getValue();
            if (nodeAccessPolicy == null) continue;
            users.retainAll(nodeAccessPolicy.getUsers());
            userGroups.retainAll(nodeAccessPolicy.getUserGroups());
        }
        clientDto.setUsers(users);
        clientDto.setUserGroups(userGroups);
    }
}

