/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.manager.AllowableValueEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.AllowableValueDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.entity.AllowableValueEntity;

public class PropertyDescriptorDtoMerger {
    public static void merge(PropertyDescriptorDTO clientPropertyDescriptor, Map<NodeIdentifier, PropertyDescriptorDTO> dtoMap) {
        if (clientPropertyDescriptor.getAllowableValues() != null) {
            LinkedHashMap<AllowableValueDTO, List<AllowableValueEntity>> allowableValueDtoToEntities = new LinkedHashMap<AllowableValueDTO, List<AllowableValueEntity>>();
            PropertyDescriptorDtoMerger.addEntities(clientPropertyDescriptor, allowableValueDtoToEntities);
            dtoMap.values().forEach(propertyDescriptorDTO -> PropertyDescriptorDtoMerger.addEntities(propertyDescriptorDTO, allowableValueDtoToEntities));
            List mergedAllowableValues = allowableValueDtoToEntities.values().stream().filter(entities -> Integer.valueOf(entities.size()).equals(dtoMap.size() + 1)).map(AllowableValueEntityMerger::merge).collect(Collectors.toList());
            clientPropertyDescriptor.setAllowableValues(mergedAllowableValues);
        }
    }

    private static void addEntities(PropertyDescriptorDTO propertyDescriptorDTO, Map<AllowableValueDTO, List<AllowableValueEntity>> dtoToEntities) {
        propertyDescriptorDTO.getAllowableValues().forEach(allowableValueEntity -> dtoToEntities.computeIfAbsent(allowableValueEntity.getAllowableValue(), __ -> new ArrayList()).add(allowableValueEntity));
    }
}

