/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.provenance.LatestProvenanceEventsDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.LatestProvenanceEventsEntity;

public class LatestProvenanceEventsMerger
implements EndpointResponseMerger {
    public static final Pattern LATEST_EVENTS_URI = Pattern.compile("/nifi-api/provenance-events/latest/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && LATEST_EVENTS_URI.matcher(uri.getPath()).matches();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        LatestProvenanceEventsEntity responseEntity = (LatestProvenanceEventsEntity)clientResponse.getClientResponse().readEntity(LatestProvenanceEventsEntity.class);
        LatestProvenanceEventsDTO dto = responseEntity.getLatestProvenanceEvents();
        ArrayList mergedEvents = new ArrayList();
        for (NodeResponse nodeResponse : successfulResponses) {
            NodeIdentifier nodeId = nodeResponse.getNodeId();
            LatestProvenanceEventsEntity nodeResponseEntity = (LatestProvenanceEventsEntity)nodeResponse.getClientResponse().readEntity(LatestProvenanceEventsEntity.class);
            List nodeEvents = nodeResponseEntity.getLatestProvenanceEvents().getProvenanceEvents();
            for (ProvenanceEventDTO eventDto : nodeEvents) {
                if (eventDto.getClusterNodeId() != null && eventDto.getClusterNodeAddress() != null) continue;
                eventDto.setClusterNodeId(nodeId.getId());
                eventDto.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
            }
            mergedEvents.addAll(nodeEvents);
        }
        dto.setProvenanceEvents(mergedEvents);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

