/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.FlowAnalysisRulesEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRulesEntity;

public class FlowAnalysisRulesEndpointMerger
implements EndpointResponseMerger {
    public static final String FLOW_ANALYSIS_RULES_URI = "/nifi-api/controller/flow-analysis-rules";

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && FLOW_ANALYSIS_RULES_URI.equals(uri.getPath());
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        FlowAnalysisRulesEntity responseEntity = (FlowAnalysisRulesEntity)clientResponse.getClientResponse().readEntity(FlowAnalysisRulesEntity.class);
        Set flowAnalysisRulesEntities = responseEntity.getFlowAnalysisRules();
        HashMap<String, Map<NodeIdentifier, FlowAnalysisRuleEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, FlowAnalysisRuleEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            FlowAnalysisRulesEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (FlowAnalysisRulesEntity)nodeResponse.getClientResponse().readEntity(FlowAnalysisRulesEntity.class);
            Set nodeFlowAnalysisRuleEntities = nodeResponseEntity.getFlowAnalysisRules();
            for (FlowAnalysisRuleEntity nodeFlowAnalysisRuleEntity : nodeFlowAnalysisRuleEntities) {
                NodeIdentifier nodeId = nodeResponse.getNodeId();
                HashMap<NodeIdentifier, FlowAnalysisRuleEntity> innerMap = (HashMap<NodeIdentifier, FlowAnalysisRuleEntity>)entityMap.get(nodeId);
                if (innerMap == null) {
                    innerMap = new HashMap<NodeIdentifier, FlowAnalysisRuleEntity>();
                    entityMap.put(nodeFlowAnalysisRuleEntity.getId(), innerMap);
                }
                innerMap.put(nodeResponse.getNodeId(), nodeFlowAnalysisRuleEntity);
            }
        }
        FlowAnalysisRulesEntityMerger.mergeFlowAnalysisRules(flowAnalysisRulesEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

