/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import org.apache.nifi.web.Revision;

public class ComponentRevision {
    private Long version;
    private String clientId;
    private String componentId;

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public Revision toRevision() {
        return new Revision(this.getVersion(), this.getClientId(), this.getComponentId());
    }

    public static ComponentRevision fromRevision(Revision revision) {
        ComponentRevision componentRevision = new ComponentRevision();
        componentRevision.setVersion(revision.getVersion());
        componentRevision.setClientId(revision.getClientId());
        componentRevision.setComponentId(revision.getComponentId());
        return componentRevision;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ComponentRevision)) {
            return false;
        }
        ComponentRevision thatRevision = (ComponentRevision)obj;
        if (thatRevision.getComponentId() == null && this.getComponentId() != null) {
            return false;
        }
        if (thatRevision.getComponentId() != null && this.getComponentId() == null) {
            return false;
        }
        if (thatRevision.getComponentId() != null && !thatRevision.getComponentId().equals(this.getComponentId())) {
            return false;
        }
        if (this.version != null && this.version.equals(thatRevision.version)) {
            return true;
        }
        return this.clientId != null && !this.clientId.isBlank() && this.clientId.equals(thatRevision.getClientId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.componentId != null ? this.componentId.hashCode() : 0);
        hash = 59 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 59 * hash + (this.clientId != null ? this.clientId.hashCode() : 0);
        return hash;
    }
}

