/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

public class AuthorizationResult {
    private static final AuthorizationResult APPROVED = new AuthorizationResult(Result.Approved, null);
    private static final AuthorizationResult RESOURCE_NOT_FOUND = new AuthorizationResult(Result.ResourceNotFound, null);
    private final Result result;
    private final String explanation;

    private AuthorizationResult(Result result, String explanation) {
        if (Result.Denied.equals((Object)result) && explanation == null) {
            throw new IllegalArgumentException("An explanation is required when the authorization request is denied.");
        }
        this.result = result;
        this.explanation = explanation;
    }

    public Result getResult() {
        return this.result;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public static AuthorizationResult approved() {
        return APPROVED;
    }

    public static AuthorizationResult resourceNotFound() {
        return RESOURCE_NOT_FOUND;
    }

    public static AuthorizationResult denied() {
        return AuthorizationResult.denied("Access is denied");
    }

    public static AuthorizationResult denied(String explanation) {
        return new AuthorizationResult(Result.Denied, explanation);
    }

    public static enum Result {
        Approved,
        Denied,
        ResourceNotFound;

    }
}

