/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.nifi.util.FlowFilePackager;

public class FlowFilePackagerV1
implements FlowFilePackager {
    public static final String FILENAME_ATTRIBUTES = "flowfile.attributes";
    public static final String FILENAME_CONTENT = "flowfile.content";
    public static final int DEFAULT_TAR_PERMISSIONS = 420;
    private final int tarPermissions;

    public FlowFilePackagerV1() {
        this(420);
    }

    public FlowFilePackagerV1(int tarPermissions) {
        this.tarPermissions = tarPermissions;
    }

    @Override
    public void packageFlowFile(InputStream in, OutputStream out, Map<String, String> attributes, long fileSize) throws IOException {
        try (TarArchiveOutputStream tout = new TarArchiveOutputStream(out);){
            this.writeAttributesEntry(attributes, tout);
            this.writeContentEntry(tout, in, fileSize);
            tout.finish();
            tout.flush();
            tout.close();
        }
    }

    private void writeAttributesEntry(Map<String, String> attributes, TarArchiveOutputStream tout) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE properties\n  SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n");
        sb.append("<properties>");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String escapedKey = StringEscapeUtils.escapeXml11((String)entry.getKey());
            String escapedValue = StringEscapeUtils.escapeXml11((String)entry.getValue());
            sb.append("\n  <entry key=\"").append(escapedKey).append("\">").append(escapedValue).append("</entry>");
        }
        sb.append("</properties>");
        byte[] metaBytes = sb.toString().getBytes(StandardCharsets.UTF_8);
        TarArchiveEntry attribEntry = new TarArchiveEntry(FILENAME_ATTRIBUTES);
        attribEntry.setMode(this.tarPermissions);
        attribEntry.setSize((long)metaBytes.length);
        tout.putArchiveEntry(attribEntry);
        tout.write(metaBytes);
        tout.closeArchiveEntry();
    }

    private void writeContentEntry(TarArchiveOutputStream tarOut, InputStream inStream, long fileSize) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(FILENAME_CONTENT);
        entry.setMode(this.tarPermissions);
        entry.setSize(fileSize);
        tarOut.putArchiveEntry(entry);
        byte[] buffer = new byte[524288];
        int bytesRead = 0;
        while ((bytesRead = inStream.read(buffer)) != -1) {
            if (bytesRead <= 0) continue;
            tarOut.write(buffer, 0, bytesRead);
        }
        FlowFilePackagerV1.copy(inStream, (OutputStream)tarOut);
        tarOut.closeArchiveEntry();
    }

    public static long copy(InputStream source, OutputStream destination) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        long totalCount = 0L;
        while ((len = source.read(buffer)) > 0) {
            destination.write(buffer, 0, len);
            totalCount += (long)len;
        }
        return totalCount;
    }
}

