/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.apache.nifi.util.FlowFileUnpackager;
import org.apache.nifi.util.FlowFileUnpackagerV1;
import org.apache.nifi.util.FlowFileUnpackagerV2;
import org.apache.nifi.util.FlowFileUnpackagerV3;

public class Unpackage {
    private static void printUsage() {
        System.out.println("java " + Unpackage.class.getCanonicalName() + " <version> <input file 1> [<input file 2> <input file 3> ... <input file N>]");
        System.out.println("<version> : The version of the FlowFile Package format. Valid values are 1, 2, 3");
        System.out.println("<input file X> : The FlowFile package to unpack");
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            Unpackage.printUsage();
            return;
        }
        String version = args[0];
        int inputFileCount = 0;
        int outputFileCount = 0;
        for (int i = 1; i < args.length; ++i) {
            String filename = args[i];
            File inFile = new File(filename);
            if (inFile.isDirectory()) {
                System.out.println("WARNING: input file " + String.valueOf(inFile) + " is a directory; skipping");
                continue;
            }
            if (!inFile.exists() || !inFile.canRead()) {
                System.out.println("ERROR: unable to read file " + String.valueOf(inFile));
                continue;
            }
            File outputDir = new File(inFile.getAbsolutePath() + ".unpacked");
            if (!outputDir.exists() && !outputDir.mkdir()) {
                System.out.println("ERROR: Unable to create directory " + String.valueOf(outputDir));
                continue;
            }
            File tempFile = new File(outputDir, ".temp." + UUID.randomUUID().toString() + ".unpackage");
            ++inputFileCount;
            try (FileInputStream fis = new FileInputStream(inFile);
                 BufferedInputStream bufferedIn = new BufferedInputStream(fis);){
                FlowFileUnpackager unpackager = Unpackage.createUnpackager(version);
                while (unpackager.hasMoreData()) {
                    Map<String, String> attributes;
                    ++outputFileCount;
                    try (FileOutputStream fos = new FileOutputStream(tempFile);
                         BufferedOutputStream bufferedOut = new BufferedOutputStream(fos);){
                        attributes = unpackager.unpackageFlowFile(bufferedIn, bufferedOut);
                    }
                    String outputFilename = attributes.get("filename");
                    if (outputFilename == null) {
                        outputFilename = attributes.get("nf.file.name");
                    }
                    File outputFile = new File(outputDir, outputFilename);
                    tempFile.renameTo(outputFile);
                    File attributeFilename = new File(outputDir, outputFilename + ".attributes");
                    try (FileOutputStream fos = new FileOutputStream(attributeFilename);
                         BufferedOutputStream bufferedOut = new BufferedOutputStream(fos);){
                        for (Map.Entry<String, String> entry : attributes.entrySet()) {
                            bufferedOut.write((entry.getKey() + "=" + entry.getValue() + "\n").getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
                continue;
            }
        }
        System.out.println("Unpacked " + inputFileCount + " packages into " + outputFileCount + " files");
    }

    public static FlowFileUnpackager createUnpackager(String version) {
        return switch (version) {
            case "1" -> new FlowFileUnpackagerV1();
            case "2" -> new FlowFileUnpackagerV2();
            case "3" -> new FlowFileUnpackagerV3();
            default -> {
                System.out.println("ERROR: Invalid version: " + version + "; must be 1, 2, or 3");
                yield null;
            }
        };
    }
}

