/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.nifi.util.FlowFilePackager;

public class FlowFilePackagerV2
implements FlowFilePackager {
    private static final int MAX_VALUE_2_BYTES = 65535;
    private final byte[] writeBuffer = new byte[8];

    @Override
    public void packageFlowFile(InputStream in, OutputStream out, Map<String, String> attributes, long fileSize) throws IOException {
        this.writeFieldLength(out, attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            this.writeString(entry.getKey(), out);
            this.writeString(entry.getValue(), out);
        }
        this.writeLong(out, fileSize);
        this.copy(in, out);
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[65536];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    private void writeString(String val, OutputStream out) throws IOException {
        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
        this.writeFieldLength(out, bytes.length);
        out.write(bytes);
    }

    private void writeFieldLength(OutputStream out, int numBytes) throws IOException {
        if (numBytes < 65535) {
            this.writeBuffer[0] = (byte)(numBytes >>> 8);
            this.writeBuffer[1] = (byte)numBytes;
            out.write(this.writeBuffer, 0, 2);
        } else {
            this.writeBuffer[0] = -1;
            this.writeBuffer[1] = -1;
            this.writeBuffer[2] = (byte)(numBytes >>> 24);
            this.writeBuffer[3] = (byte)(numBytes >>> 16);
            this.writeBuffer[4] = (byte)(numBytes >>> 8);
            this.writeBuffer[5] = (byte)numBytes;
            out.write(this.writeBuffer, 0, 6);
        }
    }

    private void writeLong(OutputStream out, long val) throws IOException {
        this.writeBuffer[0] = (byte)(val >>> 56);
        this.writeBuffer[1] = (byte)(val >>> 48);
        this.writeBuffer[2] = (byte)(val >>> 40);
        this.writeBuffer[3] = (byte)(val >>> 32);
        this.writeBuffer[4] = (byte)(val >>> 24);
        this.writeBuffer[5] = (byte)(val >>> 16);
        this.writeBuffer[6] = (byte)(val >>> 8);
        this.writeBuffer[7] = (byte)val;
        out.write(this.writeBuffer, 0, 8);
    }
}

