/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.nifi.authorization.AuthorizedUserGroups;
import org.apache.nifi.authorization.AuthorizedUserGroupsMapper;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.User;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.apache.nifi.xml.processing.transform.StandardTransformProvider;
import org.apache.nifi.xml.processing.validation.StandardSchemaValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class FileAuthorizedUserGroupsMapper
implements AuthorizedUserGroupsMapper {
    private static final String TENANTS_XSD = "/tenants.xsd";
    private static final String TENANTS = "tenants";
    private static final String USER = "user";
    private static final String USERS = "users";
    private static final String GROUP = "group";
    private static final String GROUPS = "groups";
    private static final String IDENTIFIER = "identifier";
    private static final String IDENTITY = "identity";
    private static final String NAME = "name";

    FileAuthorizedUserGroupsMapper() {
    }

    @Override
    public AuthorizedUserGroups readUserGroups(InputStream inputStream) {
        NodeList usersNodes;
        Objects.requireNonNull(inputStream, "Input Stream required");
        StandardSchemaValidator schemaValidator = new StandardSchemaValidator();
        Schema schema = this.getSchema();
        StandardDocumentProvider documentProvider = new StandardDocumentProvider();
        Document document = documentProvider.parse(inputStream);
        DOMSource source = new DOMSource(document);
        schemaValidator.validate(schema, (Source)source);
        ArrayList<Group> groups = new ArrayList<Group>();
        ArrayList<User> users = new ArrayList<User>();
        NodeList rootNodes = document.getElementsByTagName(TENANTS);
        Element tenants = (Element)rootNodes.item(0);
        NodeList groupsNodes = tenants.getElementsByTagName(GROUPS);
        if (groupsNodes.getLength() == 1) {
            Element groupsElement = (Element)groupsNodes.item(0);
            NodeList groupNodes = groupsElement.getElementsByTagName(GROUP);
            for (int i = 0; i < groupNodes.getLength(); ++i) {
                Element groupNode = (Element)groupNodes.item(i);
                Group group = this.readGroup(groupNode);
                groups.add(group);
            }
        }
        if ((usersNodes = tenants.getElementsByTagName(USERS)).getLength() == 1) {
            Element usersElement = (Element)usersNodes.item(0);
            NodeList userNodes = usersElement.getElementsByTagName(USER);
            for (int i = 0; i < userNodes.getLength(); ++i) {
                Element userNode = (Element)userNodes.item(i);
                User user = this.readUser(userNode);
                users.add(user);
            }
        }
        return new AuthorizedUserGroups(users, groups);
    }

    @Override
    public void writeUserGroups(AuthorizedUserGroups userGroups, OutputStream outputStream) {
        Iterator<User> users;
        Objects.requireNonNull(userGroups, "User Groups required");
        Objects.requireNonNull(outputStream, "Output Stream required");
        StandardDocumentProvider documentProvider = new StandardDocumentProvider();
        Document document = documentProvider.newDocument();
        Element tenants = document.createElement(TENANTS);
        document.appendChild(tenants);
        Iterator<Group> groups = userGroups.groups().iterator();
        if (groups.hasNext()) {
            Element groupsElement = document.createElement(GROUPS);
            tenants.appendChild(groupsElement);
            while (groups.hasNext()) {
                Group group = groups.next();
                Element groupElement = document.createElement(GROUP);
                groupElement.setAttribute(IDENTIFIER, group.getIdentifier());
                groupElement.setAttribute(NAME, group.getName());
                for (String user : group.getUsers()) {
                    Element userElement = document.createElement(USER);
                    userElement.setAttribute(IDENTIFIER, user);
                    groupElement.appendChild(userElement);
                }
                groupsElement.appendChild(groupElement);
            }
        }
        if ((users = userGroups.users().iterator()).hasNext()) {
            Element usersElement = document.createElement(USERS);
            tenants.appendChild(usersElement);
            while (users.hasNext()) {
                User user = users.next();
                Element userElement = document.createElement(USER);
                userElement.setAttribute(IDENTIFIER, user.getIdentifier());
                userElement.setAttribute(IDENTITY, user.getIdentity());
                usersElement.appendChild(userElement);
            }
        }
        StandardTransformProvider transformProvider = new StandardTransformProvider();
        transformProvider.setIndent(true);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputStream);
        transformProvider.transform((Source)source, (Result)result);
    }

    private User readUser(Element userNode) {
        String identifier = userNode.getAttribute(IDENTIFIER);
        String identity = userNode.getAttribute(IDENTITY);
        return new User.Builder().identifier(identifier).identity(identity).build();
    }

    private Group readGroup(Element groupNode) {
        String identifier = groupNode.getAttribute(IDENTIFIER);
        String name = groupNode.getAttribute(NAME);
        HashSet<String> users = new HashSet<String>();
        NodeList userNodes = groupNode.getElementsByTagName(USER);
        for (int i = 0; i < userNodes.getLength(); ++i) {
            Element userNode = (Element)userNodes.item(i);
            String userIdentifier = userNode.getAttribute(IDENTIFIER);
            users.add(userIdentifier);
        }
        return new Group.Builder().identifier(identifier).name(name).addUsers(users).build();
    }

    private Schema getSchema() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return schemaFactory.newSchema(this.getClass().getResource(TENANTS_XSD));
        }
        catch (SAXException e) {
            throw new ProcessingException("Failed to read Tenants Schema", (Throwable)e);
        }
    }
}

