/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.RequestAction;

public class AuthorizationsHolder {
    private final List<AccessPolicy> policies;
    private final Set<AccessPolicy> allPolicies;
    private final Map<String, Set<AccessPolicy>> policiesByResource;
    private final Map<String, AccessPolicy> policiesById;

    public AuthorizationsHolder(List<AccessPolicy> policies) {
        this.policies = policies;
        Set<AccessPolicy> allPolicies = Set.copyOf(policies);
        Map<String, Set<AccessPolicy>> policiesByResourceMap = Collections.unmodifiableMap(this.createResourcePolicyMap(allPolicies));
        Map<String, AccessPolicy> policiesByIdMap = Collections.unmodifiableMap(this.createPoliciesByIdMap(allPolicies));
        this.allPolicies = allPolicies;
        this.policiesByResource = policiesByResourceMap;
        this.policiesById = policiesByIdMap;
    }

    private Map<String, Set<AccessPolicy>> createResourcePolicyMap(Set<AccessPolicy> allPolicies) {
        HashMap<String, Set<AccessPolicy>> resourcePolicies = new HashMap<String, Set<AccessPolicy>>();
        for (AccessPolicy policy : allPolicies) {
            String resource = policy.getResource();
            Set policies = resourcePolicies.computeIfAbsent(resource, k -> new HashSet());
            policies.add(policy);
        }
        return resourcePolicies;
    }

    private Map<String, AccessPolicy> createPoliciesByIdMap(Set<AccessPolicy> policies) {
        HashMap<String, AccessPolicy> policyMap = new HashMap<String, AccessPolicy>();
        for (AccessPolicy policy : policies) {
            policyMap.put(policy.getIdentifier(), policy);
        }
        return policyMap;
    }

    public List<AccessPolicy> getPolicies() {
        return this.policies;
    }

    public Set<AccessPolicy> getAllPolicies() {
        return this.allPolicies;
    }

    public Map<String, AccessPolicy> getPoliciesById() {
        return this.policiesById;
    }

    public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) {
        if (resourceIdentifier == null) {
            throw new IllegalArgumentException("Resource Identifier cannot be null");
        }
        Set<AccessPolicy> resourcePolicies = this.policiesByResource.get(resourceIdentifier);
        if (resourcePolicies == null) {
            return null;
        }
        for (AccessPolicy accessPolicy : resourcePolicies) {
            if (accessPolicy.getAction() != action) continue;
            return accessPolicy;
        }
        return null;
    }
}

