/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizedUserGroups;
import org.apache.nifi.authorization.AuthorizedUserGroupsMapper;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.FileAuthorizedUserGroupsMapper;
import org.apache.nifi.authorization.FingerprintAuthorizedUserGroupsMapper;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupHolder;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.xml.processing.ProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUserGroupProvider
implements ConfigurableUserGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileUserGroupProvider.class);
    static final String PROP_TENANTS_FILE = "Users File";
    static final String PROP_INITIAL_USER_IDENTITY_PREFIX = "Initial User Identity ";
    static final Pattern INITIAL_USER_IDENTITY_PATTERN = Pattern.compile("Initial User Identity \\S+");
    static final String PROP_INITIAL_GROUP_IDENTITY_PREFIX = "Initial Group Identity ";
    static final Pattern INITIAL_GROUP_IDENTITY_PATTERN = Pattern.compile("Initial Group Identity \\S+");
    private NiFiProperties properties;
    private File tenantsFile;
    private File restoreTenantsFile;
    private Set<String> initialUserIdentities;
    private Set<String> initialGroupIdentities;
    private final AtomicReference<UserGroupHolder> userGroupHolder = new AtomicReference();
    private final AuthorizedUserGroupsMapper fileAuthorizedUserGroupsMapper = new FileAuthorizedUserGroupsMapper();
    private final AuthorizedUserGroupsMapper fingerprintAuthorizedUserGroupMapper = new FingerprintAuthorizedUserGroupsMapper();

    public void initialize(UserGroupProviderInitializationContext initializationContext) throws AuthorizerCreationException {
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        try {
            PropertyValue tenantsPath = configurationContext.getProperty(PROP_TENANTS_FILE);
            if (StringUtils.isBlank((CharSequence)tenantsPath.getValue())) {
                throw new AuthorizerCreationException("The users file must be specified.");
            }
            this.tenantsFile = new File(tenantsPath.getValue());
            if (!this.tenantsFile.exists()) {
                logger.info("Creating new users file at {}", (Object)this.tenantsFile.getAbsolutePath());
                this.saveAuthorizedUserGroups(new AuthorizedUserGroups(List.of(), List.of()), this.tenantsFile);
            }
            File tenantsFileDirectory = this.tenantsFile.getAbsoluteFile().getParentFile();
            File restoreDirectory = this.properties.getRestoreDirectory();
            if (restoreDirectory != null) {
                FileUtils.ensureDirectoryExistAndCanAccess((File)restoreDirectory);
                if (tenantsFileDirectory.getAbsolutePath().equals(restoreDirectory.getAbsolutePath())) {
                    throw new AuthorizerCreationException(String.format("Users file directory '%s' is the same as restore directory '%s' ", tenantsFileDirectory.getAbsolutePath(), restoreDirectory.getAbsolutePath()));
                }
                this.restoreTenantsFile = new File(restoreDirectory, this.tenantsFile.getName());
                try {
                    FileUtils.syncWithRestore((File)this.tenantsFile, (File)this.restoreTenantsFile, (Logger)logger);
                }
                catch (IOException | IllegalStateException ioe) {
                    throw new AuthorizerCreationException((Throwable)ioe);
                }
            }
            List identityMappings = Collections.unmodifiableList(IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
            this.initialUserIdentities = new HashSet<String>();
            this.initialGroupIdentities = new HashSet<String>();
            for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
                if (INITIAL_USER_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey()).matches()) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                    this.initialUserIdentities.add(IdentityMappingUtil.mapIdentity((String)((String)entry.getValue()), identityMappings));
                    continue;
                }
                if (!INITIAL_GROUP_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey()).matches() || !StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                this.initialGroupIdentities.add(IdentityMappingUtil.mapIdentity((String)((String)entry.getValue()), identityMappings));
            }
            this.load();
            if (this.restoreTenantsFile != null) {
                FileUtils.copyFile((File)this.tenantsFile, (File)this.restoreTenantsFile, (boolean)false, (boolean)false, (Logger)logger);
            }
            logger.debug("Users/Groups file loaded");
        }
        catch (IOException | IllegalStateException | AuthorizerCreationException e) {
            throw new AuthorizerCreationException(e);
        }
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllUsers();
    }

    public synchronized User addUser(User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        AuthorizedUserGroups authorizedUserGroups = new AuthorizedUserGroups(List.of(user), List.of());
        this.addUsersAndGroups(authorizedUserGroups);
        return this.userGroupHolder.get().getUsersById().get(user.getIdentifier());
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        return holder.getUsersById().get(identifier);
    }

    public synchronized User updateUser(User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        String identifier = user.getIdentifier();
        UserGroupHolder holder = this.userGroupHolder.get();
        User foundUser = holder.getUsersById().get(identifier);
        if (foundUser == null) {
            return null;
        }
        ArrayList<User> users = new ArrayList<User>(holder.getAllUsers());
        User updatedUser = new User.Builder().identifier(identifier).identity(user.getIdentity()).build();
        ListIterator<User> updatedUsers = users.listIterator();
        while (updatedUsers.hasNext()) {
            User currentUser = (User)updatedUsers.next();
            if (!identifier.equals(currentUser.getIdentifier())) continue;
            updatedUsers.remove();
            updatedUsers.add(updatedUser);
            break;
        }
        ArrayList<Group> groups = new ArrayList<Group>(holder.getAllGroups());
        AuthorizedUserGroups authorizedUserGroups = new AuthorizedUserGroups(users, groups);
        this.saveAndRefreshHolder(authorizedUserGroups);
        return this.userGroupHolder.get().getUsersById().get(identifier);
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        if (identity == null) {
            return null;
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        return holder.getUsersByIdentity().get(identity);
    }

    public synchronized User deleteUser(User user) throws AuthorizationAccessException {
        HashSet updatedUsers;
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        String identifier = user.getIdentifier();
        User deletedUser = holder.getUsersById().get(identifier);
        if (deletedUser == null) {
            return null;
        }
        ArrayList<Group> groups = new ArrayList<Group>(holder.getAllGroups());
        ListIterator<Group> updatedGroups = groups.listIterator();
        while (updatedGroups.hasNext()) {
            Group currentGroup = (Group)updatedGroups.next();
            updatedUsers = new HashSet(currentGroup.getUsers());
            if (!updatedUsers.remove(identifier)) continue;
            updatedGroups.remove();
            Group updatedGroup = new Group.Builder().identifier(currentGroup.getIdentifier()).name(currentGroup.getName()).addUsers((Set)updatedUsers).build();
            updatedGroups.add(updatedGroup);
        }
        ArrayList<User> users = new ArrayList<User>(holder.getAllUsers());
        updatedUsers = users.iterator();
        while (updatedUsers.hasNext()) {
            User updatedUser = (User)updatedUsers.next();
            if (!identifier.equals(updatedUser.getIdentifier())) continue;
            updatedUsers.remove();
            break;
        }
        AuthorizedUserGroups authorizedUserGroups = new AuthorizedUserGroups(users, groups);
        this.saveAndRefreshHolder(authorizedUserGroups);
        return deletedUser;
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllGroups();
    }

    private synchronized void addUsersAndGroups(AuthorizedUserGroups authorizedUserGroups) {
        UserGroupHolder holder = this.userGroupHolder.get();
        AuthorizedUserGroups currentUserGroups = holder.getAuthorizedUserGroups();
        currentUserGroups.users().addAll(authorizedUserGroups.users());
        currentUserGroups.groups().addAll(authorizedUserGroups.groups());
        this.saveAndRefreshHolder(currentUserGroups);
    }

    public synchronized Group addGroup(Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        AuthorizedUserGroups authorizedUserGroups = new AuthorizedUserGroups(List.of(), List.of(group));
        this.addUsersAndGroups(authorizedUserGroups);
        return this.userGroupHolder.get().getGroupsById().get(group.getIdentifier());
    }

    public Group getGroup(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        return this.userGroupHolder.get().getGroupsById().get(identifier);
    }

    public Group getGroupByName(String name) throws AuthorizationAccessException {
        if (name == null) {
            return null;
        }
        return this.userGroupHolder.get().getGroupsByName().get(name);
    }

    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
        UserGroupHolder holder = this.userGroupHolder.get();
        final User user = holder.getUser(identity);
        final Set<Group> groups = holder.getGroups(identity);
        return new UserAndGroups(){

            public User getUser() {
                return user;
            }

            public Set<Group> getGroups() {
                return groups;
            }
        };
    }

    public synchronized Group updateGroup(Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        String identifier = group.getIdentifier();
        Group foundGroup = holder.getGroupsById().get(identifier);
        if (foundGroup == null) {
            return null;
        }
        Group updatedGroup = new Group.Builder().identifier(identifier).name(group.getName()).addUsers(group.getUsers()).build();
        ArrayList<Group> groups = new ArrayList<Group>(holder.getAllGroups());
        ListIterator<Group> updatedGroups = groups.listIterator();
        while (updatedGroups.hasNext()) {
            Group currentGroup = (Group)updatedGroups.next();
            if (!currentGroup.getIdentifier().equals(identifier)) continue;
            updatedGroups.remove();
            updatedGroups.add(updatedGroup);
            break;
        }
        ArrayList<User> users = new ArrayList<User>(holder.getAllUsers());
        AuthorizedUserGroups authorizedUserGroups = new AuthorizedUserGroups(users, groups);
        this.saveAndRefreshHolder(authorizedUserGroups);
        return this.userGroupHolder.get().getGroupsById().get(identifier);
    }

    public synchronized Group deleteGroup(Group group) throws AuthorizationAccessException {
        Objects.requireNonNull(group, "Group required");
        UserGroupHolder holder = this.userGroupHolder.get();
        String identifier = group.getIdentifier();
        Group foundGroup = holder.getGroupsById().get(identifier);
        if (foundGroup == null) {
            return null;
        }
        ArrayList<Group> groups = new ArrayList<Group>(holder.getAllGroups());
        ListIterator updatedGroups = groups.listIterator();
        while (updatedGroups.hasNext()) {
            Group currentGroup = (Group)updatedGroups.next();
            if (!identifier.equals(currentGroup.getIdentifier())) continue;
            updatedGroups.remove();
            break;
        }
        ArrayList<User> users = new ArrayList<User>(holder.getAllUsers());
        AuthorizedUserGroups authorizedUserGroups = new AuthorizedUserGroups(users, groups);
        this.saveAndRefreshHolder(authorizedUserGroups);
        return foundGroup;
    }

    @AuthorizerContext
    public void setNiFiProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public synchronized void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        AuthorizedUserGroups authorizedUserGroups = this.parseUsersAndGroups(fingerprint);
        this.inherit(authorizedUserGroups);
    }

    private synchronized void inherit(AuthorizedUserGroups authorizedUserGroups) {
        this.addUsersAndGroups(authorizedUserGroups);
    }

    public synchronized void forciblyInheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        if (fingerprint == null || fingerprint.isBlank()) {
            logger.info("Inheriting empty Users and Groups: Backup of current Users and Groups started");
            this.backupUsersAndGroups();
            this.purgeUsersAndGroups();
            return;
        }
        AuthorizedUserGroups authorizedUserGroups = this.parseUsersAndGroups(fingerprint);
        if (this.isInheritable()) {
            logger.debug("Inheriting Users and Groups");
            this.inherit(authorizedUserGroups);
        } else {
            logger.info("Failed to inherit Users and Groups: Backup of current Users and Groups before replacing configuration");
            this.backupUsersAndGroups();
            this.purgeUsersAndGroups();
            this.addUsersAndGroups(authorizedUserGroups);
        }
    }

    public void backupUsersAndGroups() throws AuthorizationAccessException {
        UserGroupHolder holder = this.userGroupHolder.get();
        AuthorizedUserGroups authorizedUserGroups = holder.getAuthorizedUserGroups();
        String timestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").format(OffsetDateTime.now());
        File destinationFile = new File(this.tenantsFile.getParentFile(), this.tenantsFile.getName() + "." + timestamp);
        logger.info("Writing backup of Users & Groups to {}", (Object)destinationFile.getAbsolutePath());
        try {
            this.saveAuthorizedUserGroups(authorizedUserGroups, destinationFile);
        }
        catch (ProcessingException e) {
            throw new AuthorizationAccessException("Could not backup existing Users and Groups so will not inherit new Users and Groups", (Throwable)e);
        }
    }

    public synchronized void purgeUsersAndGroups() {
        AuthorizedUserGroups authorizedUserGroups = new AuthorizedUserGroups(List.of(), List.of());
        this.saveAndRefreshHolder(authorizedUserGroups);
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException {
        if (!this.isInheritable()) {
            throw new UninheritableAuthorizationsException("Proposed fingerprint is not inheritable because the current users and groups is not empty");
        }
    }

    private boolean isInheritable() {
        UserGroupHolder usersAndGroups = this.userGroupHolder.get();
        return usersAndGroups.getAllUsers().isEmpty() && usersAndGroups.getAllGroups().isEmpty();
    }

    public String getFingerprint() throws AuthorizationAccessException {
        String string;
        UserGroupHolder holder = this.userGroupHolder.get();
        AuthorizedUserGroups authorizedUserGroups = holder.getAuthorizedUserGroups();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.fingerprintAuthorizedUserGroupMapper.writeUserGroups(authorizedUserGroups, outputStream);
            outputStream.flush();
            string = outputStream.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("User Group Fingerprint generation failed", e);
            }
        }
        outputStream.close();
        return string;
    }

    private AuthorizedUserGroups parseUsersAndGroups(String fingerprint) {
        AuthorizedUserGroups authorizedUserGroups;
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fingerprintBytes);
        try {
            authorizedUserGroups = this.fingerprintAuthorizedUserGroupMapper.readUserGroups(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ProcessingException e) {
                throw new AuthorizationAccessException("User Group Fingerprint parsing failed", e);
            }
        }
        ((InputStream)inputStream).close();
        return authorizedUserGroups;
    }

    private synchronized void load() {
        AuthorizedUserGroups authorizedUserGroups;
        try (FileInputStream inputStream = new FileInputStream(this.tenantsFile);){
            authorizedUserGroups = this.fileAuthorizedUserGroupsMapper.readUserGroups(inputStream);
        }
        catch (IOException | ProcessingException e) {
            throw new IllegalStateException("Loading Users and Groups [%s] failed".formatted(this.tenantsFile), e);
        }
        if (authorizedUserGroups.users().isEmpty() && authorizedUserGroups.groups().isEmpty()) {
            ArrayList<User> users = new ArrayList<User>();
            for (String string : this.initialUserIdentities) {
                User user = new User.Builder().identity(string).identifierGenerateFromSeed(string).build();
                users.add(user);
            }
            ArrayList<Group> groups = new ArrayList<Group>();
            for (String name : this.initialGroupIdentities) {
                Group group = new Group.Builder().name(name).identifierGenerateFromSeed(name).build();
                groups.add(group);
            }
            AuthorizedUserGroups authorizedUserGroups2 = new AuthorizedUserGroups(users, groups);
            this.saveAndRefreshHolder(authorizedUserGroups2);
        } else {
            UserGroupHolder userGroupHolder = new UserGroupHolder(authorizedUserGroups);
            this.userGroupHolder.set(userGroupHolder);
        }
    }

    private void saveAuthorizedUserGroups(AuthorizedUserGroups authorizedUserGroups, File destinationFile) {
        try (FileOutputStream outputStream = new FileOutputStream(destinationFile);){
            this.fileAuthorizedUserGroupsMapper.writeUserGroups(authorizedUserGroups, outputStream);
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to save Tenants [%s]".formatted(destinationFile), (Throwable)e);
        }
    }

    private synchronized void saveAndRefreshHolder(AuthorizedUserGroups authorizedUserGroups) throws AuthorizationAccessException {
        try {
            this.saveAuthorizedUserGroups(authorizedUserGroups, this.tenantsFile);
            this.userGroupHolder.set(new UserGroupHolder(authorizedUserGroups));
        }
        catch (ProcessingException e) {
            throw new AuthorizationAccessException("Unable to save Users and Groups", (Throwable)e);
        }
    }

    public void preDestruction() throws AuthorizerDestructionException {
    }
}

