/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.file.tenants.generated.Group;
import org.apache.nifi.authorization.file.tenants.generated.Groups;
import org.apache.nifi.authorization.file.tenants.generated.Tenants;
import org.apache.nifi.authorization.file.tenants.generated.User;
import org.apache.nifi.authorization.file.tenants.generated.Users;

public class UserGroupHolder {
    private final Tenants tenants;
    private final Set<org.apache.nifi.authorization.User> allUsers;
    private final Map<String, org.apache.nifi.authorization.User> usersById;
    private final Map<String, org.apache.nifi.authorization.User> usersByIdentity;
    private final Set<org.apache.nifi.authorization.Group> allGroups;
    private final Map<String, org.apache.nifi.authorization.Group> groupsById;
    private final Map<String, org.apache.nifi.authorization.Group> groupsByName;
    private final Map<String, Set<org.apache.nifi.authorization.Group>> groupsByUserIdentity;

    public UserGroupHolder(Tenants tenants) {
        this.tenants = tenants;
        Users users = tenants.getUsers();
        Set<org.apache.nifi.authorization.User> allUsers = Collections.unmodifiableSet(this.createUsers(users));
        Groups groups = tenants.getGroups();
        Set<org.apache.nifi.authorization.Group> allGroups = Collections.unmodifiableSet(this.createGroups(groups, users));
        Map<String, org.apache.nifi.authorization.User> userByIdMap = Collections.unmodifiableMap(this.createUserByIdMap(allUsers));
        Map<String, org.apache.nifi.authorization.User> userByIdentityMap = Collections.unmodifiableMap(this.createUserByIdentityMap(allUsers));
        Map<String, org.apache.nifi.authorization.Group> groupByIdMap = Collections.unmodifiableMap(this.createGroupByIdMap(allGroups));
        Map<String, org.apache.nifi.authorization.Group> groupByNameMap = Collections.unmodifiableMap(this.createGroupByNameMap(allGroups));
        Map<String, Set<org.apache.nifi.authorization.Group>> groupsByUserIdentityMap = Collections.unmodifiableMap(this.createGroupsByUserIdentityMap(allGroups, allUsers));
        this.allUsers = allUsers;
        this.allGroups = allGroups;
        this.usersById = userByIdMap;
        this.usersByIdentity = userByIdentityMap;
        this.groupsById = groupByIdMap;
        this.groupsByName = groupByNameMap;
        this.groupsByUserIdentity = groupsByUserIdentityMap;
    }

    private Set<org.apache.nifi.authorization.User> createUsers(Users users) {
        HashSet<org.apache.nifi.authorization.User> allUsers = new HashSet<org.apache.nifi.authorization.User>();
        if (users == null || users.getUser() == null) {
            return allUsers;
        }
        for (User user : users.getUser()) {
            User.Builder builder = new User.Builder().identity(user.getIdentity()).identifier(user.getIdentifier());
            allUsers.add(builder.build());
        }
        return allUsers;
    }

    private Set<org.apache.nifi.authorization.Group> createGroups(Groups groups, Users users) {
        HashSet<org.apache.nifi.authorization.Group> allGroups = new HashSet<org.apache.nifi.authorization.Group>();
        if (groups == null || groups.getGroup() == null) {
            return allGroups;
        }
        for (Group group : groups.getGroup()) {
            Group.Builder builder = new Group.Builder().identifier(group.getIdentifier()).name(group.getName());
            for (Group.User groupUser : group.getUser()) {
                builder.addUser(groupUser.getIdentifier());
            }
            allGroups.add(builder.build());
        }
        return allGroups;
    }

    private Map<String, org.apache.nifi.authorization.User> createUserByIdMap(Set<org.apache.nifi.authorization.User> users) {
        HashMap<String, org.apache.nifi.authorization.User> usersMap = new HashMap<String, org.apache.nifi.authorization.User>();
        for (org.apache.nifi.authorization.User user : users) {
            usersMap.put(user.getIdentifier(), user);
        }
        return usersMap;
    }

    private Map<String, org.apache.nifi.authorization.User> createUserByIdentityMap(Set<org.apache.nifi.authorization.User> users) {
        HashMap<String, org.apache.nifi.authorization.User> usersMap = new HashMap<String, org.apache.nifi.authorization.User>();
        for (org.apache.nifi.authorization.User user : users) {
            usersMap.put(user.getIdentity(), user);
        }
        return usersMap;
    }

    private Map<String, org.apache.nifi.authorization.Group> createGroupByIdMap(Set<org.apache.nifi.authorization.Group> groups) {
        HashMap<String, org.apache.nifi.authorization.Group> groupsMap = new HashMap<String, org.apache.nifi.authorization.Group>();
        for (org.apache.nifi.authorization.Group group : groups) {
            groupsMap.put(group.getIdentifier(), group);
        }
        return groupsMap;
    }

    private Map<String, org.apache.nifi.authorization.Group> createGroupByNameMap(Set<org.apache.nifi.authorization.Group> groups) {
        HashMap<String, org.apache.nifi.authorization.Group> groupsMap = new HashMap<String, org.apache.nifi.authorization.Group>();
        for (org.apache.nifi.authorization.Group group : groups) {
            groupsMap.put(group.getName(), group);
        }
        return groupsMap;
    }

    private Map<String, Set<org.apache.nifi.authorization.Group>> createGroupsByUserIdentityMap(Set<org.apache.nifi.authorization.Group> groups, Set<org.apache.nifi.authorization.User> users) {
        HashMap<String, Set<org.apache.nifi.authorization.Group>> groupsByUserIdentity = new HashMap<String, Set<org.apache.nifi.authorization.Group>>();
        for (org.apache.nifi.authorization.User user : users) {
            HashSet<org.apache.nifi.authorization.Group> userGroups = new HashSet<org.apache.nifi.authorization.Group>();
            for (org.apache.nifi.authorization.Group group : groups) {
                for (String groupUser : group.getUsers()) {
                    if (!groupUser.equals(user.getIdentifier())) continue;
                    userGroups.add(group);
                }
            }
            groupsByUserIdentity.put(user.getIdentity(), userGroups);
        }
        return groupsByUserIdentity;
    }

    public Tenants getTenants() {
        return this.tenants;
    }

    public Set<org.apache.nifi.authorization.User> getAllUsers() {
        return this.allUsers;
    }

    public Map<String, org.apache.nifi.authorization.User> getUsersById() {
        return this.usersById;
    }

    public Map<String, org.apache.nifi.authorization.User> getUsersByIdentity() {
        return this.usersByIdentity;
    }

    public Set<org.apache.nifi.authorization.Group> getAllGroups() {
        return this.allGroups;
    }

    public Map<String, org.apache.nifi.authorization.Group> getGroupsById() {
        return this.groupsById;
    }

    public Map<String, org.apache.nifi.authorization.Group> getGroupsByName() {
        return this.groupsByName;
    }

    public org.apache.nifi.authorization.User getUser(String identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        return this.usersByIdentity.get(identity);
    }

    public Set<org.apache.nifi.authorization.Group> getGroups(String userIdentity) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("User Identity cannot be null");
        }
        return this.groupsByUserIdentity.get(userIdentity);
    }
}

