/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.file.generated.Authorizations;
import org.apache.nifi.authorization.file.generated.Policies;
import org.apache.nifi.authorization.file.generated.Policy;

public class AuthorizationsHolder {
    private final Authorizations authorizations;
    private final Set<AccessPolicy> allPolicies;
    private final Map<String, Set<AccessPolicy>> policiesByResource;
    private final Map<String, AccessPolicy> policiesById;

    public AuthorizationsHolder(Authorizations authorizations) {
        this.authorizations = authorizations;
        Policies policies = authorizations.getPolicies();
        Set<AccessPolicy> allPolicies = Collections.unmodifiableSet(this.createAccessPolicies(policies));
        Map<String, Set<AccessPolicy>> policiesByResourceMap = Collections.unmodifiableMap(this.createResourcePolicyMap(allPolicies));
        Map<String, AccessPolicy> policiesByIdMap = Collections.unmodifiableMap(this.createPoliciesByIdMap(allPolicies));
        this.allPolicies = allPolicies;
        this.policiesByResource = policiesByResourceMap;
        this.policiesById = policiesByIdMap;
    }

    private Set<AccessPolicy> createAccessPolicies(Policies policies) {
        HashSet<AccessPolicy> allPolicies = new HashSet<AccessPolicy>();
        if (policies == null || policies.getPolicy() == null) {
            return allPolicies;
        }
        for (Policy policy : policies.getPolicy()) {
            String policyIdentifier = policy.getIdentifier();
            String resourceIdentifier = policy.getResource();
            AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(policyIdentifier).resource(resourceIdentifier);
            for (Policy.User user : policy.getUser()) {
                builder.addUser(user.getIdentifier());
            }
            for (Policy.Group group : policy.getGroup()) {
                builder.addGroup(group.getIdentifier());
            }
            String authorizationCode = policy.getAction();
            if (authorizationCode.equals("R")) {
                builder.action(RequestAction.READ);
            } else if (authorizationCode.equals("W")) {
                builder.action(RequestAction.WRITE);
            } else {
                throw new IllegalStateException("Unknown Policy Action: " + authorizationCode);
            }
            allPolicies.add(builder.build());
        }
        return allPolicies;
    }

    private Map<String, Set<AccessPolicy>> createResourcePolicyMap(Set<AccessPolicy> allPolicies) {
        HashMap<String, Set<AccessPolicy>> resourcePolicies = new HashMap<String, Set<AccessPolicy>>();
        for (AccessPolicy policy : allPolicies) {
            HashSet<AccessPolicy> policies = (HashSet<AccessPolicy>)resourcePolicies.get(policy.getResource());
            if (policies == null) {
                policies = new HashSet<AccessPolicy>();
                resourcePolicies.put(policy.getResource(), policies);
            }
            policies.add(policy);
        }
        return resourcePolicies;
    }

    private Map<String, AccessPolicy> createPoliciesByIdMap(Set<AccessPolicy> policies) {
        HashMap<String, AccessPolicy> policyMap = new HashMap<String, AccessPolicy>();
        for (AccessPolicy policy : policies) {
            policyMap.put(policy.getIdentifier(), policy);
        }
        return policyMap;
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public Set<AccessPolicy> getAllPolicies() {
        return this.allPolicies;
    }

    public Map<String, Set<AccessPolicy>> getPoliciesByResource() {
        return this.policiesByResource;
    }

    public Map<String, AccessPolicy> getPoliciesById() {
        return this.policiesById;
    }

    public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) {
        if (resourceIdentifier == null) {
            throw new IllegalArgumentException("Resource Identifier cannot be null");
        }
        Set<AccessPolicy> resourcePolicies = this.policiesByResource.get(resourceIdentifier);
        if (resourcePolicies == null) {
            return null;
        }
        for (AccessPolicy accessPolicy : resourcePolicies) {
            if (accessPolicy.getAction() != action) continue;
            return accessPolicy;
        }
        return null;
    }
}

