/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.FileAuthorizer;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.IdentifierUtil;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupHolder;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.authorization.file.tenants.generated.Group;
import org.apache.nifi.authorization.file.tenants.generated.Groups;
import org.apache.nifi.authorization.file.tenants.generated.Tenants;
import org.apache.nifi.authorization.file.tenants.generated.Users;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.security.xml.XmlUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileUserGroupProvider
implements ConfigurableUserGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileUserGroupProvider.class);
    private static final String TENANTS_XSD = "/tenants.xsd";
    private static final String JAXB_TENANTS_PATH = "org.apache.nifi.authorization.file.tenants.generated";
    private static final String USERS_XSD = "/legacy-users.xsd";
    private static final String JAXB_USERS_PATH = "org.apache.nifi.user.generated";
    private static final JAXBContext JAXB_TENANTS_CONTEXT = FileUserGroupProvider.initializeJaxbContext("org.apache.nifi.authorization.file.tenants.generated");
    private static final JAXBContext JAXB_USERS_CONTEXT = FileUserGroupProvider.initializeJaxbContext("org.apache.nifi.user.generated");
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String USER_ELEMENT = "user";
    private static final String GROUP_USER_ELEMENT = "groupUser";
    private static final String GROUP_ELEMENT = "group";
    private static final String IDENTIFIER_ATTR = "identifier";
    private static final String IDENTITY_ATTR = "identity";
    private static final String NAME_ATTR = "name";
    static final String PROP_INITIAL_USER_IDENTITY_PREFIX = "Initial User Identity ";
    static final String PROP_TENANTS_FILE = "Users File";
    static final Pattern INITIAL_USER_IDENTITY_PATTERN = Pattern.compile("Initial User Identity \\S+");
    private Schema usersSchema;
    private Schema tenantsSchema;
    private NiFiProperties properties;
    private File tenantsFile;
    private File restoreTenantsFile;
    private String legacyAuthorizedUsersFile;
    private Set<String> initialUserIdentities;
    private List<IdentityMapping> identityMappings;
    private List<IdentityMapping> groupMappings;
    private final AtomicReference<UserGroupHolder> userGroupHolder = new AtomicReference();

    private static JAXBContext initializeJaxbContext(String contextPath) {
        try {
            return JAXBContext.newInstance((String)contextPath, (ClassLoader)FileAuthorizer.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.", e);
        }
    }

    public void initialize(UserGroupProviderInitializationContext initializationContext) throws AuthorizerCreationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.tenantsSchema = schemaFactory.newSchema(FileAuthorizer.class.getResource(TENANTS_XSD));
            this.usersSchema = schemaFactory.newSchema(FileAuthorizer.class.getResource(USERS_XSD));
        }
        catch (Exception e) {
            throw new AuthorizerCreationException((Throwable)e);
        }
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        try {
            PropertyValue tenantsPath = configurationContext.getProperty(PROP_TENANTS_FILE);
            if (StringUtils.isBlank((CharSequence)tenantsPath.getValue())) {
                throw new AuthorizerCreationException("The users file must be specified.");
            }
            this.tenantsFile = new File(tenantsPath.getValue());
            if (!this.tenantsFile.exists()) {
                logger.info("Creating new users file at {}", new Object[]{this.tenantsFile.getAbsolutePath()});
                this.saveTenants(new Tenants());
            }
            File tenantsFileDirectory = this.tenantsFile.getAbsoluteFile().getParentFile();
            File restoreDirectory = this.properties.getRestoreDirectory();
            if (restoreDirectory != null) {
                FileUtils.ensureDirectoryExistAndCanAccess((File)restoreDirectory);
                if (tenantsFileDirectory.getAbsolutePath().equals(restoreDirectory.getAbsolutePath())) {
                    throw new AuthorizerCreationException(String.format("Users file directory '%s' is the same as restore directory '%s' ", tenantsFileDirectory.getAbsolutePath(), restoreDirectory.getAbsolutePath()));
                }
                this.restoreTenantsFile = new File(restoreDirectory, this.tenantsFile.getName());
                try {
                    FileUtils.syncWithRestore((File)this.tenantsFile, (File)this.restoreTenantsFile, (Logger)logger);
                }
                catch (IOException | IllegalStateException ioe) {
                    throw new AuthorizerCreationException((Throwable)ioe);
                }
            }
            this.identityMappings = Collections.unmodifiableList(IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
            this.groupMappings = Collections.unmodifiableList(IdentityMappingUtil.getGroupMappings((NiFiProperties)this.properties));
            PropertyValue legacyAuthorizedUsersProp = configurationContext.getProperty("Legacy Authorized Users File");
            this.legacyAuthorizedUsersFile = legacyAuthorizedUsersProp.isSet() ? legacyAuthorizedUsersProp.getValue() : null;
            this.initialUserIdentities = new HashSet<String>();
            for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
                Matcher matcher = INITIAL_USER_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey());
                if (!matcher.matches() || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                this.initialUserIdentities.add(IdentityMappingUtil.mapIdentity((String)((String)entry.getValue()), this.identityMappings));
            }
            this.load();
            if (this.restoreTenantsFile != null) {
                FileUtils.copyFile((File)this.tenantsFile, (File)this.restoreTenantsFile, (boolean)false, (boolean)false, (Logger)logger);
            }
            logger.info(String.format("Users/Groups file loaded at %s", new Date().toString()));
        }
        catch (IOException | IllegalStateException | JAXBException | AuthorizerCreationException | SAXException e) {
            throw new AuthorizerCreationException(e);
        }
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllUsers();
    }

    public synchronized User addUser(User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        org.apache.nifi.authorization.file.tenants.generated.User jaxbUser = this.createJAXBUser(user);
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        tenants.getUsers().getUser().add(jaxbUser);
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getUsersById().get(user.getIdentifier());
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        return holder.getUsersById().get(identifier);
    }

    public synchronized User updateUser(User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        List<org.apache.nifi.authorization.file.tenants.generated.User> users = tenants.getUsers().getUser();
        org.apache.nifi.authorization.file.tenants.generated.User updateUser = null;
        for (org.apache.nifi.authorization.file.tenants.generated.User jaxbUser : users) {
            if (!user.getIdentifier().equals(jaxbUser.getIdentifier())) continue;
            updateUser = jaxbUser;
            break;
        }
        if (updateUser == null) {
            return null;
        }
        updateUser.setIdentity(user.getIdentity());
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getUsersById().get(user.getIdentifier());
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        if (identity == null) {
            return null;
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        return holder.getUsersByIdentity().get(identity);
    }

    public synchronized User deleteUser(User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        List<org.apache.nifi.authorization.file.tenants.generated.User> users = tenants.getUsers().getUser();
        block0: for (Group group : tenants.getGroups().getGroup()) {
            Iterator<Group.User> groupUserIter = group.getUser().iterator();
            while (groupUserIter.hasNext()) {
                Group.User groupUser = groupUserIter.next();
                if (!groupUser.getIdentifier().equals(user.getIdentifier())) continue;
                groupUserIter.remove();
                continue block0;
            }
        }
        boolean removedUser = false;
        Iterator<org.apache.nifi.authorization.file.tenants.generated.User> iter = users.iterator();
        while (iter.hasNext()) {
            org.apache.nifi.authorization.file.tenants.generated.User jaxbUser = iter.next();
            if (!user.getIdentifier().equals(jaxbUser.getIdentifier())) continue;
            iter.remove();
            removedUser = true;
            break;
        }
        if (removedUser) {
            this.saveAndRefreshHolder(tenants);
            return user;
        }
        return null;
    }

    public Set<org.apache.nifi.authorization.Group> getGroups() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllGroups();
    }

    public synchronized org.apache.nifi.authorization.Group addGroup(org.apache.nifi.authorization.Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        Group jaxbGroup = new Group();
        jaxbGroup.setIdentifier(group.getIdentifier());
        jaxbGroup.setName(group.getName());
        for (String groupUser : group.getUsers()) {
            Group.User jaxbGroupUser = new Group.User();
            jaxbGroupUser.setIdentifier(groupUser);
            jaxbGroup.getUser().add(jaxbGroupUser);
        }
        tenants.getGroups().getGroup().add(jaxbGroup);
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getGroupsById().get(group.getIdentifier());
    }

    public org.apache.nifi.authorization.Group getGroup(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        return this.userGroupHolder.get().getGroupsById().get(identifier);
    }

    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
        UserGroupHolder holder = this.userGroupHolder.get();
        final User user = holder.getUser(identity);
        final Set<org.apache.nifi.authorization.Group> groups = holder.getGroups(identity);
        return new UserAndGroups(){

            public User getUser() {
                return user;
            }

            public Set<org.apache.nifi.authorization.Group> getGroups() {
                return groups;
            }
        };
    }

    public synchronized org.apache.nifi.authorization.Group updateGroup(org.apache.nifi.authorization.Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        Group updateGroup = null;
        for (Group jaxbGroup : tenants.getGroups().getGroup()) {
            if (!jaxbGroup.getIdentifier().equals(group.getIdentifier())) continue;
            updateGroup = jaxbGroup;
            break;
        }
        if (updateGroup == null) {
            return null;
        }
        updateGroup.getUser().clear();
        for (String groupUser : group.getUsers()) {
            Group.User jaxbGroupUser = new Group.User();
            jaxbGroupUser.setIdentifier(groupUser);
            updateGroup.getUser().add(jaxbGroupUser);
        }
        updateGroup.setName(group.getName());
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getGroupsById().get(group.getIdentifier());
    }

    public synchronized org.apache.nifi.authorization.Group deleteGroup(org.apache.nifi.authorization.Group group) throws AuthorizationAccessException {
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        List<Group> groups = tenants.getGroups().getGroup();
        boolean removedGroup = false;
        Iterator<Group> iter = groups.iterator();
        while (iter.hasNext()) {
            Group jaxbGroup = iter.next();
            if (!group.getIdentifier().equals(jaxbGroup.getIdentifier())) continue;
            iter.remove();
            removedGroup = true;
            break;
        }
        if (removedGroup) {
            this.saveAndRefreshHolder(tenants);
            return group;
        }
        return null;
    }

    UserGroupHolder getUserGroupHolder() {
        return this.userGroupHolder.get();
    }

    @AuthorizerContext
    public void setNiFiProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public synchronized void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        UsersAndGroups usersAndGroups = this.parseUsersAndGroups(fingerprint);
        usersAndGroups.getUsers().forEach(user -> this.addUser((User)user));
        usersAndGroups.getGroups().forEach(group -> this.addGroup((org.apache.nifi.authorization.Group)group));
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException {
        try {
            this.parseUsersAndGroups(proposedFingerprint);
        }
        catch (AuthorizationAccessException e) {
            throw new UninheritableAuthorizationsException("Unable to parse the proposed fingerprint: " + (Object)((Object)e));
        }
        UserGroupHolder usersAndGroups = this.userGroupHolder.get();
        if (!usersAndGroups.getAllUsers().isEmpty() || !usersAndGroups.getAllGroups().isEmpty()) {
            throw new UninheritableAuthorizationsException("Proposed fingerprint is not inheritable because the current users and groups is not empty.");
        }
    }

    public String getFingerprint() throws AuthorizationAccessException {
        UserGroupHolder usersAndGroups = this.userGroupHolder.get();
        ArrayList<User> users = new ArrayList<User>(usersAndGroups.getAllUsers());
        Collections.sort(users, Comparator.comparing(User::getIdentifier));
        ArrayList<org.apache.nifi.authorization.Group> groups = new ArrayList<org.apache.nifi.authorization.Group>(usersAndGroups.getAllGroups());
        Collections.sort(groups, Comparator.comparing(org.apache.nifi.authorization.Group::getIdentifier));
        XMLStreamWriter writer = null;
        StringWriter out = new StringWriter();
        try {
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("tenants");
            for (User user : users) {
                this.writeUser(writer, user);
            }
            for (org.apache.nifi.authorization.Group group : groups) {
                this.writeGroup(writer, group);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return out.toString();
    }

    private UsersAndGroups parseUsersAndGroups(String fingerprint) {
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<org.apache.nifi.authorization.Group> groups = new ArrayList<org.apache.nifi.authorization.Group>();
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);){
            DocumentBuilder docBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            Document document = docBuilder.parse(in);
            Element rootElement = document.getDocumentElement();
            NodeList userNodes = rootElement.getElementsByTagName(USER_ELEMENT);
            for (int i = 0; i < userNodes.getLength(); ++i) {
                Node userNode = userNodes.item(i);
                users.add(this.parseUser((Element)userNode));
            }
            NodeList groupNodes = rootElement.getElementsByTagName(GROUP_ELEMENT);
            for (int i = 0; i < groupNodes.getLength(); ++i) {
                Node groupNode = groupNodes.item(i);
                groups.add(this.parseGroup((Element)groupNode));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new AuthorizationAccessException("Unable to parse fingerprint", (Throwable)e);
        }
        return new UsersAndGroups(users, groups);
    }

    private User parseUser(Element element) {
        User.Builder builder = new User.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).identity(element.getAttribute(IDENTITY_ATTR));
        return builder.build();
    }

    private org.apache.nifi.authorization.Group parseGroup(Element element) {
        Group.Builder builder = new Group.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).name(element.getAttribute(NAME_ATTR));
        NodeList groupUsers = element.getElementsByTagName(GROUP_USER_ELEMENT);
        for (int i = 0; i < groupUsers.getLength(); ++i) {
            Element groupUserNode = (Element)groupUsers.item(i);
            builder.addUser(groupUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    private void writeUser(XMLStreamWriter writer, User user) throws XMLStreamException {
        writer.writeStartElement(USER_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, user.getIdentifier());
        writer.writeAttribute(IDENTITY_ATTR, user.getIdentity());
        writer.writeEndElement();
    }

    private void writeGroup(XMLStreamWriter writer, org.apache.nifi.authorization.Group group) throws XMLStreamException {
        ArrayList users = new ArrayList(group.getUsers());
        Collections.sort(users);
        writer.writeStartElement(GROUP_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, group.getIdentifier());
        writer.writeAttribute(NAME_ATTR, group.getName());
        for (String user : users) {
            writer.writeStartElement(GROUP_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, user);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private org.apache.nifi.authorization.file.tenants.generated.User createJAXBUser(User user) {
        org.apache.nifi.authorization.file.tenants.generated.User jaxbUser = new org.apache.nifi.authorization.file.tenants.generated.User();
        jaxbUser.setIdentifier(user.getIdentifier());
        jaxbUser.setIdentity(user.getIdentity());
        return jaxbUser;
    }

    private synchronized void load() throws JAXBException, IllegalStateException, SAXException {
        boolean hasLegacyAuthorizedUsers;
        UserGroupHolder userGroupHolder;
        Tenants tenants = this.unmarshallTenants();
        if (tenants.getUsers() == null) {
            tenants.setUsers(new Users());
        }
        if (tenants.getGroups() == null) {
            tenants.setGroups(new Groups());
        }
        boolean emptyTenants = (userGroupHolder = new UserGroupHolder(tenants)).getAllUsers().isEmpty() && userGroupHolder.getAllGroups().isEmpty();
        boolean bl = hasLegacyAuthorizedUsers = this.legacyAuthorizedUsersFile != null && !StringUtils.isBlank((CharSequence)this.legacyAuthorizedUsersFile);
        if (emptyTenants) {
            if (hasLegacyAuthorizedUsers) {
                logger.info("Loading users from legacy model " + this.legacyAuthorizedUsersFile + " into new users file.");
                this.convertLegacyAuthorizedUsers(tenants);
            }
            this.populateInitialUsers(tenants);
            this.saveAndRefreshHolder(tenants);
        } else {
            this.userGroupHolder.set(userGroupHolder);
        }
    }

    private void saveTenants(Tenants tenants) throws JAXBException {
        Marshaller marshaller = JAXB_TENANTS_CONTEXT.createMarshaller();
        marshaller.setSchema(this.tenantsSchema);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)tenants, this.tenantsFile);
    }

    private Tenants unmarshallTenants() throws JAXBException {
        Unmarshaller unmarshaller = JAXB_TENANTS_CONTEXT.createUnmarshaller();
        unmarshaller.setSchema(this.tenantsSchema);
        try {
            XMLStreamReader xsr = XmlUtils.createSafeReader((StreamSource)new StreamSource(this.tenantsFile));
            JAXBElement element = unmarshaller.unmarshal(xsr, Tenants.class);
            return (Tenants)element.getValue();
        }
        catch (XMLStreamException e) {
            throw new JAXBException("Error unmarshalling tenants", (Throwable)e);
        }
    }

    private void populateInitialUsers(Tenants tenants) {
        for (String initialUserIdentity : this.initialUserIdentities) {
            this.getOrCreateUser(tenants, initialUserIdentity);
        }
    }

    private void convertLegacyAuthorizedUsers(Tenants tenants) throws AuthorizerCreationException, JAXBException {
        XMLStreamReader xsr;
        File authorizedUsersFile = new File(this.legacyAuthorizedUsersFile);
        if (!authorizedUsersFile.exists()) {
            throw new AuthorizerCreationException("Legacy Authorized Users File '" + this.legacyAuthorizedUsersFile + "' does not exists");
        }
        try {
            xsr = XmlUtils.createSafeReader((StreamSource)new StreamSource(authorizedUsersFile));
        }
        catch (XMLStreamException e) {
            throw new AuthorizerCreationException("Error converting the legacy authorizers file", (Throwable)e);
        }
        Unmarshaller unmarshaller = JAXB_USERS_CONTEXT.createUnmarshaller();
        unmarshaller.setSchema(this.usersSchema);
        JAXBElement element = unmarshaller.unmarshal(xsr, org.apache.nifi.user.generated.Users.class);
        org.apache.nifi.user.generated.Users users = (org.apache.nifi.user.generated.Users)element.getValue();
        if (users.getUser().isEmpty()) {
            logger.info("Legacy Authorized Users File contained no users, nothing to convert");
            return;
        }
        for (org.apache.nifi.user.generated.User legacyUser : users.getUser()) {
            String legacyUserDn = IdentityMappingUtil.mapIdentity((String)legacyUser.getDn(), this.identityMappings);
            org.apache.nifi.authorization.file.tenants.generated.User user = this.getOrCreateUser(tenants, legacyUserDn);
            if (!StringUtils.isNotBlank((CharSequence)legacyUser.getGroup())) continue;
            String legacyGroupName = IdentityMappingUtil.mapIdentity((String)legacyUser.getGroup(), this.groupMappings);
            Group group = this.getOrCreateGroup(tenants, legacyGroupName);
            Group.User groupUser = new Group.User();
            groupUser.setIdentifier(user.getIdentifier());
            group.getUser().add(groupUser);
        }
    }

    private org.apache.nifi.authorization.file.tenants.generated.User getOrCreateUser(Tenants tenants, String userIdentity) {
        if (StringUtils.isBlank((CharSequence)userIdentity)) {
            return null;
        }
        org.apache.nifi.authorization.file.tenants.generated.User foundUser = null;
        for (org.apache.nifi.authorization.file.tenants.generated.User user : tenants.getUsers().getUser()) {
            if (!user.getIdentity().equals(userIdentity)) continue;
            foundUser = user;
            break;
        }
        if (foundUser == null) {
            String userIdentifier = IdentifierUtil.getIdentifier(userIdentity);
            foundUser = new org.apache.nifi.authorization.file.tenants.generated.User();
            foundUser.setIdentifier(userIdentifier);
            foundUser.setIdentity(userIdentity);
            tenants.getUsers().getUser().add(foundUser);
        }
        return foundUser;
    }

    private Group getOrCreateGroup(Tenants tenants, String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return null;
        }
        Group foundGroup = null;
        for (Group group : tenants.getGroups().getGroup()) {
            if (!group.getName().equals(groupName)) continue;
            foundGroup = group;
            break;
        }
        if (foundGroup == null) {
            String newGroupIdentifier = IdentifierUtil.getIdentifier(groupName);
            foundGroup = new Group();
            foundGroup.setIdentifier(newGroupIdentifier);
            foundGroup.setName(groupName);
            tenants.getGroups().getGroup().add(foundGroup);
        }
        return foundGroup;
    }

    private synchronized void saveAndRefreshHolder(Tenants tenants) throws AuthorizationAccessException {
        try {
            this.saveTenants(tenants);
            this.userGroupHolder.set(new UserGroupHolder(tenants));
        }
        catch (JAXBException e) {
            throw new AuthorizationAccessException("Unable to save Authorizations", (Throwable)e);
        }
    }

    public void preDestruction() throws AuthorizerDestructionException {
    }

    private static class UsersAndGroups {
        final List<User> users;
        final List<org.apache.nifi.authorization.Group> groups;

        public UsersAndGroups(List<User> users, List<org.apache.nifi.authorization.Group> groups) {
            this.users = users;
            this.groups = groups;
        }

        public List<User> getUsers() {
            return this.users;
        }

        public List<org.apache.nifi.authorization.Group> getGroups() {
            return this.groups;
        }
    }
}

