/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.reduce;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.ReduceEvaluator;

public class JoinEvaluator
extends StringEvaluator
implements ReduceEvaluator<String> {
    private final Evaluator<String> subjectEvaluator;
    private final Evaluator<String> delimiterEvaluator;
    private final StringBuilder sb = new StringBuilder();
    private int evalCount = 0;

    public JoinEvaluator(Evaluator<String> subject, Evaluator<String> delimiter) {
        this.subjectEvaluator = subject;
        this.delimiterEvaluator = delimiter;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subject = this.subjectEvaluator.evaluate(attributes).getValue();
        if (subject == null) {
            subject = "";
        }
        String delimiter = this.delimiterEvaluator.evaluate(attributes).getValue();
        if (this.evalCount > 0) {
            this.sb.append(delimiter);
        }
        this.sb.append(subject);
        ++this.evalCount;
        return new StringQueryResult(this.sb.toString());
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

