/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class SubstringEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<Long> startIndex;
    private final Evaluator<Long> endIndex;

    public SubstringEvaluator(Evaluator<String> subject, Evaluator<Long> startIndex, Evaluator<Long> endIndex) {
        this.subject = subject;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public SubstringEvaluator(Evaluator<String> subject, Evaluator<Long> startIndex) {
        this.subject = subject;
        this.startIndex = startIndex;
        this.endIndex = null;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new StringQueryResult("");
        }
        int startIndexValue = this.startIndex.evaluate(attributes).getValue().intValue();
        if (this.endIndex == null) {
            return new StringQueryResult(subjectValue.substring(startIndexValue));
        }
        int endIndexValue = this.endIndex.evaluate(attributes).getValue().intValue();
        return new StringQueryResult(subjectValue.substring(startIndexValue, endIndexValue));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

