/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.literals.BooleanLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;

public class GetDelimitedFieldEvaluator
extends StringEvaluator {
    private final Evaluator<String> subjectEval;
    private final Evaluator<Long> indexEval;
    private final Evaluator<String> delimiterEval;
    private final Evaluator<String> quoteCharEval;
    private final Evaluator<String> escapeCharEval;
    private final Evaluator<Boolean> stripCharsEval;

    public GetDelimitedFieldEvaluator(Evaluator<String> subject, Evaluator<Long> index) {
        this(subject, index, new StringLiteralEvaluator(","));
    }

    public GetDelimitedFieldEvaluator(Evaluator<String> subject, Evaluator<Long> index, Evaluator<String> delimiter) {
        this(subject, index, delimiter, new StringLiteralEvaluator("\""));
    }

    public GetDelimitedFieldEvaluator(Evaluator<String> subject, Evaluator<Long> index, Evaluator<String> delimiter, Evaluator<String> quoteChar) {
        this(subject, index, delimiter, quoteChar, new StringLiteralEvaluator("\\\\"));
    }

    public GetDelimitedFieldEvaluator(Evaluator<String> subject, Evaluator<Long> index, Evaluator<String> delimiter, Evaluator<String> quoteChar, Evaluator<String> escapeChar) {
        this(subject, index, delimiter, quoteChar, escapeChar, new BooleanLiteralEvaluator(false));
    }

    public GetDelimitedFieldEvaluator(Evaluator<String> subject, Evaluator<Long> index, Evaluator<String> delimiter, Evaluator<String> quoteChar, Evaluator<String> escapeChar, Evaluator<Boolean> stripChars) {
        this.subjectEval = subject;
        this.indexEval = index;
        this.delimiterEval = delimiter;
        this.quoteCharEval = quoteChar;
        this.escapeCharEval = escapeChar;
        this.stripCharsEval = stripChars;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subject = this.subjectEval.evaluate(attributes).getValue();
        if (subject == null || subject.isEmpty()) {
            return new StringQueryResult("");
        }
        Long index = this.indexEval.evaluate(attributes).getValue();
        if (index == null) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the index (which field to obtain) was not specified");
        }
        if (index < 1L) {
            return new StringQueryResult("");
        }
        String delimiter = this.delimiterEval.evaluate(attributes).getValue();
        if (delimiter == null || delimiter.isEmpty()) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the delimiter was not specified");
        }
        if (delimiter.length() > 1) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the delimiter evaluated to \"" + delimiter + "\", but only a single character is allowed.");
        }
        String quoteString = this.quoteCharEval.evaluate(attributes).getValue();
        if (quoteString == null || quoteString.isEmpty()) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the quote character (which character is used to enclose values that contain the delimiter) was not specified");
        }
        if (quoteString.length() > 1) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the quote character (which character is used to enclose values that contain the delimiter) evaluated to \"" + quoteString + "\", but only a single character is allowed.");
        }
        String escapeString = this.escapeCharEval.evaluate(attributes).getValue();
        if (escapeString == null || escapeString.isEmpty()) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the escape character (which character is used to escape the quote character or delimiter) was not specified");
        }
        if (escapeString.length() > 1) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the escape character (which character is used to escape the quote character or delimiter) evaluated to \"" + escapeString + "\", but only a single character is allowed.");
        }
        Boolean stripChars = this.stripCharsEval.evaluate(attributes).getValue();
        if (stripChars == null) {
            stripChars = Boolean.FALSE;
        }
        char quoteChar = quoteString.charAt(0);
        char delimiterChar = delimiter.charAt(0);
        char escapeChar = escapeString.charAt(0);
        if (quoteChar == delimiterChar) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the quote character and the delimiter are the same");
        }
        if (quoteChar == escapeChar) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the quote character and the escape character are the same");
        }
        if (delimiterChar == escapeChar) {
            throw new AttributeExpressionLanguageException("Cannot evaluate getDelimitedField function because the delimiter and the escape character are the same");
        }
        StringBuilder fieldBuilder = new StringBuilder();
        int desiredFieldIndex = index.intValue();
        int numChars = subject.length();
        boolean inQuote = false;
        int curFieldIndex = 1;
        boolean lastCharIsEscape = false;
        for (int i = 0; i < numChars; ++i) {
            char c = subject.charAt(i);
            if (c == quoteChar && !lastCharIsEscape) {
                boolean bl = inQuote = !inQuote;
                if (!stripChars.booleanValue() && curFieldIndex == desiredFieldIndex) {
                    fieldBuilder.append(c);
                }
            } else if (c == delimiterChar && !lastCharIsEscape && !inQuote) {
                int indexJustFinished;
                if ((indexJustFinished = curFieldIndex++) == desiredFieldIndex) {
                    return new StringQueryResult(fieldBuilder.toString());
                }
            } else if (!(curFieldIndex != desiredFieldIndex || c == escapeChar && stripChars.booleanValue())) {
                fieldBuilder.append(c);
            }
            lastCharIsEscape = c == escapeChar && !lastCharIsEscape;
        }
        if (curFieldIndex == desiredFieldIndex) {
            return new StringQueryResult(fieldBuilder.toString());
        }
        return new StringQueryResult("");
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEval;
    }
}

