/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml.value;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNode;

public class FiletimeTypeNode
extends VariantTypeNode {
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final String value;

    public FiletimeTypeNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent, int length) throws IOException {
        super(binaryReader, chunkHeader, parent, length);
        this.value = DATE_TIME_FORMATTER.format(binaryReader.readFileTime().toInstant().atOffset(ZoneOffset.UTC));
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

