/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.Block;
import org.apache.nifi.processors.evtx.parser.NumberUtil;
import org.apache.nifi.processors.evtx.parser.Record;
import org.apache.nifi.processors.evtx.parser.bxml.NameStringNode;
import org.apache.nifi.processors.evtx.parser.bxml.TemplateNode;

public class ChunkHeader
extends Block {
    public static final String ELF_CHNK = "ElfChnk";
    private final String magicString;
    private final UnsignedLong fileFirstRecordNumber;
    private final UnsignedLong fileLastRecordNumber;
    private final UnsignedLong logFirstRecordNumber;
    private final UnsignedLong logLastRecordNumber;
    private final UnsignedInteger headerSize;
    private final UnsignedInteger lastRecordOffset;
    private final int nextRecordOffset;
    private final UnsignedInteger dataChecksum;
    private final String unused;
    private final UnsignedInteger headerChecksum;
    private final Map<Integer, NameStringNode> nameStrings;
    private final Map<Integer, TemplateNode> templateNodes;
    private final int chunkNumber;
    private UnsignedLong recordNumber;

    public ChunkHeader(BinaryReader binaryReader, ComponentLog log, long headerOffset, int chunkNumber) throws IOException {
        super(binaryReader, headerOffset);
        int offset;
        int i;
        this.chunkNumber = chunkNumber;
        CRC32 crc32 = new CRC32();
        crc32.update(binaryReader.peekBytes(120));
        this.magicString = binaryReader.readString(8);
        this.fileFirstRecordNumber = binaryReader.readQWord();
        this.fileLastRecordNumber = binaryReader.readQWord();
        this.logFirstRecordNumber = binaryReader.readQWord();
        this.logLastRecordNumber = binaryReader.readQWord();
        this.headerSize = binaryReader.readDWord();
        this.lastRecordOffset = binaryReader.readDWord();
        this.nextRecordOffset = NumberUtil.intValueMax(binaryReader.readDWord(), Integer.MAX_VALUE, "Invalid next record offset.", new Object[0]);
        this.dataChecksum = binaryReader.readDWord();
        this.unused = binaryReader.readString(68);
        if (!ELF_CHNK.equals(this.magicString)) {
            throw new IOException("Invalid magic string " + String.valueOf(this));
        }
        this.headerChecksum = binaryReader.readDWord();
        crc32.update(binaryReader.peekBytes(384));
        if (crc32.getValue() != this.headerChecksum.longValue()) {
            throw new IOException("Invalid checksum " + String.valueOf(this));
        }
        if (this.lastRecordOffset.compareTo(UnsignedInteger.valueOf((long)Integer.MAX_VALUE)) > 0) {
            throw new IOException("Last record offset too big to fit into signed integer");
        }
        this.nameStrings = new HashMap<Integer, NameStringNode>();
        for (i = 0; i < 64; ++i) {
            offset = NumberUtil.intValueMax(binaryReader.readDWord(), Integer.MAX_VALUE, "Invalid offset.", new Object[0]);
            while (offset > 0) {
                NameStringNode nameStringNode = new NameStringNode(new BinaryReader(binaryReader, offset), this);
                this.nameStrings.put(offset, nameStringNode);
                offset = NumberUtil.intValueMax(nameStringNode.getNextOffset(), Integer.MAX_VALUE, "Invalid offset.", new Object[0]);
            }
        }
        this.templateNodes = new HashMap<Integer, TemplateNode>();
        block2: for (i = 0; i < 32; ++i) {
            offset = NumberUtil.intValueMax(binaryReader.readDWord(), Integer.MAX_VALUE, "Invalid offset.", new Object[0]);
            while (offset > 0) {
                int token = new BinaryReader(binaryReader, offset - 10).read();
                if (token != 12) {
                    log.warn("Unexpected token when parsing template at offset {}", new Object[]{offset});
                    continue block2;
                }
                BinaryReader templateReader = new BinaryReader(binaryReader, offset - 4);
                int pointer = NumberUtil.intValueMax(templateReader.readDWord(), Integer.MAX_VALUE, "Invalid pointer.", new Object[0]);
                if (offset != pointer) {
                    log.warn("Invalid pointer when parsing template at offset {}", new Object[]{offset});
                    continue block2;
                }
                TemplateNode templateNode = new TemplateNode(templateReader, this);
                this.templateNodes.put(offset, templateNode);
                offset = templateNode.getNextOffset();
            }
        }
        crc32 = new CRC32();
        crc32.update(binaryReader.peekBytes(this.nextRecordOffset - 512));
        if (crc32.getValue() != this.dataChecksum.longValue()) {
            throw new IOException("Invalid data checksum " + String.valueOf(this));
        }
        this.recordNumber = this.fileFirstRecordNumber.minus(UnsignedLong.ONE);
    }

    public NameStringNode addNameStringNode(int offset, BinaryReader binaryReader) throws IOException {
        NameStringNode nameStringNode = new NameStringNode(binaryReader, this);
        this.nameStrings.put(offset, nameStringNode);
        return nameStringNode;
    }

    public TemplateNode addTemplateNode(int offset, BinaryReader binaryReader) throws IOException {
        TemplateNode templateNode = new TemplateNode(binaryReader, this);
        this.templateNodes.put(offset, templateNode);
        return templateNode;
    }

    public TemplateNode getTemplateNode(int offset) {
        return this.templateNodes.get(offset);
    }

    public String toString() {
        return "ChunkHeader{magicString='" + this.magicString + "', fileFirstRecordNumber=" + String.valueOf(this.fileFirstRecordNumber) + ", fileLastRecordNumber=" + String.valueOf(this.fileLastRecordNumber) + ", logFirstRecordNumber=" + String.valueOf(this.logFirstRecordNumber) + ", logLastRecordNumber=" + String.valueOf(this.logLastRecordNumber) + ", headerSize=" + String.valueOf(this.headerSize) + ", lastRecordOffset=" + String.valueOf(this.lastRecordOffset) + ", nextRecordOffset=" + this.nextRecordOffset + ", dataChecksum=" + String.valueOf(this.dataChecksum) + ", unused='" + this.unused + "', headerChecksum=" + String.valueOf(this.headerChecksum) + "}";
    }

    public boolean hasNext() {
        return this.logLastRecordNumber.compareTo(this.recordNumber) > 0;
    }

    public String getString(int offset) {
        NameStringNode nameStringNode = this.nameStrings.get(offset);
        if (nameStringNode == null) {
            return null;
        }
        return nameStringNode.getString();
    }

    @VisibleForTesting
    Map<Integer, NameStringNode> getNameStrings() {
        return Collections.unmodifiableMap(this.nameStrings);
    }

    @VisibleForTesting
    Map<Integer, TemplateNode> getTemplateNodes() {
        return Collections.unmodifiableMap(this.templateNodes);
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public Record next() throws IOException {
        if (!this.hasNext()) {
            return null;
        }
        try {
            Record record = new Record(this.getBinaryReader(), this);
            this.recordNumber = record.getRecordNum();
            return record;
        }
        catch (IOException e) {
            this.recordNumber = this.fileLastRecordNumber;
            throw e;
        }
    }
}

