/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.evtx.MalformedChunkHandler;
import org.apache.nifi.processors.evtx.ResultProcessor;
import org.apache.nifi.processors.evtx.RootNodeHandler;
import org.apache.nifi.processors.evtx.RootNodeHandlerFactory;
import org.apache.nifi.processors.evtx.XmlRootNodeHandler;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.FileHeader;
import org.apache.nifi.processors.evtx.parser.FileHeaderFactory;
import org.apache.nifi.processors.evtx.parser.MalformedChunkException;
import org.apache.nifi.processors.evtx.parser.Record;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"logs", "windows", "event", "evtx", "message", "file"})
@CapabilityDescription(value="Parses the contents of a Windows Event Log file (evtx) and writes the resulting XML to the FlowFile")
@ReadsAttributes(value={@ReadsAttribute(attribute="filename", description="The filename of the evtx file")})
@WritesAttributes(value={@WritesAttribute(attribute="filename", description="The output filename"), @WritesAttribute(attribute="mime.type", description="The output filetype (application/xml for success and failure relationships, original value for bad chunk and original relationships)")})
public class ParseEvtx
extends AbstractProcessor {
    public static final String RECORD = "Record";
    public static final String CHUNK = "Chunk";
    public static final String FILE = "File";
    public static final String EVTX_EXTENSION = ".evtx";
    public static final String XML_EXTENSION = ".xml";
    @VisibleForTesting
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Any FlowFile that was successfully converted from evtx to XML").build();
    @VisibleForTesting
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that encountered an exception during conversion will be transferred to this relationship with as much parsing as possible done").build();
    @VisibleForTesting
    static final Relationship REL_BAD_CHUNK = new Relationship.Builder().name("bad chunk").description("Any bad chunks of records will be transferred to this relationship in their original binary form").build();
    @VisibleForTesting
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The unmodified input FlowFile will be transferred to this relationship").build();
    @VisibleForTesting
    static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_ORIGINAL, REL_BAD_CHUNK);
    @VisibleForTesting
    static final PropertyDescriptor GRANULARITY = new PropertyDescriptor.Builder().required(true).name("Granularity").description("Output flow file for each Record, Chunk, or File encountered in the event log").defaultValue("Chunk").allowableValues(new String[]{"Record", "Chunk", "File"}).build();
    @VisibleForTesting
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(GRANULARITY);
    private final FileHeaderFactory fileHeaderFactory;
    private final MalformedChunkHandler malformedChunkHandler;
    private final RootNodeHandlerFactory rootNodeHandlerFactory;
    private final ResultProcessor resultProcessor;

    public ParseEvtx() {
        this(FileHeader::new, new MalformedChunkHandler(REL_BAD_CHUNK), XmlRootNodeHandler::new, new ResultProcessor(REL_SUCCESS, REL_FAILURE));
    }

    public ParseEvtx(FileHeaderFactory fileHeaderFactory, MalformedChunkHandler malformedChunkHandler, RootNodeHandlerFactory rootNodeHandlerFactory, ResultProcessor resultProcessor) {
        this.fileHeaderFactory = fileHeaderFactory;
        this.malformedChunkHandler = malformedChunkHandler;
        this.rootNodeHandlerFactory = rootNodeHandlerFactory;
        this.resultProcessor = resultProcessor;
    }

    protected String getName(String basename, Object chunkNumber, Object recordNumber, String extension) {
        StringBuilder stringBuilder = new StringBuilder(basename);
        if (chunkNumber != null) {
            stringBuilder.append("-chunk");
            stringBuilder.append(chunkNumber);
        }
        if (recordNumber != null) {
            stringBuilder.append("-record");
            stringBuilder.append(recordNumber);
        }
        stringBuilder.append(extension);
        return stringBuilder.toString();
    }

    protected String getBasename(FlowFile flowFile, ComponentLog logger) {
        String basename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        if (basename.endsWith(EVTX_EXTENSION)) {
            return basename.substring(0, basename.length() - EVTX_EXTENSION.length());
        }
        logger.warn("Trying to parse file without .evtx extension {} from flowfile {}", new Object[]{basename, flowFile});
        return basename;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ComponentLog logger = this.getLogger();
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String basename = this.getBasename(flowFile, logger);
        String granularity = context.getProperty(GRANULARITY).getValue();
        if (FILE.equals(granularity)) {
            FlowFile original = session.clone(flowFile);
            AtomicReference<Object> exceptionReference = new AtomicReference<Object>(null);
            FlowFile updated = session.write(flowFile, (in, out) -> this.processFileGranularity(session, logger, original, basename, exceptionReference, in, out));
            session.transfer(original, REL_ORIGINAL);
            this.resultProcessor.process(session, logger, updated, exceptionReference.get(), this.getName(basename, null, null, XML_EXTENSION));
        } else {
            session.read(flowFile, in -> {
                if (RECORD.equals(granularity)) {
                    this.processRecordGranularity(session, logger, flowFile, basename, in);
                } else if (CHUNK.equals(granularity)) {
                    this.processChunkGranularity(session, logger, flowFile, basename, in);
                }
            });
            session.transfer(flowFile, REL_ORIGINAL);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("granularity", GRANULARITY.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processFileGranularity(ProcessSession session, ComponentLog componentLog, FlowFile original, String basename, AtomicReference<Exception> exceptionReference, InputStream in, OutputStream out) throws IOException {
        FileHeader fileHeader = this.fileHeaderFactory.create(in, componentLog);
        try (RootNodeHandler rootNodeHandler = this.rootNodeHandlerFactory.create(out);){
            block11: while (fileHeader.hasNext()) {
                try {
                    ChunkHeader chunkHeader = fileHeader.next();
                    try {
                        while (true) {
                            if (!chunkHeader.hasNext()) continue block11;
                            rootNodeHandler.handle(chunkHeader.next().getRootNode());
                        }
                    }
                    catch (IOException e) {
                        this.malformedChunkHandler.handle(original, session, this.getName(basename, chunkHeader.getChunkNumber(), null, EVTX_EXTENSION), chunkHeader.getBinaryReader().getBytes());
                        exceptionReference.set(e);
                    }
                }
                catch (MalformedChunkException e) {
                    this.malformedChunkHandler.handle(original, session, this.getName(basename, e.getChunkNum(), null, EVTX_EXTENSION), e.getBadChunk());
                }
            }
            return;
        }
        catch (IOException e) {
            exceptionReference.set(e);
        }
    }

    protected void processChunkGranularity(ProcessSession session, ComponentLog componentLog, FlowFile flowFile, String basename, InputStream in) throws IOException {
        FileHeader fileHeader = this.fileHeaderFactory.create(in, componentLog);
        while (fileHeader.hasNext()) {
            try {
                ChunkHeader chunkHeader = fileHeader.next();
                FlowFile updated = session.create(flowFile);
                AtomicReference<Object> exceptionReference = new AtomicReference<Object>(null);
                updated = session.write(updated, out -> {
                    try (RootNodeHandler rootNodeHandler = this.rootNodeHandlerFactory.create(out);){
                        while (chunkHeader.hasNext()) {
                            try {
                                rootNodeHandler.handle(chunkHeader.next().getRootNode());
                            }
                            catch (IOException e) {
                                exceptionReference.set(e);
                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        exceptionReference.set(e);
                    }
                });
                Exception exception = exceptionReference.get();
                this.resultProcessor.process(session, componentLog, updated, exception, this.getName(basename, chunkHeader.getChunkNumber(), null, XML_EXTENSION));
                if (exception == null) continue;
                this.malformedChunkHandler.handle(flowFile, session, this.getName(basename, chunkHeader.getChunkNumber(), null, EVTX_EXTENSION), chunkHeader.getBinaryReader().getBytes());
            }
            catch (MalformedChunkException e) {
                this.malformedChunkHandler.handle(flowFile, session, this.getName(basename, e.getChunkNum(), null, EVTX_EXTENSION), e.getBadChunk());
            }
        }
    }

    protected void processRecordGranularity(ProcessSession session, ComponentLog componentLog, FlowFile flowFile, String basename, InputStream in) throws IOException {
        FileHeader fileHeader = this.fileHeaderFactory.create(in, componentLog);
        while (fileHeader.hasNext()) {
            try {
                ChunkHeader chunkHeader = fileHeader.next();
                while (chunkHeader.hasNext()) {
                    FlowFile updated = session.create(flowFile);
                    AtomicReference<Object> exceptionReference = new AtomicReference<Object>(null);
                    try {
                        Record record = chunkHeader.next();
                        updated = session.write(updated, out -> {
                            try (RootNodeHandler rootNodeHandler = this.rootNodeHandlerFactory.create(out);){
                                try {
                                    rootNodeHandler.handle(record.getRootNode());
                                }
                                catch (IOException e) {
                                    exceptionReference.set(e);
                                }
                            }
                            catch (IOException e) {
                                exceptionReference.set(e);
                            }
                        });
                        this.resultProcessor.process(session, componentLog, updated, exceptionReference.get(), this.getName(basename, chunkHeader.getChunkNumber(), record.getRecordNum(), XML_EXTENSION));
                    }
                    catch (Exception e) {
                        exceptionReference.set(e);
                        session.remove(updated);
                    }
                    if (exceptionReference.get() == null) continue;
                    this.malformedChunkHandler.handle(flowFile, session, this.getName(basename, chunkHeader.getChunkNumber(), null, EVTX_EXTENSION), chunkHeader.getBinaryReader().getBytes());
                }
            }
            catch (MalformedChunkException e) {
                this.malformedChunkHandler.handle(flowFile, session, this.getName(basename, e.getChunkNum(), null, EVTX_EXTENSION), e.getBadChunk());
            }
        }
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }
}

