/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import com.google.common.primitives.UnsignedInteger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.NumberUtil;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNodeWithToken;
import org.apache.nifi.processors.evtx.parser.bxml.TemplateNode;

public class TemplateInstanceNode
extends BxmlNodeWithToken {
    private final int unknown;
    private final UnsignedInteger templateId;
    private final int templateOffset;
    private final boolean isResident;
    private final TemplateNode templateNode;
    private final int templateLength;

    public TemplateInstanceNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent) throws IOException {
        super(binaryReader, chunkHeader, parent);
        this.unknown = binaryReader.read();
        this.templateId = binaryReader.readDWord();
        this.templateOffset = NumberUtil.intValueMax(binaryReader.readDWord(), Integer.MAX_VALUE, "Invalid template offset.", new Object[0]);
        if ((long)this.templateOffset > this.getOffset() - chunkHeader.getOffset()) {
            this.isResident = true;
            int initialPosition = binaryReader.getPosition();
            this.templateNode = chunkHeader.addTemplateNode(this.templateOffset, binaryReader);
            this.templateLength = binaryReader.getPosition() - initialPosition;
        } else {
            this.isResident = false;
            this.templateNode = chunkHeader.getTemplateNode(this.templateOffset);
            this.templateLength = 0;
        }
        if (this.templateNode != null && !this.templateId.equals((Object)this.templateNode.getTemplateId())) {
            throw new IOException("Invalid template id");
        }
        this.init();
    }

    @Override
    protected int getHeaderLength() {
        return 10 + this.templateLength;
    }

    public TemplateNode getTemplateNode() {
        return this.templateNode;
    }

    @Override
    protected List<BxmlNode> initChildren() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public boolean hasEndOfStream() {
        return super.hasEndOfStream() || this.templateNode.hasEndOfStream();
    }

    @Override
    public void accept(BxmlNodeVisitor bxmlNodeVisitor) throws IOException {
        bxmlNodeVisitor.visit(this);
    }
}

