/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNodeWithToken;
import org.apache.nifi.processors.evtx.parser.bxml.value.BXmlTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.BinaryTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.BooleanTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.DoubleTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.FiletimeTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.FloatTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.GuidTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.Hex32TypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.Hex64TypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.NullTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.SIDTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.SignedByteTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.SignedDWordTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.SignedQWordTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.SignedWordTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.SizeTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.StringTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.SystemtimeTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.UnsignedByteTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.UnsignedDWordTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.UnsignedQWordTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.UnsignedWordTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNodeFactory;
import org.apache.nifi.processors.evtx.parser.bxml.value.WStringArrayTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.WStringTypeNode;

public class ValueNode
extends BxmlNodeWithToken {
    public static final Map<Integer, VariantTypeNodeFactory> factories = ValueNode.initFactories();
    private final int type;

    public ValueNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent) throws IOException {
        super(binaryReader, chunkHeader, parent);
        if ((this.getFlags() & 0xB) != 0) {
            throw new IOException("Invalid flag");
        }
        this.type = binaryReader.read();
        this.init();
    }

    private static Map<Integer, VariantTypeNodeFactory> initFactories() {
        HashMap<Integer, VariantTypeNodeFactory> result = new HashMap<Integer, VariantTypeNodeFactory>();
        result.put(0, NullTypeNode::new);
        result.put(1, WStringTypeNode::new);
        result.put(2, StringTypeNode::new);
        result.put(3, SignedByteTypeNode::new);
        result.put(4, UnsignedByteTypeNode::new);
        result.put(5, SignedWordTypeNode::new);
        result.put(6, UnsignedWordTypeNode::new);
        result.put(7, SignedDWordTypeNode::new);
        result.put(8, UnsignedDWordTypeNode::new);
        result.put(9, SignedQWordTypeNode::new);
        result.put(10, UnsignedQWordTypeNode::new);
        result.put(11, FloatTypeNode::new);
        result.put(12, DoubleTypeNode::new);
        result.put(13, BooleanTypeNode::new);
        result.put(14, BinaryTypeNode::new);
        result.put(15, GuidTypeNode::new);
        result.put(16, SizeTypeNode::new);
        result.put(17, FiletimeTypeNode::new);
        result.put(18, SystemtimeTypeNode::new);
        result.put(19, SIDTypeNode::new);
        result.put(20, Hex32TypeNode::new);
        result.put(21, Hex64TypeNode::new);
        result.put(33, BXmlTypeNode::new);
        result.put(129, WStringArrayTypeNode::new);
        return Collections.unmodifiableMap(result);
    }

    @Override
    protected List<BxmlNode> initChildren() throws IOException {
        VariantTypeNode variantTypeNode = factories.get(this.type).create(this.getBinaryReader(), this.getChunkHeader(), this, -1);
        return Collections.singletonList(variantTypeNode);
    }

    @Override
    public void accept(BxmlNodeVisitor bxmlNodeVisitor) throws IOException {
        bxmlNodeVisitor.visit(this);
    }
}

