/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import java.io.IOException;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.NumberUtil;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNodeWithToken;
import org.apache.nifi.processors.evtx.parser.bxml.NameStringNode;

public abstract class BxmlNodeWithTokenAndString
extends BxmlNodeWithToken {
    private final int stringOffset;
    private final String value;
    private final int tagLength;

    public BxmlNodeWithTokenAndString(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent) throws IOException {
        super(binaryReader, chunkHeader, parent);
        this.stringOffset = NumberUtil.intValueMax(binaryReader.readDWord(), Integer.MAX_VALUE, "Invalid string offset.", new Object[0]);
        int tagLength = this.getBaseTagLength();
        if ((long)this.stringOffset > this.getOffset() - chunkHeader.getOffset()) {
            int initialPosition = binaryReader.getPosition();
            NameStringNode nameStringNode = chunkHeader.addNameStringNode(this.stringOffset, binaryReader);
            tagLength += binaryReader.getPosition() - initialPosition;
            this.value = nameStringNode.getString();
        } else {
            this.value = chunkHeader.getString(this.stringOffset);
        }
        this.tagLength = tagLength;
    }

    @Override
    protected int getHeaderLength() {
        return this.tagLength;
    }

    protected int getBaseTagLength() {
        return 5;
    }

    public int getStringOffset() {
        return this.stringOffset;
    }

    public String getStringValue() {
        return this.value;
    }
}

