/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser;

import java.io.IOException;
import org.apache.nifi.processors.evtx.parser.BinaryReader;

public abstract class Block {
    private final long offset;
    private final int initialPosition;
    private BinaryReader binaryReader;
    private boolean initialized = false;

    public Block(BinaryReader binaryReader) {
        this(binaryReader, binaryReader.getPosition());
    }

    public Block(BinaryReader binaryReader, long offset) {
        this.binaryReader = binaryReader;
        this.initialPosition = binaryReader.getPosition();
        this.offset = offset;
    }

    public BinaryReader getBinaryReader() {
        return this.binaryReader;
    }

    public long getOffset() {
        return this.offset;
    }

    protected void init(boolean clearBinaryReader) throws IOException {
        if (this.initialized) {
            throw new IOException("Initialize should only be called once");
        }
        this.initialized = true;
        int skipAmount = this.getHeaderLength() - (this.binaryReader.getPosition() - this.initialPosition);
        if (skipAmount > 0) {
            this.binaryReader.skip(skipAmount);
        }
        if (clearBinaryReader) {
            this.clearBinaryReader();
        }
    }

    protected void init() throws IOException {
        this.init(true);
    }

    protected void clearBinaryReader() {
        this.binaryReader = null;
    }

    protected int getHeaderLength() {
        return 0;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getInitialPosition() {
        return this.initialPosition;
    }
}

