/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser;

import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.Block;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.MalformedChunkException;
import org.apache.nifi.processors.evtx.parser.NumberUtil;

public class FileHeader
extends Block {
    public static final int CHUNK_SIZE = 65536;
    public static final String ELF_FILE = "ElfFile";
    private final String magicString;
    private final UnsignedLong oldestChunk;
    private final UnsignedLong currentChunkNumber;
    private final UnsignedLong nextRecordNumber;
    private final UnsignedInteger headerSize;
    private final int minorVersion;
    private final int majorVersion;
    private final int headerChunkSize;
    private final int chunkCount;
    private final String unused1;
    private final UnsignedInteger flags;
    private final UnsignedInteger checksum;
    private final InputStream inputStream;
    private final ComponentLog log;
    private long currentOffset;
    private int count = 1;

    public FileHeader(InputStream inputStream, ComponentLog log) throws IOException {
        super(new BinaryReader(inputStream, 4096));
        this.log = log;
        BinaryReader binaryReader = this.getBinaryReader();
        CRC32 crc32 = new CRC32();
        crc32.update(binaryReader.peekBytes(120));
        this.magicString = binaryReader.readString(8);
        if (!ELF_FILE.equals(this.magicString)) {
            throw new IOException("Invalid magic string. Expected ElfFile got " + this.magicString);
        }
        this.oldestChunk = binaryReader.readQWord();
        this.currentChunkNumber = binaryReader.readQWord();
        this.nextRecordNumber = binaryReader.readQWord();
        this.headerSize = binaryReader.readDWord();
        this.minorVersion = binaryReader.readWord();
        this.majorVersion = binaryReader.readWord();
        this.headerChunkSize = binaryReader.readWord();
        this.chunkCount = binaryReader.readWord();
        this.unused1 = binaryReader.readString(76);
        this.flags = binaryReader.readDWord();
        this.checksum = binaryReader.readDWord();
        if (crc32.getValue() != this.checksum.longValue()) {
            throw new IOException("Invalid checksum");
        }
        NumberUtil.intValueExpected(this.minorVersion, 1, "Invalid minor version.", new Object[0]);
        NumberUtil.intValueExpected(this.majorVersion, 3, "Invalid minor version.", new Object[0]);
        NumberUtil.intValueExpected(this.headerChunkSize, 4096, "Invalid header chunk size.", new Object[0]);
        this.inputStream = inputStream;
        this.currentOffset = 4096L;
        this.init();
    }

    @Override
    protected int getHeaderLength() {
        return 4096;
    }

    public String getMagicString() {
        return this.magicString;
    }

    public UnsignedLong getOldestChunk() {
        return this.oldestChunk;
    }

    public UnsignedLong getCurrentChunkNumber() {
        return this.currentChunkNumber;
    }

    public UnsignedLong getNextRecordNumber() {
        return this.nextRecordNumber;
    }

    public UnsignedInteger getHeaderSize() {
        return this.headerSize;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getHeaderChunkSize() {
        return this.headerChunkSize;
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    public String getUnused1() {
        return this.unused1;
    }

    public UnsignedInteger getFlags() {
        return this.flags;
    }

    public UnsignedInteger getChecksum() {
        return this.checksum;
    }

    public boolean hasNext() {
        return this.count <= this.chunkCount;
    }

    public ChunkHeader next() throws MalformedChunkException, IOException {
        if (this.count <= this.chunkCount) {
            long currentOffset = this.currentOffset;
            this.currentOffset += 65536L;
            BinaryReader binaryReader = new BinaryReader(this.inputStream, 65536);
            try {
                return new ChunkHeader(binaryReader, this.log, currentOffset, this.count++);
            }
            catch (IOException e) {
                throw new MalformedChunkException("Malformed chunk, unable to parse", e, currentOffset, this.count - 1, binaryReader.getBytes());
            }
        }
        return null;
    }
}

