/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.processors.evtx.RootNodeHandler;
import org.apache.nifi.processors.evtx.XmlBxmlNodeVisitor;
import org.apache.nifi.processors.evtx.XmlBxmlNodeVisitorFactory;
import org.apache.nifi.processors.evtx.parser.bxml.RootNode;

public class XmlRootNodeHandler
implements RootNodeHandler {
    public static final String EVENTS = "Events";
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private final XMLStreamWriter xmlStreamWriter;
    private final XmlBxmlNodeVisitorFactory xmlBxmlNodeVisitorFactory;

    public XmlRootNodeHandler(OutputStream outputStream) throws IOException {
        this(XmlRootNodeHandler.getXmlStreamWriter(new BufferedOutputStream(outputStream)), XmlBxmlNodeVisitor::new);
    }

    public XmlRootNodeHandler(XMLStreamWriter xmlStreamWriter, XmlBxmlNodeVisitorFactory xmlBxmlNodeVisitorFactory) throws IOException {
        this.xmlStreamWriter = xmlStreamWriter;
        this.xmlBxmlNodeVisitorFactory = xmlBxmlNodeVisitorFactory;
        try {
            this.xmlStreamWriter.writeStartDocument();
            try {
                this.xmlStreamWriter.writeStartElement(EVENTS);
            }
            catch (XMLStreamException e) {
                this.xmlStreamWriter.close();
                throw e;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private static XMLStreamWriter getXmlStreamWriter(OutputStream outputStream) throws IOException {
        try {
            return XML_OUTPUT_FACTORY.createXMLStreamWriter(outputStream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void handle(RootNode rootNode) throws IOException {
        this.xmlBxmlNodeVisitorFactory.create(this.xmlStreamWriter, rootNode);
    }

    @Override
    public void close() throws IOException {
        try {
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        finally {
            try {
                this.xmlStreamWriter.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
    }
}

