/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import com.google.common.primitives.UnsignedInteger;
import java.io.IOException;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.NumberUtil;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;

public class TemplateNode
extends BxmlNode {
    private final int nextOffset;
    private final UnsignedInteger templateId;
    private final String guid;
    private final int dataLength;

    public TemplateNode(BinaryReader binaryReader, ChunkHeader chunkHeader) throws IOException {
        super(binaryReader, chunkHeader, null);
        this.nextOffset = NumberUtil.intValueMax(binaryReader.readDWord(), Integer.MAX_VALUE, "Invalid offset.", new Object[0]);
        this.templateId = new BinaryReader(binaryReader, binaryReader.getPosition()).readDWord();
        this.guid = binaryReader.readGuid();
        this.dataLength = NumberUtil.intValueMax(binaryReader.readDWord(), 0x7FFFFFE7, "Data length too large.", new Object[0]);
        this.init();
    }

    public String toString() {
        return "TemplateNode{nextOffset=" + this.nextOffset + ", templateId=" + this.templateId + ", guid='" + this.guid + '\'' + ", dataLength=" + this.dataLength + '}';
    }

    public int getNextOffset() {
        return this.nextOffset;
    }

    public UnsignedInteger getTemplateId() {
        return this.templateId;
    }

    public String getGuid() {
        return this.guid;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public void accept(BxmlNodeVisitor bxmlNodeVisitor) throws IOException {
        bxmlNodeVisitor.visit(this);
    }
}

