/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.email;

import java.util.List;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.email.AbstractEmailProcessor;
import org.springframework.integration.mail.ImapMailReceiver;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Consumes messages from Email Server using IMAP protocol. The raw-bytes of each received email message are written as contents of the FlowFile")
@Tags(value={"Email", "Imap", "Get", "Ingest", "Ingress", "Message", "Consume"})
public class ConsumeIMAP
extends AbstractEmailProcessor<ImapMailReceiver> {
    public static final PropertyDescriptor SHOULD_MARK_READ = new PropertyDescriptor.Builder().name("Mark Messages as Read").description("Specify if messages should be marked as read after retrieval.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor USE_SSL = new PropertyDescriptor.Builder().name("Use SSL").description("Specifies if IMAP connection must be obtained via SSL encrypted connection (i.e., IMAPS)").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(ConsumeIMAP.getCommonPropertyDescriptors().stream(), Stream.of(SHOULD_MARK_READ, USE_SSL)).toList();

    @Override
    protected ImapMailReceiver buildMessageReceiver(ProcessContext processContext) {
        ImapMailReceiver receiver = new ImapMailReceiver(this.buildUrl(processContext));
        boolean shouldMarkAsRead = processContext.getProperty(SHOULD_MARK_READ).asBoolean();
        receiver.setShouldMarkMessagesAsRead(Boolean.valueOf(shouldMarkAsRead));
        receiver.setShouldDeleteMessages(processContext.getProperty(AbstractEmailProcessor.SHOULD_DELETE_MESSAGES).asBoolean().booleanValue());
        return receiver;
    }

    @Override
    protected String getProtocol(ProcessContext processContext) {
        return processContext.getProperty(USE_SSL).asBoolean() != false ? "imaps" : "imap";
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }
}

