/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.email;

import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileHandlingException;
import org.apache.nifi.stream.io.StreamUtils;

@SupportsBatching
@SideEffectFree
@Tags(value={"split", "email"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Extract attachments from a mime formatted email file, splitting them into individual flowfiles.")
@WritesAttributes(value={@WritesAttribute(attribute="filename ", description="The filename of the attachment"), @WritesAttribute(attribute="email.attachment.parent.filename ", description="The filename of the parent FlowFile"), @WritesAttribute(attribute="email.attachment.parent.uuid", description="The UUID of the original FlowFile."), @WritesAttribute(attribute="mime.type", description="The mime type of the attachment.")})
public class ExtractEmailAttachments
extends AbstractProcessor {
    public static final String ATTACHMENT_ORIGINAL_FILENAME = "email.attachment.parent.filename";
    public static final String ATTACHMENT_ORIGINAL_UUID = "email.attachment.parent.uuid";
    public static final Relationship REL_ATTACHMENTS = new Relationship.Builder().name("attachments").description("Each individual attachment will be routed to the attachments relationship").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original file").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that could not be parsed").build();
    private static final String ATTACHMENT_DISPOSITION = "attachment";
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_ATTACHMENTS, REL_ORIGINAL, REL_FAILURE);

    public void onTrigger(ProcessContext context, ProcessSession session) {
        ComponentLog logger = this.getLogger();
        FlowFile originalFlowFile = session.get();
        if (originalFlowFile == null) {
            return;
        }
        ArrayList attachmentsList = new ArrayList();
        ArrayList invalidFlowFilesList = new ArrayList();
        ArrayList originalFlowFilesList = new ArrayList();
        String requireStrictAddresses = "false";
        session.read(originalFlowFile, rawIn -> {
            try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                Properties props = new Properties();
                props.put("mail.mime.address.strict", "false");
                Session mailSession = Session.getInstance((Properties)props);
                MimeMessage originalMessage = new MimeMessage(mailSession, (InputStream)in);
                Address[] from = originalMessage.getFrom();
                if (from == null) {
                    throw new MessagingException("Message failed RFC-2822 validation: No Sender");
                }
                originalFlowFilesList.add(originalFlowFile);
                String originalFlowFileName = originalFlowFile.getAttribute(CoreAttributes.FILENAME.key());
                try {
                    ArrayList<DataSource> attachments = new ArrayList<DataSource>();
                    this.parseAttachments(attachments, (MimePart)originalMessage, 0);
                    for (DataSource data : attachments) {
                        String contentType;
                        FlowFile split = session.create(originalFlowFile);
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        String name = data.getName();
                        if (name != null && !name.isBlank()) {
                            attributes.put(CoreAttributes.FILENAME.key(), name);
                        }
                        if ((contentType = data.getContentType()) != null && !contentType.isBlank()) {
                            attributes.put(CoreAttributes.MIME_TYPE.key(), contentType);
                        }
                        String parentUuid = originalFlowFile.getAttribute(CoreAttributes.UUID.key());
                        attributes.put(ATTACHMENT_ORIGINAL_UUID, parentUuid);
                        attributes.put(ATTACHMENT_ORIGINAL_FILENAME, originalFlowFileName);
                        split = session.append(split, out -> StreamUtils.copy((InputStream)data.getInputStream(), (OutputStream)out));
                        split = session.putAllAttributes(split, attributes);
                        attachmentsList.add(split);
                    }
                }
                catch (FlowFileHandlingException e) {
                    session.remove((Collection)attachmentsList);
                    originalFlowFilesList.remove(originalFlowFile);
                    logger.error("Flowfile {} triggered error {} while processing message removing generated FlowFiles from sessions", new Object[]{originalFlowFile, e});
                    invalidFlowFilesList.add(originalFlowFile);
                }
            }
            catch (Exception e) {
                originalFlowFilesList.remove(originalFlowFile);
                logger.error("Could not parse the flowfile {} as an email, treating as failure", new Object[]{originalFlowFile, e});
                invalidFlowFilesList.add(originalFlowFile);
            }
        });
        session.transfer(attachmentsList, REL_ATTACHMENTS);
        session.transfer(invalidFlowFilesList, REL_FAILURE);
        session.transfer(originalFlowFilesList, REL_ORIGINAL);
        if (attachmentsList.size() > 10) {
            logger.info("Split {} into {} files", new Object[]{originalFlowFile, attachmentsList.size()});
        } else if (attachmentsList.size() > 1) {
            logger.info("Split {} into {} files: {}", new Object[]{originalFlowFile, attachmentsList.size(), attachmentsList});
        }
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    private void parseAttachments(List<DataSource> attachments, MimePart parentPart, int depth) throws MessagingException, IOException {
        String disposition = parentPart.getDisposition();
        Object parentContent = parentPart.getContent();
        if (parentContent instanceof Multipart) {
            Multipart multipart = (Multipart)parentContent;
            int count = multipart.getCount();
            int partDepth = depth + 1;
            for (int i = 0; i < count; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                if (!(bodyPart instanceof MimeBodyPart)) continue;
                MimeBodyPart mimeBodyPart = (MimeBodyPart)bodyPart;
                this.parseAttachments(attachments, (MimePart)mimeBodyPart, partDepth);
            }
        } else if (ATTACHMENT_DISPOSITION.equalsIgnoreCase(disposition) || depth > 0) {
            DataSource dataSource = parentPart.getDataHandler().getDataSource();
            attachments.add(dataSource);
        }
    }
}

