/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.elasticsearch.IndexOperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.ElasticsearchRestProcessor;
import org.apache.nifi.record.path.validation.RecordPathValidator;

public abstract class AbstractPutElasticsearch
extends AbstractProcessor
implements ElasticsearchRestProcessor {
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("All flowfiles that are sent to Elasticsearch without request failures go to this relationship.").build();
    public static final Relationship REL_SUCCESSFUL = new Relationship.Builder().name("successful").description("Record(s)/Flowfile(s) corresponding to Elasticsearch document(s) that did not result in an \"error\" (within Elasticsearch) will be routed here.").build();
    public static final Relationship REL_ERRORS = new Relationship.Builder().name("errors").description("Record(s)/Flowfile(s) corresponding to Elasticsearch document(s) that resulted in an \"error\" (within Elasticsearch) will be routed here.").build();
    static final Relationship REL_ERROR_RESPONSES = new Relationship.Builder().name("error_responses").description("Elasticsearch _bulk API responses marked as \"error\" go here (and optionally \"not_found\" when \"Treat \"Not Found\" as Success\" is \"true\").").build();
    static final PropertyDescriptor OUTPUT_ERROR_RESPONSES = new PropertyDescriptor.Builder().name("Output Error Responses").description("If this is enabled, response messages from Elasticsearch marked as \"error\" will be output to the \"" + REL_ERROR_RESPONSES.getName() + "\" relationship.This does not impact the output of flowfiles to the \"" + REL_SUCCESSFUL.getName() + "\" or \"" + REL_ERRORS.getName() + "\" relationships").allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The preferred number of FlowFiles to send over in a single batch").defaultValue("100").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).build();
    public static final PropertyDescriptor INDEX_OP = new PropertyDescriptor.Builder().name("Index Operation").description("The type of the operation used to index (create, delete, index, update, upsert)").addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(IndexOperationRequest.Operation.Index.getValue()).required(true).build();
    static final PropertyDescriptor NOT_FOUND_IS_SUCCESSFUL = new PropertyDescriptor.Builder().name("Treat Not Found as Success").description("If true, \"not_found\" Elasticsearch Document associated Records will be routed to the \"" + REL_SUCCESSFUL.getName() + "\" relationship, otherwise to the \"" + REL_ERRORS.getName() + "\" relationship. If " + OUTPUT_ERROR_RESPONSES.getDisplayName() + " is \"true\" then \"not_found\" responses from Elasticsearch will be sent to the " + REL_ERROR_RESPONSES.getName() + " relationship.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("true").required(false).build();
    static final List<String> ALLOWED_INDEX_OPERATIONS = Stream.of(IndexOperationRequest.Operation.values()).map(operation -> operation.getValue().toLowerCase()).toList();
    private final AtomicReference<Set<Relationship>> relationships = new AtomicReference<Set<Relationship>>(this.getBaseRelationships());
    static final String BULK_HEADER_PREFIX = "BULK:";
    boolean logErrors;
    boolean outputErrorResponses;
    boolean notFoundIsSuccessful;
    ObjectMapper mapper;
    ObjectMapper errorMapper;
    final AtomicReference<ElasticSearchClientService> clientService = new AtomicReference<Object>(null);

    abstract Set<Relationship> getBaseRelationships();

    public Set<Relationship> getRelationships() {
        return this.relationships.get();
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        ElasticsearchRestProcessor.super.migrateProperties(config);
        config.renameProperty("put-es-output-error-responses", OUTPUT_ERROR_RESPONSES.getName());
        config.renameProperty("put-es-record-batch-size", BATCH_SIZE.getName());
        config.renameProperty("put-es-record-index-op", INDEX_OP.getName());
        config.renameProperty("put-es-not_found-is-error", NOT_FOUND_IS_SUCCESSFUL.getName());
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true);
        if (propertyDescriptorName.startsWith(BULK_HEADER_PREFIX)) {
            builder.addValidator((Validator)new RecordPathValidator());
        } else {
            builder.addValidator(StandardValidators.NON_EMPTY_VALIDATOR);
        }
        return builder.build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (OUTPUT_ERROR_RESPONSES.equals((Object)descriptor)) {
            HashSet<Relationship> newRelationships = new HashSet<Relationship>(this.getBaseRelationships());
            if (Boolean.parseBoolean(newValue)) {
                newRelationships.add(REL_ERROR_RESPONSES);
            }
            this.relationships.set(newRelationships);
        }
    }

    @Override
    public boolean isIndexNotExistSuccessful() {
        return true;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientService.set((ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class));
        this.logErrors = context.getProperty(LOG_ERROR_RESPONSES).asBoolean();
        this.outputErrorResponses = context.getProperty(OUTPUT_ERROR_RESPONSES).asBoolean();
        this.mapper = this.buildObjectMapper(context);
        if (this.errorMapper == null && (this.outputErrorResponses || this.logErrors || this.getLogger().isDebugEnabled())) {
            this.errorMapper = this.buildObjectMapper(context);
            this.errorMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    @OnStopped
    public void onStopped() {
        this.clientService.set(null);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        PropertyValue indexOp = validationContext.getProperty(INDEX_OP);
        ValidationResult.Builder indexOpValidationResult = new ValidationResult.Builder().subject(INDEX_OP.getName());
        if (!indexOp.isExpressionLanguagePresent()) {
            String indexOpValue = indexOp.evaluateAttributeExpressions().getValue();
            indexOpValidationResult.input(indexOpValue);
            if (!ALLOWED_INDEX_OPERATIONS.contains(indexOpValue.toLowerCase())) {
                indexOpValidationResult.valid(false).explanation(String.format("%s must be Expression Language or one of %s", INDEX_OP.getDisplayName(), ALLOWED_INDEX_OPERATIONS));
            } else {
                indexOpValidationResult.valid(true);
            }
        } else {
            indexOpValidationResult.valid(true).input(indexOp.getValue()).explanation("Expression Language present");
        }
        validationResults.add(indexOpValidationResult.build());
        return validationResults;
    }

    @Override
    public List<ConfigVerificationResult> verifyAfterIndex(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes, ElasticSearchClientService verifyClientService, String index, boolean indexExists, ObjectMapper mapper) {
        return Collections.emptyList();
    }

    Map<String, String> getRequestURLParameters(Map<String, String> dynamicProperties) {
        return dynamicProperties.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith(BULK_HEADER_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    Map<String, String> getBulkHeaderParameters(Map<String, String> dynamicProperties) {
        return dynamicProperties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(BULK_HEADER_PREFIX)).collect(Collectors.toMap(e -> ((String)e.getKey()).replace(BULK_HEADER_PREFIX, "").trim(), Map.Entry::getValue));
    }

    void transferFlowFilesOnException(Exception ex, Relationship rel, ProcessSession session, boolean penalize, FlowFile ... flowFiles) {
        for (FlowFile flowFile : flowFiles) {
            flowFile = session.putAttribute(flowFile, "elasticsearch.put.error", ex.getMessage() == null ? "null" : ex.getMessage());
            if (penalize) {
                session.penalize(flowFile);
            }
            session.transfer(flowFile, rel);
        }
    }

    void handleElasticsearchDocumentErrors(Map<Integer, Map<String, Object>> errors, ProcessSession session, FlowFile parent) throws IOException {
        if (!errors.isEmpty() && (this.outputErrorResponses || this.logErrors || this.getLogger().isDebugEnabled())) {
            if (this.logErrors || this.getLogger().isDebugEnabled()) {
                String output = String.format("An error was encountered while processing bulk operations. Server response below:%n%n%s", this.errorMapper.writeValueAsString(errors.values()));
                if (this.logErrors) {
                    this.getLogger().error(output);
                } else {
                    this.getLogger().debug(output);
                }
            }
            if (this.outputErrorResponses) {
                FlowFile errorResponsesFF = null;
                try {
                    errorResponsesFF = session.create(parent);
                    try (OutputStream errorsOutputStream = session.write(errorResponsesFF);){
                        this.errorMapper.writeValue(errorsOutputStream, errors.values());
                    }
                    errorResponsesFF = session.putAttribute(errorResponsesFF, "elasticsearch.put.error.count", String.valueOf(errors.size()));
                    session.transfer(errorResponsesFF, REL_ERROR_RESPONSES);
                }
                catch (IOException ex) {
                    this.getLogger().error("Unable to write error responses", (Throwable)ex);
                    session.remove(errorResponsesFF);
                    throw ex;
                }
            }
        }
    }

    Predicate<Map<String, Object>> isElasticsearchError() {
        return inner -> inner.containsKey("error");
    }

    Predicate<Map<String, Object>> isElasticsearchNotFound() {
        return inner -> inner.containsKey("result") && "not_found".equals(inner.get("result"));
    }

    final Map<Integer, Map<String, Object>> findElasticsearchResponseErrors(IndexOperationResponse response) {
        LinkedHashMap<Integer, Map<String, Object>> errors = new LinkedHashMap<Integer, Map<String, Object>>(response.getItems() == null ? 0 : response.getItems().size(), 1.0f);
        ArrayList<Predicate<Map<String, Object>>> errorItemFilters = new ArrayList<Predicate<Map<String, Object>>>(2);
        if (response.hasErrors()) {
            errorItemFilters.add(this.isElasticsearchError());
        }
        if (!this.notFoundIsSuccessful) {
            errorItemFilters.add(this.isElasticsearchNotFound());
        }
        if (response.getItems() != null && !errorItemFilters.isEmpty()) {
            for (int index = 0; index < response.getItems().size(); ++index) {
                String key;
                Map inner;
                Map current = (Map)response.getItems().get(index);
                if (current.isEmpty() || (inner = (Map)current.get(key = (String)current.keySet().stream().findFirst().orElse(null))) == null || !errorItemFilters.stream().anyMatch(p -> p.test(inner))) continue;
                errors.put(index, inner);
            }
        }
        return errors;
    }
}

