/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch.api;

import java.util.EnumSet;
import org.apache.nifi.components.DescribedValue;

public enum ResultOutputStrategy implements DescribedValue
{
    PER_HIT("splitUp-yes", "Flowfile per hit."),
    PER_RESPONSE("splitUp-no", "Flowfile per response."),
    PER_QUERY("splitUp-query", "Combine results from all query responses (one flowfile per entire paginated result set of hits). Note that aggregations cannot be paged, they are generated across the entire result set and returned as part of the first page. Results are output with one JSON object per line (allowing hits to be combined from multiple pages without loading all results into memory).");

    private final String value;
    private final String description;

    private ResultOutputStrategy(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public static EnumSet<ResultOutputStrategy> getNonPaginatedResponseOutputStrategies() {
        return EnumSet.of(PER_RESPONSE, PER_HIT);
    }
}

