/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.ElasticsearchRequestOptions;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.elasticsearch.AbstractJsonQueryElasticsearch;
import org.apache.nifi.processors.elasticsearch.PaginatedJsonQueryElasticsearch;
import org.apache.nifi.processors.elasticsearch.api.JsonQueryParameters;
import org.apache.nifi.util.StopWatch;

@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="application/json"), @WritesAttribute(attribute="aggregation.name", description="The name of the aggregation whose results are in the output flowfile"), @WritesAttribute(attribute="aggregation.number", description="The number of the aggregation whose results are in the output flowfile"), @WritesAttribute(attribute="hit.count", description="The number of hits that are in the output flowfile"), @WritesAttribute(attribute="elasticsearch.query.error", description="The error message provided by Elasticsearch if there is an error querying the index.")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@SupportsBatching
@Tags(value={"elasticsearch", "elasticsearch7", "elasticsearch8", "elasticsearch9", "query", "read", "get", "json"})
@CapabilityDescription(value="A processor that allows the user to run a query (with aggregations) written with the Elasticsearch JSON DSL. It does not automatically paginate queries for the user. If an incoming relationship is added to this processor, it will use the flowfile's content for the query. Care should be taken on the size of the query because the entire response from Elasticsearch will be loaded into memory all at once and converted into the resulting flowfiles.")
@SeeAlso(value={PaginatedJsonQueryElasticsearch.class})
@DynamicProperties(value={@DynamicProperty(name="The name of the HTTP request header", value="A Record Path expression to retrieve the HTTP request header value", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Prefix: HEADER: - adds the specified property name/value as a HTTP request header in the Elasticsearch request. If the Record Path expression results in a null or blank value, the HTTP request header will be omitted."), @DynamicProperty(name="The name of a URL query parameter to add", value="The value of the URL query parameter", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Adds the specified property name/value as a query parameter in the Elasticsearch URL used for processing. These parameters will override any matching parameters in the query request body")})
public class JsonQueryElasticsearch
extends AbstractJsonQueryElasticsearch<JsonQueryParameters> {
    @Override
    JsonQueryParameters buildJsonQueryParameters(FlowFile input, ProcessContext context, ProcessSession session) throws IOException {
        JsonQueryParameters jsonQueryParameters = new JsonQueryParameters();
        this.populateCommonJsonQueryParameters(jsonQueryParameters, input, context, session);
        return jsonQueryParameters;
    }

    @Override
    SearchResponse doQuery(JsonQueryParameters queryJsonParameters, List<FlowFile> hitsFlowFiles, ProcessSession session, ProcessContext context, FlowFile input, StopWatch stopWatch) throws IOException {
        SearchResponse response = ((ElasticSearchClientService)this.clientService.get()).search(queryJsonParameters.getQuery(), queryJsonParameters.getIndex(), queryJsonParameters.getType(), new ElasticsearchRequestOptions(this.getRequestParametersFromDynamicProperties(context, input), this.getRequestHeadersFromDynamicProperties(context, input)));
        if (input != null) {
            session.getProvenanceReporter().send(input, ((ElasticSearchClientService)this.clientService.get()).getTransitUrl(queryJsonParameters.getIndex(), queryJsonParameters.getType()), stopWatch.getElapsed(TimeUnit.MILLISECONDS));
        }
        this.handleResponse(response, true, queryJsonParameters, hitsFlowFiles, session, input, stopWatch);
        return response;
    }

    @Override
    void finishQuery(FlowFile input, JsonQueryParameters jsonQueryParameters, ProcessSession session, ProcessContext context, SearchResponse response) {
        if (input != null) {
            session.transfer(input, REL_ORIGINAL);
        }
    }
}

