/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.ElasticsearchError;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.ElasticsearchRestProcessor;
import org.apache.nifi.processors.elasticsearch.api.BulkOperation;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.util.StringUtils;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"json", "elasticsearch", "elasticsearch5", "elasticsearch6", "put", "index", "record"})
@CapabilityDescription(value="A record-aware Elasticsearch put processor that uses the official Elastic REST client libraries.")
public class PutElasticsearchRecord
extends AbstractProcessor
implements ElasticsearchRestProcessor {
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("put-es-record-reader").displayName("Record Reader").description("The record reader to use for reading incoming records from flowfiles.").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("put-es-record-batch-size").displayName("Batch Size").description("The number of records to send over in a single batch.").defaultValue("100").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    static final PropertyDescriptor ID_RECORD_PATH = new PropertyDescriptor.Builder().name("put-es-record-id-path").displayName("ID Record Path").description("A record path expression to retrieve the ID field for use with Elasticsearch. If left blank the ID will be automatically generated by Elasticsearch.").addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor INDEX_RECORD_PATH = new PropertyDescriptor.Builder().name("put-es-record-index-record-path").displayName("Index Record Path").description("A record path expression to retrieve the index field for use with Elasticsearch. If left blank the index will be determined using the main index property.").addValidator((Validator)new RecordPathValidator()).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor TYPE_RECORD_PATH = new PropertyDescriptor.Builder().name("put-es-record-type-record-path").displayName("Type Record Path").description("A record path expression to retrieve the type field for use with Elasticsearch. If left blank the type will be determined using the main type property.").addValidator((Validator)new RecordPathValidator()).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor ERROR_RECORD_WRITER = new PropertyDescriptor.Builder().name("put-es-record-error-writer").displayName("Error Record Writer").description("If this configuration property is set, the response from Elasticsearch will be examined for failed records and the failed records will be written to a record set with this record writer service and sent to the \"errors\" relationship.").identifiesControllerService(RecordSetWriterFactory.class).addValidator(Validator.VALID).required(false).build();
    static final List<PropertyDescriptor> DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(INDEX, TYPE, CLIENT_SERVICE, RECORD_READER, BATCH_SIZE, ID_RECORD_PATH, INDEX_RECORD_PATH, TYPE_RECORD_PATH, LOG_ERROR_RESPONSES, ERROR_RECORD_WRITER));
    static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE, REL_RETRY, REL_FAILED_RECORDS)));
    private RecordReaderFactory readerFactory;
    private RecordPathCache recordPathCache;
    private ElasticSearchClientService clientService;
    private RecordSetWriterFactory writerFactory;
    private boolean logErrors;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        this.clientService = (ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class);
        this.recordPathCache = new RecordPathCache(16);
        this.writerFactory = (RecordSetWriterFactory)context.getProperty(ERROR_RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        this.logErrors = context.getProperty(LOG_ERROR_RESPONSES).asBoolean();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile input = session.get();
        if (input == null) {
            return;
        }
        String index = context.getProperty(INDEX).evaluateAttributeExpressions(input).getValue();
        String type = context.getProperty(TYPE).evaluateAttributeExpressions(input).getValue();
        String idPath = context.getProperty(ID_RECORD_PATH).isSet() ? context.getProperty(ID_RECORD_PATH).evaluateAttributeExpressions(input).getValue() : null;
        String indexPath = context.getProperty(INDEX_RECORD_PATH).isSet() ? context.getProperty(INDEX_RECORD_PATH).evaluateAttributeExpressions(input).getValue() : null;
        String typePath = context.getProperty(TYPE_RECORD_PATH).isSet() ? context.getProperty(TYPE_RECORD_PATH).evaluateAttributeExpressions(input).getValue() : null;
        RecordPath path = idPath != null ? this.recordPathCache.getCompiled(idPath) : null;
        RecordPath iPath = indexPath != null ? this.recordPathCache.getCompiled(indexPath) : null;
        RecordPath tPath = typePath != null ? this.recordPathCache.getCompiled(typePath) : null;
        int batchSize = context.getProperty(BATCH_SIZE).evaluateAttributeExpressions(input).asInteger();
        ArrayList<FlowFile> badRecords = new ArrayList<FlowFile>();
        try (InputStream inStream = session.read(input);
             RecordReader reader = this.readerFactory.createRecordReader(input, inStream, this.getLogger());){
            BulkOperation bundle;
            FlowFile bad;
            Record record;
            ArrayList<IndexOperationRequest> operationList = new ArrayList<IndexOperationRequest>();
            ArrayList<Record> originals = new ArrayList<Record>();
            while ((record = reader.nextRecord()) != null) {
                String idx = this.getFromRecordPath(record, iPath, index);
                String t = this.getFromRecordPath(record, tPath, type);
                IndexOperationRequest.Operation o = IndexOperationRequest.Operation.Index;
                String id = path != null ? this.getFromRecordPath(record, path, null) : null;
                Map contentMap = (Map)DataTypeUtils.convertRecordFieldtoObject((Object)record, (DataType)RecordFieldType.RECORD.getRecordDataType(record.getSchema()));
                this.removeEmpty(contentMap);
                operationList.add(new IndexOperationRequest(idx, t, id, contentMap, o));
                originals.add(record);
                if (operationList.size() != batchSize) continue;
                BulkOperation bundle2 = new BulkOperation(operationList, originals, reader.getSchema());
                FlowFile bad2 = this.indexDocuments(bundle2, session, input);
                if (bad2 != null) {
                    badRecords.add(bad2);
                }
                operationList.clear();
                originals.clear();
            }
            if (operationList.size() > 0 && (bad = this.indexDocuments(bundle = new BulkOperation(operationList, originals, reader.getSchema()), session, input)) != null) {
                badRecords.add(bad);
            }
        }
        catch (ElasticsearchError ese) {
            String msg = String.format("Encountered a server-side problem with Elasticsearch. %s", ese.isElastic() ? "Moving to retry." : "Moving to failure");
            this.getLogger().error(msg, (Throwable)ese);
            Relationship rel = ese.isElastic() ? REL_RETRY : REL_FAILURE;
            session.penalize(input);
            session.transfer(input, rel);
            this.removeBadRecordFlowFiles(badRecords, session);
            return;
        }
        catch (Exception ex) {
            this.getLogger().error("Could not index documents.", (Throwable)ex);
            session.transfer(input, REL_FAILURE);
            this.removeBadRecordFlowFiles(badRecords, session);
            return;
        }
        session.transfer(input, REL_SUCCESS);
    }

    private void removeBadRecordFlowFiles(List<FlowFile> bad, ProcessSession session) {
        for (FlowFile badFlowFile : bad) {
            session.remove(badFlowFile);
        }
        bad.clear();
    }

    /*
     * Exception decompiling
     */
    private FlowFile indexDocuments(BulkOperation bundle, ProcessSession session, FlowFile input) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeEmpty(Map<String, Object> input) {
        HashMap<String, Object> copy = new HashMap<String, Object>(input);
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            if (entry.getValue() == null) {
                copy.remove(entry.getKey());
                continue;
            }
            if (StringUtils.isBlank((String)entry.getValue().toString())) {
                copy.remove(entry.getKey());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                this.removeEmpty((Map)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            for (Object value : (List)entry.getValue()) {
                if (!(value instanceof Map)) continue;
                this.removeEmpty((Map)value);
            }
        }
        input.clear();
        input.putAll(copy);
    }

    private String getFromRecordPath(Record record, RecordPath path, String fallback) {
        if (path == null) {
            return fallback;
        }
        RecordPathResult result = path.evaluate(record);
        Optional value = result.getSelectedFields().findFirst();
        if (value.isPresent() && ((FieldValue)value.get()).getValue() != null) {
            FieldValue fieldValue = (FieldValue)value.get();
            if (!fieldValue.getField().getDataType().getFieldType().equals((Object)RecordFieldType.STRING)) {
                throw new ProcessException(String.format("Field referenced by %s must be a string.", path.getPath()));
            }
            fieldValue.updateValue(null);
            String retVal = fieldValue.getValue().toString();
            return retVal;
        }
        return fallback;
    }
}

