/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import java.util.List;
import java.util.Map;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.elasticsearch.AuthorizationScheme;
import org.apache.nifi.elasticsearch.DeleteOperationResponse;
import org.apache.nifi.elasticsearch.ElasticsearchRequestOptions;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.elasticsearch.IndexOperationResponse;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.elasticsearch.UpdateOperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.ssl.SSLContextProvider;

public interface ElasticSearchClientService
extends ControllerService,
VerifiableControllerService {
    public static final PropertyDescriptor HTTP_HOSTS = new PropertyDescriptor.Builder().name("HTTP Hosts").description("A comma-separated list of HTTP hosts that host Elasticsearch query nodes.\nThe HTTP Hosts should be valid URIs including protocol, domain and port for each entry.\nFor example \"https://elasticsearch1:9200, https://elasticsearch2:9200\".\nNote that the Host is included in requests as a header (typically including domain and port, e.g. elasticsearch:9200).\n").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROP_SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections. This service only applies if the Elasticsearch endpoint(s) have been secured with TLS/SSL.").required(false).identifiesControllerService(SSLContextProvider.class).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])new ProxySpec[]{ProxySpec.HTTP});
    public static final PropertyDescriptor AUTHORIZATION_SCHEME = new PropertyDescriptor.Builder().name("Authorization Scheme").description("Authorization Scheme used for optional authentication to Elasticsearch.").allowableValues(AuthorizationScheme.class).defaultValue((DescribedValue)AuthorizationScheme.BASIC).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor OAUTH2_ACCESS_TOKEN_PROVIDER = new PropertyDescriptor.Builder().name("OAuth2 Access Token Provider").description("The OAuth2 Access Token Provider used to provide JWTs for Bearer Token Authorization with Elasticsearch.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.JWT, new DescribedValue[0]).required(true).identifiesControllerService(OAuth2AccessTokenProvider.class).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor JWT_SHARED_SECRET = new PropertyDescriptor.Builder().name("JWT Shared Secret").description("JWT realm Shared Secret.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.JWT, new DescribedValue[0]).required(true).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor RUN_AS_USER = new PropertyDescriptor.Builder().name("Run As User").description("The username to impersonate within Elasticsearch.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("The username to use with XPack security.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.BASIC, new DescribedValue[0]).required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password to use with XPack security.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.BASIC, new DescribedValue[0]).required(true).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor API_KEY_ID = new PropertyDescriptor.Builder().name("API Key ID").description("Unique identifier of the API key.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.API_KEY, new DescribedValue[0]).required(true).sensitive(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor API_KEY = new PropertyDescriptor.Builder().name("API Key").description("Encoded API key.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.API_KEY, new DescribedValue[0]).required(true).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connect Timeout").description("Controls the amount of time, in milliseconds, before a timeout occurs when trying to connect.").required(true).defaultValue("5000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor SOCKET_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").description("Controls the amount of time, in milliseconds, before a timeout occurs when waiting for a response.").required(true).defaultValue("60000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("Character Set").description("The charset to use for interpreting the response from Elasticsearch.").required(true).defaultValue("UTF-8").addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final AllowableValue ALWAYS_SUPPRESS = new AllowableValue("always-suppress", "Always Suppress", "Fields that are missing (present in the schema but not in the record), or that have a value of null/empty, will not be written out");
    public static final AllowableValue NEVER_SUPPRESS = new AllowableValue("never-suppress", "Never Suppress", "Fields that are missing (present in the schema but not in the record), or that have a value of null/empty, will be written out as a null/empty value");
    public static final PropertyDescriptor SUPPRESS_NULLS = new PropertyDescriptor.Builder().name("Suppress Null and Empty Values").description("Specifies how the writer should handle null and empty fields (including objects and arrays)").allowableValues(new DescribedValue[]{NEVER_SUPPRESS, ALWAYS_SUPPRESS}).defaultValue((DescribedValue)ALWAYS_SUPPRESS).required(true).build();
    public static final PropertyDescriptor COMPRESSION = new PropertyDescriptor.Builder().name("Enable Compression").description("Whether the REST client should compress requests using gzip content encoding and add the \"Accept-Encoding: gzip\" header to receive compressed responses").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor SEND_META_HEADER = new PropertyDescriptor.Builder().name("Send Meta Header").description("Whether to send a \"X-Elastic-Client-Meta\" header that describes the runtime environment. It contains information that is similar to what could be found in User-Agent. Using a separate header allows applications to use User-Agent for their own needs, e.g. to identify application version or other environment information").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final PropertyDescriptor STRICT_DEPRECATION = new PropertyDescriptor.Builder().name("Strict Deprecation").description("Whether the REST client should return any response containing at least one warning header as a failure").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final AllowableValue NODE_SELECTOR_ANY = new AllowableValue("ANY", "Any", "Select any Elasticsearch node to handle requests");
    public static final AllowableValue NODE_SELECTOR_SKIP_DEDICATED_MASTERS = new AllowableValue("SKIP_DEDICATED_MASTERS", "Skip Dedicated Masters", "Skip dedicated Elasticsearch master nodes for handling request");
    public static final PropertyDescriptor NODE_SELECTOR = new PropertyDescriptor.Builder().name("Node Selector").description("Selects Elasticsearch nodes that can receive requests. Used to keep requests away from dedicated Elasticsearch master nodes").allowableValues(new DescribedValue[]{NODE_SELECTOR_ANY, NODE_SELECTOR_SKIP_DEDICATED_MASTERS}).defaultValue((DescribedValue)NODE_SELECTOR_ANY).required(true).build();
    public static final PropertyDescriptor PATH_PREFIX = new PropertyDescriptor.Builder().name("Path Prefix").description("Sets the path's prefix for every request used by the http client. For example, if this is set to \"/my/path\", then any client request will become \"/my/path/\" + endpoint. In essence, every request's endpoint is prefixed by this pathPrefix. The path prefix is useful for when Elasticsearch is behind a proxy that provides a base path or a proxy that requires all paths to start with '/'; it is not intended for other purposes and it should not be supplied in other scenarios").addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor SNIFF_CLUSTER_NODES = new PropertyDescriptor.Builder().name("Sniff Cluster Nodes").description("Periodically sniff for nodes within the Elasticsearch cluster via the Elasticsearch Node Info API. If Elasticsearch security features are enabled (default to \"true\" for 8.x+), the Elasticsearch user must have the \"monitor\" or \"manage\" cluster privilege to use this API.Note that all " + HTTP_HOSTS.getDisplayName() + " (and those that may be discovered within the cluster using the Sniffer) must use the same protocol, e.g. http or https, and be contactable using the same client settings. Finally the Elasticsearch \"network.publish_host\" must match one of the \"network.bind_host\" list entries see https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-network.html for more information").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor SNIFF_ON_FAILURE = new PropertyDescriptor.Builder().name("Sniff on Failure").description("Enable sniffing on failure, meaning that after each failure the Elasticsearch nodes list gets updated straight away rather than at the following ordinary sniffing round").dependsOn(SNIFF_CLUSTER_NODES, "true", new String[0]).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor SNIFFER_INTERVAL = new PropertyDescriptor.Builder().name("Sniffer Interval").description("Interval between Cluster sniffer operations").dependsOn(SNIFF_CLUSTER_NODES, "true", new String[0]).defaultValue("5 mins").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).build();
    public static final PropertyDescriptor SNIFFER_REQUEST_TIMEOUT = new PropertyDescriptor.Builder().name("Sniffer Request Timeout").description("Cluster sniffer timeout for node info requests").dependsOn(SNIFF_CLUSTER_NODES, "true", new String[0]).defaultValue("1 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).build();
    public static final PropertyDescriptor SNIFFER_FAILURE_DELAY = new PropertyDescriptor.Builder().name("Sniffer Failure Delay").description("Delay between an Elasticsearch request failure and updating available Cluster nodes using the Sniffer").dependsOn(SNIFF_ON_FAILURE, "true", new String[0]).defaultValue("1 min").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).build();

    default public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("el-cs-http-hosts", HTTP_HOSTS.getName());
        config.renameProperty("el-cs-ssl-context-service", PROP_SSL_CONTEXT_SERVICE.getName());
        config.renameProperty("authorization-scheme", AUTHORIZATION_SCHEME.getName());
        config.renameProperty("el-cs-oauth2-token-provider", OAUTH2_ACCESS_TOKEN_PROVIDER.getName());
        config.renameProperty("jwt-shared-secret", JWT_SHARED_SECRET.getName());
        config.renameProperty("el-cs-run-as-user", RUN_AS_USER.getName());
        config.renameProperty("el-cs-username", USERNAME.getName());
        config.renameProperty("el-cs-password", PASSWORD.getName());
        config.renameProperty("api-key-id", API_KEY_ID.getName());
        config.renameProperty("api-key", API_KEY.getName());
        List.of("el-cs-connect-timeout", "Connect timeout").forEach(obsoletePropertyName -> config.renameProperty(obsoletePropertyName, CONNECT_TIMEOUT.getName()));
        config.renameProperty("el-cs-socket-timeout", SOCKET_TIMEOUT.getName());
        config.renameProperty("el-cs-charset", CHARSET.getName());
        config.renameProperty("el-cs-suppress-nulls", SUPPRESS_NULLS.getName());
        config.renameProperty("el-cs-enable-compression", COMPRESSION.getName());
        config.renameProperty("el-cs-send-meta-header", SEND_META_HEADER.getName());
        config.renameProperty("el-cs-strict-deprecation", STRICT_DEPRECATION.getName());
        config.renameProperty("el-cs-node-selector", NODE_SELECTOR.getName());
        config.renameProperty("el-cs-path-prefix", PATH_PREFIX.getName());
        config.renameProperty("el-cs-sniff-cluster-nodes", SNIFF_CLUSTER_NODES.getName());
        config.renameProperty("el-cs-sniff-failure", SNIFF_ON_FAILURE.getName());
        config.renameProperty("el-cs-sniffer-interval", SNIFFER_INTERVAL.getName());
        config.renameProperty("el-cs-sniffer-request-timeout", SNIFFER_REQUEST_TIMEOUT.getName());
        config.renameProperty("el-cs-sniffer-failure-delay", SNIFFER_FAILURE_DELAY.getName());
        config.renameProperty("proxy-configuration-service", PROXY_CONFIGURATION_SERVICE.getName());
    }

    public IndexOperationResponse add(IndexOperationRequest var1, ElasticsearchRequestOptions var2);

    public IndexOperationResponse bulk(List<IndexOperationRequest> var1, ElasticsearchRequestOptions var2);

    public Long count(String var1, String var2, String var3, ElasticsearchRequestOptions var4);

    public DeleteOperationResponse deleteById(String var1, String var2, String var3, ElasticsearchRequestOptions var4);

    public DeleteOperationResponse deleteById(String var1, String var2, List<String> var3, ElasticsearchRequestOptions var4);

    public DeleteOperationResponse deleteByQuery(String var1, String var2, String var3, ElasticsearchRequestOptions var4);

    public UpdateOperationResponse updateByQuery(String var1, String var2, String var3, ElasticsearchRequestOptions var4);

    public void refresh(String var1, ElasticsearchRequestOptions var2);

    public boolean exists(String var1, ElasticsearchRequestOptions var2);

    public boolean documentExists(String var1, String var2, String var3, ElasticsearchRequestOptions var4);

    public Map<String, Object> get(String var1, String var2, String var3, ElasticsearchRequestOptions var4);

    public SearchResponse search(String var1, String var2, String var3, ElasticsearchRequestOptions var4);

    public SearchResponse scroll(String var1, ElasticsearchRequestOptions var2);

    public String initialisePointInTime(String var1, String var2, ElasticsearchRequestOptions var3);

    public DeleteOperationResponse deletePointInTime(String var1, ElasticsearchRequestOptions var2);

    public DeleteOperationResponse deleteScroll(String var1, ElasticsearchRequestOptions var2);

    public String getTransitUrl(String var1, String var2);
}

