/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import java.util.Set;

public class ElasticsearchException
extends RuntimeException {
    public static final Set<String> ELASTIC_ERROR_NAMES = Set.of("NoNodeAvailableException", "ElasticsearchTimeoutException", "ReceiveTimeoutTransportException", "NodeClosedException");
    protected boolean elastic;
    protected boolean notFound;

    public ElasticsearchException(Exception ex) {
        super(ex);
        boolean isServiceUnavailable;
        boolean isKnownException = ELASTIC_ERROR_NAMES.contains(ex.getClass().getSimpleName());
        if ("ResponseException".equals(ex.getClass().getSimpleName())) {
            isServiceUnavailable = ex.getMessage().contains("503 Service Unavailable");
            this.notFound = ex.getMessage().contains("404 Not Found");
        } else {
            isServiceUnavailable = false;
        }
        this.elastic = isKnownException || isServiceUnavailable;
    }

    public boolean isElastic() {
        return this.elastic;
    }

    public boolean isNotFound() {
        return this.notFound;
    }
}

