/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.nifi.elasticsearch.OperationResponse;

public class IndexOperationResponse
implements OperationResponse {
    private final long took;
    private boolean hasErrors;
    private List<Map<String, Object>> items;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public IndexOperationResponse(long took) {
        this.took = took;
    }

    @Override
    public long getTook() {
        return this.took;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public static IndexOperationResponse fromJsonResponse(String response) throws IOException {
        Map parsedResponse = (Map)OBJECT_MAPPER.readValue(response, Map.class);
        long took = Long.parseLong(String.valueOf(parsedResponse.get("took")));
        boolean hasErrors = (Boolean)parsedResponse.get("errors");
        List items = (List)parsedResponse.get("items");
        IndexOperationResponse retVal = new IndexOperationResponse(took);
        retVal.hasErrors = hasErrors;
        retVal.items = items;
        return retVal;
    }

    public List<Map<String, Object>> getItems() {
        return this.items;
    }

    public String toString() {
        return "IndexOperationResponse{took=" + this.took + ", hasErrors=" + this.hasErrors + ", items=" + String.valueOf(this.items) + "}";
    }
}

