/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.dropbox;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.DbxUserListFolderBuilder;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListFolderResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.ProxyServiceMigration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.dropbox.DropboxFileInfo;
import org.apache.nifi.processors.dropbox.DropboxFlowFileAttribute;
import org.apache.nifi.processors.dropbox.DropboxTrait;
import org.apache.nifi.processors.dropbox.FetchDropbox;
import org.apache.nifi.processors.dropbox.PutDropbox;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.serialization.record.RecordSchema;

@PrimaryNodeOnly
@TriggerSerially
@Tags(value={"dropbox", "storage"})
@CapabilityDescription(value="Retrieves a listing of files from Dropbox (shortcuts are ignored). Each listed file may result in one FlowFile, the metadata being written as FlowFile attributes. When the 'Record Writer' property is set, the entire result is written as records to a single FlowFile. This Processor is designed to run on Primary Node only in a cluster. If the primary node changes, the new Primary Node will pick up where the previous node left off without duplicating all of the data.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@WritesAttributes(value={@WritesAttribute(attribute="dropbox.id", description="The Dropbox identifier of the file"), @WritesAttribute(attribute="path", description="The folder path where the file is located"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="dropbox.size", description="The size of the file"), @WritesAttribute(attribute="dropbox.timestamp", description="The server modified time of the file"), @WritesAttribute(attribute="dropbox.revision", description="Revision of the file")})
@Stateful(scopes={Scope.CLUSTER}, description="The processor stores necessary data to be able to keep track what files have been listed already. What exactly needs to be stored depends on the 'Listing Strategy'.")
@SeeAlso(value={FetchDropbox.class, PutDropbox.class})
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListDropbox
extends AbstractListProcessor<DropboxFileInfo>
implements DropboxTrait {
    public static final PropertyDescriptor FOLDER = new PropertyDescriptor.Builder().name("Folder").description("The Dropbox identifier or path of the folder from which to pull list of files. 'Folder' should match the following regular expression pattern: /.*|id:.* . Example for folder identifier: id:odTlUvbpIEAAAAAAAAAGGQ. Example for folder path: /Team1/Task1.").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("/.*|id:.*"))).defaultValue("/").build();
    public static final PropertyDescriptor RECURSIVE_SEARCH = new PropertyDescriptor.Builder().name("Search Recursively").description("Indicates whether to list files from subfolders of the Dropbox folder.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor MIN_AGE = new PropertyDescriptor.Builder().name("Minimum File Age").description("The minimum age a file must be in order to be considered; any files newer than this will be ignored.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor LISTING_STRATEGY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractListProcessor.LISTING_STRATEGY).allowableValues(new DescribedValue[]{BY_TIMESTAMPS, BY_ENTITIES, BY_TIME_WINDOW, NO_TRACKING}).build();
    public static final PropertyDescriptor TRACKING_STATE_CACHE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_STATE_CACHE).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor TRACKING_TIME_WINDOW = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_TIME_WINDOW).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor INITIAL_LISTING_TARGET = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.INITIAL_LISTING_TARGET).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CREDENTIAL_SERVICE, FOLDER, RECURSIVE_SEARCH, MIN_AGE, LISTING_STRATEGY, TRACKING_STATE_CACHE, TRACKING_TIME_WINDOW, INITIAL_LISTING_TARGET, RECORD_WRITER, ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])new ProxySpec[]{ProxySpec.HTTP_AUTH}));
    private volatile DbxClientV2 dropboxApiClient;

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.dropboxApiClient = this.getDropboxApiClient(context, this.getIdentifier());
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("dropbox-credential-service", CREDENTIAL_SERVICE.getName());
        config.renameProperty("folder", FOLDER.getName());
        config.renameProperty("recursive-search", RECURSIVE_SEARCH.getName());
        config.renameProperty("min-age", MIN_AGE.getName());
        config.renameProperty("et-state-cache", TRACKING_STATE_CACHE.getName());
        config.renameProperty("et-time-window", TRACKING_TIME_WINDOW.getName());
        config.renameProperty("et-initial-listing-target", INITIAL_LISTING_TARGET.getName());
        ProxyServiceMigration.renameProxyConfigurationServiceProperty((PropertyConfiguration)config);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Map<String, String> createAttributes(DropboxFileInfo entity, ProcessContext context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (DropboxFlowFileAttribute attribute : DropboxFlowFileAttribute.values()) {
            Optional.ofNullable(attribute.getValue(entity)).ifPresent(value -> attributes.put(attribute.getName(), (String)value));
        }
        return attributes;
    }

    protected String getPath(ProcessContext context) {
        return context.getProperty(FOLDER).evaluateAttributeExpressions().getValue();
    }

    protected List<DropboxFileInfo> performListing(ProcessContext context, Long minTimestamp, AbstractListProcessor.ListingMode listingMode) throws IOException {
        ArrayList<DropboxFileInfo> listing = new ArrayList<DropboxFileInfo>();
        String folderName = this.getPath(context);
        Boolean recursive = context.getProperty(RECURSIVE_SEARCH).asBoolean();
        Long minAge = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        try {
            Predicate<FileMetadata> metadataFilter = this.createMetadataFilter(minTimestamp, minAge);
            DbxUserListFolderBuilder listFolderBuilder = this.dropboxApiClient.files().listFolderBuilder(this.convertFolderName(folderName));
            ListFolderResult result = listFolderBuilder.withRecursive(recursive).start();
            ArrayList<FileMetadata> metadataList = new ArrayList<FileMetadata>(this.filterMetadata(result, metadataFilter));
            while (result.getHasMore()) {
                result = this.dropboxApiClient.files().listFolderContinue(result.getCursor());
                metadataList.addAll(this.filterMetadata(result, metadataFilter));
            }
            for (FileMetadata metadata : metadataList) {
                DropboxFileInfo.Builder builder = new DropboxFileInfo.Builder().id(metadata.getId()).path(this.getParentPath(metadata.getPathDisplay())).name(metadata.getName()).size(metadata.getSize()).timestamp(metadata.getServerModified().getTime()).revision(metadata.getRev());
                listing.add(builder.build());
            }
        }
        catch (DbxException e) {
            throw new IOException("Failed to list Dropbox folder [" + folderName + "]", e);
        }
        return listing;
    }

    protected boolean isListingResetNecessary(PropertyDescriptor property) {
        return LISTING_STRATEGY.equals((Object)property) || FOLDER.equals((Object)property) || RECURSIVE_SEARCH.equals((Object)property);
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected RecordSchema getRecordSchema() {
        return DropboxFileInfo.getRecordSchema();
    }

    protected Integer countUnfilteredListing(ProcessContext context) throws IOException {
        return this.performListing(context, null, AbstractListProcessor.ListingMode.CONFIGURATION_VERIFICATION).size();
    }

    protected String getListingContainerName(ProcessContext context) {
        return String.format("Dropbox Folder [%s]", this.getPath(context));
    }

    private Predicate<FileMetadata> createMetadataFilter(Long minTimestamp, Long minAge) {
        Predicate<FileMetadata> metadataFilter = FileMetadata::getIsDownloadable;
        if (minTimestamp != null && minTimestamp > 0L) {
            metadataFilter = metadataFilter.and(metadata -> metadata.getServerModified().getTime() >= minTimestamp);
        }
        if (minAge != null && minAge > 0L) {
            long maxTimestamp = System.currentTimeMillis() - minAge;
            metadataFilter = metadataFilter.and(metadata -> metadata.getServerModified().getTime() < maxTimestamp);
        }
        return metadataFilter;
    }

    private List<FileMetadata> filterMetadata(ListFolderResult result, Predicate<FileMetadata> metadataFilter) {
        return result.getEntries().stream().filter(metadata -> metadata instanceof FileMetadata).map(FileMetadata.class::cast).filter(metadataFilter).collect(Collectors.toList());
    }
}

